/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream.idle;

import com.arm.streamline.analysis.database.api.idle.IAnalysisIdleStateWriter;
import com.arm.streamline.analysis.database.api.idle.IdleState;
import com.arm.streamline.analysis.database.stream.AbstractDynamicAllocatedChannelWriter;
import com.arm.streamline.analysis.database.stream.idle.DatabaseIdleStateChannelWriter;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import org.eclipse.jdt.annotation.NonNull;

public final class DatabaseIdleStateWriter
extends AbstractDynamicAllocatedChannelWriter<DatabaseIdleStateChannelWriter, ProcessingElementReference>
implements IAnalysisIdleStateWriter {
    private final @NonNull File dbPath;

    public DatabaseIdleStateWriter(@NonNull File dbPath) {
        super(ProcessingElementReference.class);
        this.dbPath = dbPath;
    }

    @Override
    public void consumeIdleEvent(@NonNull ProcessingElementReference peReference, long time, @NonNull IdleState state) throws IOException {
        @NonNull DatabaseIdleStateChannelWriter channelWriter = (DatabaseIdleStateChannelWriter)this.getOrCreateChannel(peReference);
        channelWriter.consumeIdleEvent(time, state);
    }

    @Override
    protected @NonNull DatabaseIdleStateChannelWriter createNewChannel(@NonNull ProcessingElementReference peReference) throws IOException {
        return new DatabaseIdleStateChannelWriter(this.dbPath, peReference.vmUID, peReference.deviceNumber);
    }

    @Override
    protected boolean validChannel(@NonNull ProcessingElementReference peReference) {
        return peReference.deviceType.isCPU();
    }

    @Override
    protected @NonNull Comparator<@NonNull ProcessingElementReference> comparator() {
        return Comparator.naturalOrder();
    }
}

