/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream.idle;

import com.arm.streamline.analysis.database.api.idle.IAnalysisIdleStateChannelWriter;
import com.arm.streamline.analysis.database.api.idle.IdleState;
import com.arm.streamline.common.utility.io.CompressedOutputStream;
import com.arm.streamline.common.utility.io.Compression;
import com.arm.utils.NullChecking;
import com.arm.utils.function.Throwing;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.jdt.annotation.NonNull;

public final class DatabaseIdleStateChannelWriter
implements IAnalysisIdleStateChannelWriter {
    private static final @NonNull String FILENAME_PATTERN = "%s-%s.db.gz";
    public static final int STATE_VALUE_IDLE = 1;
    public static final int STATE_VALUE_ONLINE = 0;
    private boolean first;
    private int lastState = 0;
    private long lastTimestamp = 0L;
    private long lastWriteTimestamp = 0L;
    private final @NonNull OutputStream outputStream;

    public static @NonNull File makePath(@NonNull File directory, long vmUID, int deviceNumber) {
        return new File(directory, String.format(FILENAME_PATTERN, vmUID, deviceNumber));
    }

    private static int mapState(@NonNull IdleState state) {
        switch (state) {
            case IDLE: {
                return 1;
            }
            case ONLINE: {
                return 0;
            }
        }
        throw new AssertionError((Object)state);
    }

    public DatabaseIdleStateChannelWriter(@NonNull File idleStatePath, long vmUID, int deviceNumber) throws IOException {
        File file = DatabaseIdleStateChannelWriter.makePath(idleStatePath, vmUID, deviceNumber);
        ((File)NullChecking.neverNull((Object)file.getParentFile())).mkdirs();
        this.outputStream = (OutputStream)Throwing.closeIfThrows(gos -> new BufferedOutputStream((OutputStream)gos), (Object)((CompressedOutputStream)Throwing.closeIfThrows(fos -> new CompressedOutputStream((OutputStream)fos), (Object)new FileOutputStream(file), (Closeable[])new Closeable[0])), (Closeable[])new Closeable[0]);
    }

    DatabaseIdleStateChannelWriter(@NonNull OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }

    @Override
    public void consumeIdleEvent(long timestamp, @NonNull IdleState state) throws IOException {
        assert (this.first || this.lastTimestamp <= timestamp);
        this.first = false;
        this.lastTimestamp = timestamp;
        int stateValue = DatabaseIdleStateChannelWriter.mapState(state);
        if (stateValue != this.lastState) {
            long delta = timestamp - this.lastWriteTimestamp;
            this.lastState = stateValue;
            this.lastWriteTimestamp = timestamp;
            Compression.packInt((long)delta, (OutputStream)this.outputStream);
            Compression.packInt((long)stateValue, (OutputStream)this.outputStream);
        }
    }
}

