/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream.idle;

import com.arm.streamline.analysis.database.api.idle.IAnalysisIdleStateChannelReader;
import com.arm.streamline.analysis.database.api.idle.IdleState;
import com.arm.streamline.common.utility.io.Compression;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class DatabaseIdleStateChannelReader
implements IAnalysisIdleStateChannelReader {
    private final @NonNull InputStream inputStream;
    private long lastTimestamp = 0L;

    public DatabaseIdleStateChannelReader(@NonNull File dataFile) throws IOException {
        this.inputStream = new BufferedInputStream(new GZIPInputStream(new FileInputStream(dataFile)));
    }

    DatabaseIdleStateChannelReader(@NonNull InputStream inputStream) throws IOException {
        this.inputStream = inputStream;
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    @Override
    public @Nullable IAnalysisIdleStateChannelReader.Value read() throws IOException {
        try {
            long timestamp;
            long delta = Compression.unpackInt((InputStream)this.inputStream);
            int stateValue = (int)Compression.unpackInt((InputStream)this.inputStream);
            this.lastTimestamp = timestamp = this.lastTimestamp + delta;
            switch (stateValue) {
                case 0: {
                    return new IAnalysisIdleStateChannelReader.Value(timestamp, IdleState.ONLINE);
                }
                case 1: {
                    return new IAnalysisIdleStateChannelReader.Value(timestamp, IdleState.IDLE);
                }
            }
            throw new AssertionError(stateValue);
        }
        catch (EOFException e) {
            return null;
        }
    }
}

