/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream.chunkwriter;

import com.arm.streamline.analysis.database.stream.chunkwriter.IAnalysisCounterValueReader;
import com.arm.streamline.common.utility.io.Compression;
import com.arm.utils.function.IThrowingSupplier;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class ZeroCompressingCounterValueChunkReader
implements IAnalysisCounterValueReader {
    private @Nullable ByteBuffer buffer;
    private final @NonNull IThrowingSupplier<byte @Nullable [], IOException> chunkSupplier;
    private long lastTimestamp = 0L;
    private long lastSequenceNo = 0L;

    public ZeroCompressingCounterValueChunkReader(@NonNull IThrowingSupplier<byte @Nullable [], IOException> chunkSupplier) {
        this.chunkSupplier = chunkSupplier;
    }

    @Override
    public @Nullable IAnalysisCounterValueReader.Value next() throws IOException {
        ByteBuffer buffer = this.buffer;
        while (buffer == null || !buffer.hasRemaining()) {
            byte[] chunk = (byte[])this.chunkSupplier.get();
            if (chunk == null) {
                return null;
            }
            this.buffer = buffer = ByteBuffer.wrap(chunk);
        }
        try {
            long deltaTimestamp = Compression.unpackInt((ByteBuffer)buffer);
            long deltaSequenceno = Compression.unpackInt((ByteBuffer)buffer);
            long value = Compression.unpackInt((ByteBuffer)buffer);
            long timestamp = this.lastTimestamp + deltaTimestamp;
            long sequenceNo = this.lastSequenceNo + deltaSequenceno;
            this.lastTimestamp = timestamp;
            this.lastSequenceNo = sequenceNo;
            return new IAnalysisCounterValueReader.Value(timestamp, sequenceNo, value);
        }
        catch (BufferUnderflowException e) {
            throw new IOException(e);
        }
    }
}

