/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.api.icounter;

import com.arm.streamline.analysis.database.api.IEventReader;
import com.arm.streamline.analysis.database.api.IEventReaderValue;
import com.arm.streamline.analysis.model.threads.IExecutablePath;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.utils.NullChecking;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public interface IAnalysisRatioInstructionCounterChannelReader<T>
extends IEventReader<Value<T>> {

    public static final class Value<T>
    implements IEventReaderValue {
        public final T dataPoint;
        public final @Nullable IExecutablePath executablePath;
        public final long offsetOrAddress;
        public final @NonNull ProcessingElementReference processingElement;
        public final long timestamp;
        public final int uid;

        public Value(@NonNull ProcessingElementReference processingElement, T dataPoint, long timestamp, int uid, @Nullable IExecutablePath executablePath, long offsetOrAddress) {
            this.processingElement = processingElement;
            this.dataPoint = dataPoint;
            this.timestamp = timestamp;
            this.uid = uid;
            this.executablePath = executablePath;
            this.offsetOrAddress = offsetOrAddress;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Value) {
                Value that = (Value)obj;
                return this.timestamp == that.timestamp && this.uid == that.uid && this.offsetOrAddress == that.offsetOrAddress && this.processingElement.equals((Object)that.processingElement) && NullChecking.equalsNullable(this.dataPoint, that.dataPoint) && NullChecking.equalsNullable((Object)this.executablePath, (Object)that.executablePath);
            }
            return false;
        }

        @Override
        public long getTimestamp() {
            return this.timestamp;
        }

        public int hashCode() {
            return Long.hashCode(this.timestamp) * 31 + Integer.hashCode(this.uid);
        }

        public String toString() {
            return String.format("Value [processingElement=%s, dataPoint=%s, timestamp=%s, uid=%s, executablePath=%s, offsetOrAddress=%s]", this.processingElement, this.dataPoint, this.timestamp, this.uid, this.executablePath, this.offsetOrAddress);
        }
    }
}

