/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.api.annotations;

import com.arm.streamline.jni.apcdbgen.proto.IUniqueThreadID;
import com.arm.utils.NullChecking;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class AnnotationTextGroupChannelIdentifier {
    private final @NonNull Namespace namespace;
    private final @Nullable String title;
    private final @NonNull IUniqueThreadID uniqueThread;
    private final int value;

    public static @NonNull AnnotationTextGroupChannelIdentifier async(@NonNull IUniqueThreadID uniqueThread, @NonNull String title, int value) {
        return new AnnotationTextGroupChannelIdentifier(uniqueThread, Namespace.ASYNC, title, value);
    }

    public static @NonNull AnnotationTextGroupChannelIdentifier pushPop(@NonNull IUniqueThreadID uniqueThread, @NonNull String title, int value) {
        return new AnnotationTextGroupChannelIdentifier(uniqueThread, Namespace.PUSH_POP, title, value);
    }

    public static @NonNull AnnotationTextGroupChannelIdentifier user(@NonNull IUniqueThreadID uniqueThread, int value) {
        return new AnnotationTextGroupChannelIdentifier(uniqueThread, Namespace.USER, null, value);
    }

    private AnnotationTextGroupChannelIdentifier(@NonNull IUniqueThreadID uniqueThread, @NonNull Namespace namespace, @Nullable String title, int value) {
        this.uniqueThread = uniqueThread;
        this.namespace = namespace;
        this.title = title;
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AnnotationTextGroupChannelIdentifier) {
            AnnotationTextGroupChannelIdentifier that = (AnnotationTextGroupChannelIdentifier)obj;
            return this.value == that.value && this.sameDomainAs(that);
        }
        return false;
    }

    public int hashCode() {
        return this.value * 31 + this.namespace.hashCode();
    }

    public boolean sameDomainAs(@NonNull AnnotationTextGroupChannelIdentifier that) {
        return this.namespace.equals((Object)that.namespace) && this.uniqueThread.equals(that.uniqueThread) && NullChecking.equalsNullable((Object)this.title, (Object)that.title);
    }

    public String toString() {
        return String.format("AnnotationTextGroupChannelIdentifier [namespace=%s, value=%s, uniqueThread=%s, title=%s]", new Object[]{this.namespace, this.value, this.uniqueThread, this.title});
    }

    public @NonNull Namespace namespace() {
        return this.namespace;
    }

    public @NonNull IUniqueThreadID utid() {
        return this.uniqueThread;
    }

    public int value() {
        return this.value;
    }

    public static enum Namespace {
        ASYNC,
        PUSH_POP,
        USER;

    }
}

