/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database;

import com.arm.streamline.analysis.database.MetadataEntry;
import com.arm.streamline.analysis.model.SummaryRecord;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.report.model.pe.ProcessingElementDescriptor;
import gnu.trove.iterator.TLongObjectIterator;
import gnu.trove.map.TLongObjectMap;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class SummaryWriter {
    public static final @NonNull String SUMMARY_FILENAME = "summary.txt";
    private static final @NonNull String DURATION = "duration: ";
    private static final @NonNull String MONOTONIC = "monotonic delta: ";
    private static final @NonNull String NANO_SECONDS = " ns";
    private static final long NS_PER_MS = 1000000L;
    private static final double NS_PER_S = 1.0E9;
    private static final @NonNull String SECONDS = " s";
    private static final @NonNull String TOD = "time of day since Unix epoch: ";
    private static final @NonNull String UPTIME = "uptime: ";

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void write(@NonNull PrintStream out, long duration, @Nullable SummaryRecord summary, @NonNull Map<@NonNull String, @NonNull String> globalAttributes, @NonNull TLongObjectMap<Map<@NonNull String, @NonNull String>> vmAttributes, @NonNull Map<@NonNull ProcessingElementReference, @NonNull ProcessingElementDescriptor> processingElementProperties, @NonNull Set<@NonNull MetadataEntry> metadata) {
        out.println("Capture");
        out.println(DURATION + (double)duration / 1.0E9 + SECONDS);
        out.println();
        out.println("Target");
        if (summary != null) {
            out.println("system date: " + String.valueOf(new Date(summary.getTime() / 1000000L)));
            summary.getUptime().ifPresent(t -> out.println(UPTIME + (double)t / 1.0E9 + SECONDS));
            summary.getMonotonicDelta().ifPresent(t -> out.println(MONOTONIC + (double)t / 1.0E9 + SECONDS));
            out.println(TOD + summary.getTime() + NANO_SECONDS);
        }
        if (!globalAttributes.isEmpty()) {
            out.println("Global Attributes (for merged captures)");
            SummaryWriter.writeAttributes(out, globalAttributes);
        }
        @NonNull @NonNull TLongObjectIterator it = vmAttributes.iterator();
        while (it.hasNext()) {
            it.advance();
            long vmUID = it.key();
            @NonNull @NonNull Map map = (Map)it.value();
            if (vmUID != 0L || vmAttributes.size() != 1 || !globalAttributes.isEmpty()) {
                out.println("VM Attributes: vm # " + vmUID);
            } else {
                out.println("Capture Attributes:");
            }
            SummaryWriter.writeAttributes(out, map);
        }
        out.println("Core details: ");
        for (Map.Entry<ProcessingElementReference, ProcessingElementDescriptor> entry : processingElementProperties.entrySet()) {
            @NonNull ProcessingElementDescriptor core = entry.getValue();
            out.printf("core %s: %s (0x%05x) [%s]%n", entry.getKey(), core.getLabel(), core.getCpuid(), core.getTopology());
        }
        if (!metadata.isEmpty()) {
            out.println("Metadata tags:");
            TreeSet<MetadataEntry> sortedMetadata = new TreeSet<MetadataEntry>((a, b) -> {
                int result = Long.compare(a.vmUID, b.vmUID);
                if (result != 0) {
                    return result;
                }
                result = Integer.compare(a.key, b.key);
                if (result != 0) {
                    return result;
                }
                return a.value.compareTo(b.value);
            });
            sortedMetadata.addAll(metadata);
            boolean first = true;
            long lastVmUID = 0L;
            for (MetadataEntry entry : sortedMetadata) {
                if (first || lastVmUID != entry.vmUID) {
                    out.printf("\t%d:%n", entry.vmUID);
                    first = false;
                    lastVmUID = entry.vmUID;
                }
                switch (entry.key) {
                    case 1: {
                        out.printf("\t\tSuite: %s%n", entry.value);
                        break;
                    }
                    case 0: {
                        out.printf("\t\tEdition: %s%n", entry.value);
                        break;
                    }
                    default: {
                        out.printf("\t\t[0x%x]: %s%n", entry.key, entry.value);
                    }
                }
            }
        }
    }

    public static void write(@NonNull File input, long duration, @Nullable SummaryRecord summary, @NonNull Map<@NonNull String, @NonNull String> globalAttributes, @NonNull TLongObjectMap<Map<@NonNull String, @NonNull String>> vmAttributes, @NonNull Map<@NonNull ProcessingElementReference, @NonNull ProcessingElementDescriptor> processingElementProperties, @NonNull Set<@NonNull MetadataEntry> metadata) throws IOException {
        Throwable throwable = null;
        Object var9_9 = null;
        try (PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(new File(input, SUMMARY_FILENAME))));){
            SummaryWriter.write(out, duration, summary, globalAttributes, vmAttributes, processingElementProperties, metadata);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void writeAttributes(@NonNull PrintStream out, Map<@NonNull String, @NonNull String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            @NonNull String key = entry.getKey();
            @NonNull String value = entry.getValue();
            if (!value.isEmpty()) {
                out.printf("'%s': '%s'%n", key, value);
                continue;
            }
            out.printf("'%s'%n", key);
        }
    }
}

