/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database;

import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.model.topology.ProcessingElementReferenceSet;
import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.common.utility.io.XMLParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;

public class ProcessingElementReferenceSetReaderWriter {
    private static final String ATTR_PE = "pe";
    private static final String ATTR_VM = "vm";
    private static final String TAG_REFERENCE = "reference";
    private static final String TAG_ROOT = "pe-references";
    private static final String TAG_TYPE = "type";

    public static @NonNull ProcessingElementReferenceSet read(@NonNull File file) throws IOException {
        return ProcessingElementReferenceSetReaderWriter.read(file, true);
    }

    public static @NonNull ProcessingElementReferenceSet read(@NonNull File file, boolean required) throws IOException {
        ProcessingElementReferenceSet result;
        block17: {
            result = new ProcessingElementReferenceSet();
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (XMLParser xml = XMLParser.create((File)file);){
                    String tag;
                    String marker = xml.getMarker();
                    while ((tag = xml.nextTag(marker)) != null) {
                        if (TAG_ROOT.equals(tag)) {
                            String markerType = xml.getMarker();
                            while ((tag = xml.nextTag(markerType)) != null) {
                                if (TAG_TYPE.equals(tag)) {
                                    @NonNull DeviceType deviceType = DeviceType.read((XMLParser)xml, (boolean)false);
                                    String markerInner = xml.getMarker();
                                    while ((tag = xml.nextTag(markerInner)) != null) {
                                        if (TAG_REFERENCE.equals(tag)) {
                                            long vmUID = xml.getLongAttribute(ATTR_VM);
                                            int deviceNumber = xml.getIntegerAttribute(ATTR_PE);
                                            result.get(deviceType, vmUID, deviceNumber);
                                            continue;
                                        }
                                        xml.skip();
                                    }
                                    continue;
                                }
                                xml.skip();
                            }
                            continue;
                        }
                        xml.skip();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (FileNotFoundException e) {
                if (!required) break block17;
                throw e;
            }
        }
        return result;
    }

    public static void write(@NonNull File file, @NonNull ProcessingElementReferenceSet peReferenceSet) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (XMLGenerator xml = XMLGenerator.create((File)file);){
            xml.startDocument();
            xml.startTag(TAG_ROOT);
            for (Map.Entry entry : peReferenceSet) {
                xml.startTag(TAG_TYPE);
                ((DeviceType)entry.getKey()).write(xml);
                for (ProcessingElementReference reference : (List)entry.getValue()) {
                    xml.startEmptyTag(TAG_REFERENCE);
                    xml.addAttribute(ATTR_VM, reference.vmUID);
                    xml.addAttribute(ATTR_PE, reference.deviceNumber);
                }
                xml.endTag();
            }
            xml.endTag();
            xml.endDocument();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

