/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database;

import com.arm.streamline.analysis.model.ChannelDescriptorUtils;
import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.model.topology.ProcessingElementReferenceSet;
import com.arm.streamline.common.utility.Ternary;
import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.utils.ArrayUtils;
import com.arm.utils.NullChecking;
import gnu.trove.list.array.TIntArrayList;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class EventsChart {
    public static final @NonNull String CHARTFILE = "chart.xml";
    public static final int SYSTEM_INDEX = 1;
    public static final int USER_INDEX = 0;
    private static final @NonNull String ATTR_ALPHA = "alpha";
    private static final @NonNull String ATTR_BLUE = "blue";
    private static final @NonNull String ATTR_CORES = "cores";
    private static final @NonNull String ATTR_DESCRIPTION = "description";
    private static final @NonNull String ATTR_GREEN = "green";
    private static final @NonNull String ATTR_NAME = "name";
    private static final @NonNull String ATTR_PER_CORE = "per_core";
    private static final @NonNull String ATTR_RED = "red";
    private static final @NonNull String ATTR_PROC = "proc";
    private static final @NonNull String ATTR_SOURCE_FILTERABLE = "source_filterable";
    private static final @NonNull String ATTR_TITLE = "title";
    private static final @NonNull String ATTR_VERSION = "version";
    private static final @NonNull String TAG_CHANNEL_DESCRIPTOR = "channel-mapping";
    private static final @NonNull String TAG_CHART = "chart";
    private static final @NonNull String TAG_SOURCE = "source";
    private static final int EXPECTED_VERSION = 3;
    private final @NonNull ProcessingElementReference @NonNull [] mChannelDescriptors;
    private final int @NonNull [] mColors;
    private final int mCores;
    private final @NonNull String @NonNull [] mDescriptions;
    private final @NonNull DeviceType mDeviceType;
    private final @NonNull String @NonNull [] mNames;
    private final boolean mPerCore;
    private final @NonNull String mTitle;
    private final boolean mProc;
    private final boolean mSourceFilterable;

    public static @NonNull EventsChart read(@NonNull File path, @NonNull ProcessingElementReferenceSet processingElementsReferenceSet) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (XMLParser in = XMLParser.create((File)new File(path, CHARTFILE));){
            String tag;
            String marker = in.getMarker();
            while ((tag = in.nextTag(marker)) != null) {
                if (TAG_CHART.equals(tag)) {
                    int version = in.getIntegerAttribute(ATTR_VERSION, 0);
                    if (version != 3) {
                        throw new IOException("chart.xml version is not v2");
                    }
                    @NonNull String title = (String)NullChecking.neverNull((Object)in.getAttribute(ATTR_TITLE));
                    boolean perCore = in.isAttributeSet(ATTR_PER_CORE, true);
                    boolean proc = in.isAttributeSet(ATTR_PROC, true);
                    boolean sourceFilterable = in.isAttributeSet(ATTR_SOURCE_FILTERABLE, false);
                    @NonNull DeviceType deviceType = DeviceType.read((XMLParser)in, (!perCore ? 1 : 0) != 0);
                    int cores = in.getIntegerAttribute(ATTR_CORES, 1);
                    @NonNull ArrayList<@NonNull String> names = new ArrayList<String>();
                    @NonNull ArrayList<@NonNull String> descriptions = new ArrayList<String>();
                    @NonNull TIntArrayList colors = new TIntArrayList();
                    @NonNull ArrayList<@NonNull ProcessingElementReference> channelDescriptors = new ArrayList<ProcessingElementReference>();
                    String marker2 = in.getMarker();
                    while ((tag = in.nextTag(marker2)) != null) {
                        if (TAG_SOURCE.equals(tag)) {
                            EventsChart.chartSourceTag(in, names, descriptions, colors);
                            continue;
                        }
                        if (TAG_CHANNEL_DESCRIPTOR.equals(tag)) {
                            channelDescriptors.add(new ProcessingElementReference(in));
                            continue;
                        }
                        in.skip();
                    }
                    return new EventsChart(cores, perCore, proc, title, deviceType, channelDescriptors.toArray(new ProcessingElementReference[channelDescriptors.size()]), names.toArray(new String[names.size()]), descriptions.toArray(new String[descriptions.size()]), (int[])NullChecking.neverNull((Object)colors.toArray()), sourceFilterable);
                }
                in.skip();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throw new IOException("Invalid charts file: " + String.valueOf(new File(path, CHARTFILE)));
    }

    public static @NonNull EventsChart read(@NonNull String path, int cores, @NonNull DeviceType dt, @NonNull ProcessingElementReferenceSet processingElementsReferenceSet) throws IOException {
        try {
            @NonNull EventsChart result = EventsChart.read(path, processingElementsReferenceSet);
            if (result.mCores < cores) {
                throw new IOException("EventsChart: core count does not match XML");
            }
            return result;
        }
        catch (FileNotFoundException fnf) {
            assert (!dt.isCPU() && !dt.isSystemWide());
            File dir = new File(path);
            String filename = dir.getName();
            return new EventsChart(cores, false, true, filename.replace('_', ' '), dt, ChannelDescriptorUtils.makeChannelDescriptors(processingElementsReferenceSet, cores, dt), new String[]{"Activity"}, new String[]{"Processing unit activity"}, new int[]{-2147418368}, true);
        }
    }

    public static @NonNull EventsChart read(@NonNull String path, @NonNull ProcessingElementReferenceSet processingElementsReferenceSet) throws IOException {
        return EventsChart.read(new File(path), processingElementsReferenceSet);
    }

    public static @Nullable EventsChart tryRead(@NonNull File path, @NonNull ProcessingElementReferenceSet processingElementsReferenceSet) {
        try {
            return EventsChart.read(path, processingElementsReferenceSet);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static void write(@NonNull EventsChart chart, @NonNull File path) {
        if (chart.mNames.length == 0) {
            return;
        }
        if (chart.mDescriptions.length == 0) {
            return;
        }
        if (chart.mColors.length == 0) {
            return;
        }
        if (chart.mNames.length != chart.mDescriptions.length) {
            return;
        }
        if (chart.mNames.length != chart.mColors.length) {
            return;
        }
        try {
            CommonFileUtils.makeDirectory((File)path);
            Throwable throwable = null;
            Object var3_5 = null;
            try (XMLGenerator xml = XMLGenerator.create((File)new File(path, CHARTFILE));){
                xml.startDocument();
                xml.startTag(TAG_CHART);
                xml.addAttribute(ATTR_VERSION, 3);
                xml.addAttribute(ATTR_TITLE, chart.mTitle);
                xml.addAttribute(ATTR_PER_CORE, chart.mPerCore);
                xml.addAttribute(ATTR_PROC, chart.mProc);
                xml.addAttribute(ATTR_SOURCE_FILTERABLE, chart.mSourceFilterable);
                xml.addAttribute(ATTR_CORES, chart.mCores);
                chart.mDeviceType.write(xml);
                int i = 0;
                while (i < chart.mNames.length) {
                    xml.startTag(TAG_SOURCE);
                    xml.addAttribute(ATTR_NAME, chart.mNames[i]);
                    xml.addAttribute(ATTR_DESCRIPTION, chart.mDescriptions[i]);
                    xml.addAttribute(ATTR_ALPHA, chart.mColors[i] >> 24 & 0xFF);
                    xml.addAttribute(ATTR_RED, chart.mColors[i] >> 16 & 0xFF);
                    xml.addAttribute(ATTR_GREEN, chart.mColors[i] >> 8 & 0xFF);
                    xml.addAttribute(ATTR_BLUE, chart.mColors[i] & 0xFF);
                    xml.endTag();
                    ++i;
                }
                ProcessingElementReference[] processingElementReferenceArray = chart.mChannelDescriptors;
                int n = chart.mChannelDescriptors.length;
                int n2 = 0;
                while (n2 < n) {
                    ProcessingElementReference peReference = processingElementReferenceArray[n2];
                    xml.startEmptyTag(TAG_CHANNEL_DESCRIPTOR);
                    peReference.write(xml);
                    ++n2;
                }
                xml.endTag();
                xml.endDocument();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            CommonPlugin.error((String)"Unable to write charts.xml", (Throwable)e);
        }
    }

    public static void write(@NonNull EventsChart chart, @NonNull String path) {
        EventsChart.write(chart, new File(path));
    }

    public static void write(@NonNull File dbPath, @NonNull CounterRecord counterRecord, @NonNull List<@NonNull ProcessingElementReference> peReferences) {
        EventsChart eventsChart = new EventsChart(counterRecord, peReferences);
        EventsChart.write(eventsChart, dbPath);
    }

    private static void chartSourceTag(XMLParser in, List<String> names, List<String> descriptions, TIntArrayList colors) {
        String name = in.getAttribute(ATTR_NAME);
        String description = in.getAttribute(ATTR_DESCRIPTION);
        int alpha = in.getIntegerAttribute(ATTR_ALPHA, 0) & 0xFF;
        int red = in.getIntegerAttribute(ATTR_RED, 0) & 0xFF;
        int green = in.getIntegerAttribute(ATTR_GREEN, 0) & 0xFF;
        int blue = in.getIntegerAttribute(ATTR_BLUE, 0) & 0xFF;
        int color = alpha << 24 | red << 16 | green << 8 | blue;
        names.add(name);
        descriptions.add(description);
        colors.add(color);
    }

    public EventsChart(int cores, boolean perCore, boolean proc, @NonNull String title, @NonNull DeviceType type, @NonNull ProcessingElementReference @NonNull [] channelDescriptors, @NonNull String @NonNull [] names, @NonNull String @NonNull [] descriptions, int @NonNull [] colors, boolean isSourceFilterable) {
        this.mCores = cores;
        this.mPerCore = perCore;
        this.mProc = proc;
        this.mTitle = title;
        this.mDeviceType = type;
        this.mNames = names;
        this.mDescriptions = descriptions;
        this.mColors = colors;
        this.mChannelDescriptors = channelDescriptors;
        this.mSourceFilterable = isSourceFilterable;
        Arrays.sort(channelDescriptors, Comparator.naturalOrder());
    }

    public EventsChart(@NonNull CounterRecord counterRecord) {
        this(counterRecord, Arrays.asList((ProcessingElementReference[])NullChecking.neverNull((Object[])counterRecord.getChannelDescriptions())));
    }

    public EventsChart(@NonNull CounterRecord counterRecord, @NonNull List<@NonNull ProcessingElementReference> peReferences) {
        this(peReferences.size(), counterRecord.isPerCPU(), !Ternary.FALSE.equals((Object)counterRecord.isProc()), (String)NullChecking.neverNull((Object)counterRecord.getTitle()), counterRecord.getDeviceTypeOrDefault(), peReferences.toArray(new ProcessingElementReference[peReferences.size()]), counterRecord.getActivity().toArray(new String[counterRecord.getActivity().size()]), (String[])ArrayUtils.createNonNull(String[]::new, (int)counterRecord.getActivity().size(), i -> (String)NullChecking.neverNullOr((Object)counterRecord.getDescription(), (Object)"")), (int[])NullChecking.neverNull((Object)counterRecord.getActivityColor().toArray()), counterRecord.isSourceFilterable());
    }

    public @NonNull ProcessingElementReference @NonNull [] getChannelDescriptors() {
        return this.mChannelDescriptors;
    }

    public int @NonNull [] getColors() {
        return this.mColors;
    }

    public int getCores() {
        return this.mCores;
    }

    public @NonNull String @NonNull [] getDescriptions() {
        return this.mDescriptions;
    }

    public @NonNull DeviceType getDeviceType() {
        return this.mDeviceType;
    }

    public @NonNull String @NonNull [] getNames() {
        return this.mNames;
    }

    public boolean getPerCore() {
        return this.mPerCore;
    }

    public @NonNull String getTitle() {
        return this.mTitle;
    }

    public boolean isProc() {
        return this.mProc;
    }

    public boolean isSourceFilterable() {
        return this.mSourceFilterable;
    }
}

