/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database;

import com.arm.streamline.analysis.model.threads.IUniqueProcess;
import com.arm.streamline.analysis.model.threads.IUniqueProcessOrThread;
import com.arm.streamline.analysis.model.threads.IUniqueThread;
import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.report.model.uids.AbstractPerVmId;
import com.arm.streamline.report.model.uids.AbstractUniqueIdentifier;
import com.arm.streamline.report.model.uids.IUniqueIds;
import com.arm.streamline.report.model.uids.UniqueProcess;
import com.arm.streamline.report.model.uids.UniqueThread;
import com.arm.utils.function.Throwing;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ApplicationsWriter {
    public static final @NonNull String ATTR_END_TIME = "end";
    public static final @NonNull String ATTR_IS_IDLE = "idle";
    public static final @NonNull String ATTR_IS_KERNEL = "kernel";
    public static final @NonNull String ATTR_NAME = "name";
    public static final @NonNull String ATTR_PID = "pid";
    public static final @NonNull String ATTR_START_TIME = "start";
    public static final @NonNull String ATTR_TID = "tid";
    public static final @NonNull String ATTR_UID = "uid";
    public static final @NonNull String ATTR_VMUID = "vmUID";
    public static final @NonNull String TAG_APPLICATIONS = "applications";
    public static final @NonNull String TAG_PROCESS = "process";
    public static final @NonNull String TAG_THREAD = "thread";
    private static final @NonNull String ATTR_VERSION = "version";

    public static void write(@NonNull File file, @NonNull IUniqueIds uniqueID) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (XMLGenerator xml = XMLGenerator.create((File)file);){
            xml.startDocument();
            xml.startTag(TAG_APPLICATIONS);
            xml.addAttribute(ATTR_VERSION, 1);
            Throwing.forEach((Stream)uniqueID.getProcesses(), upid -> {
                xml.startTag(TAG_PROCESS);
                ApplicationsWriter.writeProcess(xml, upid);
                Throwing.forEach((Stream)uniqueID.getThreadsOf(upid), utid -> {
                    assert (((AbstractPerVmId.PerVmNonUniqueTid)utid.nonUid.getId()).vmUID == ((AbstractPerVmId.PerVmNonUniquePid)uniqueProcess.nonUid.getId()).vmUID);
                    xml.startEmptyTag(TAG_THREAD);
                    ApplicationsWriter.writeThread(xml, utid);
                });
                xml.endTag();
            });
            xml.endTag();
            xml.endDocument();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void write(@NonNull File file, @NonNull Map<@NonNull IUniqueProcess, @NonNull Set<@NonNull IUniqueThread>> threadsByProcessThread) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (XMLGenerator xml = XMLGenerator.create((File)file);){
            xml.startDocument();
            xml.startTag(TAG_APPLICATIONS);
            xml.addAttribute(ATTR_VERSION, 1);
            for (Map.Entry<IUniqueProcess, Set<IUniqueThread>> entry : threadsByProcessThread.entrySet()) {
                @NonNull IUniqueProcess processThread = entry.getKey();
                @NonNull Set<@NonNull IUniqueThread> threads = entry.getValue();
                xml.startTag(TAG_PROCESS);
                ApplicationsWriter.writeProcess(xml, processThread);
                for (IUniqueThread thread : threads) {
                    xml.startEmptyTag(TAG_THREAD);
                    ApplicationsWriter.writeThread(xml, thread);
                }
                xml.endTag();
            }
            xml.endTag();
            xml.endDocument();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static long pickEndTime(@NonNull IUniqueProcessOrThread thread) {
        @Nullable Long endTimestamp = thread.getEndTimestamp();
        if (endTimestamp != null) {
            return Math.max(endTimestamp, thread.getLastSeenTimestamp());
        }
        return Long.MAX_VALUE;
    }

    private static long pickStartTime(@NonNull IUniqueProcessOrThread thread) {
        @Nullable Long startTime = thread.getStartTimestamp();
        if (startTime != null) {
            return Math.min(startTime, thread.getEarliestSeenTimestamp());
        }
        return thread.getEarliestSeenTimestamp();
    }

    private static void writeProcess(XMLGenerator xml, @NonNull IUniqueProcess processThread) throws IOException {
        xml.addAttribute(ATTR_PID, processThread.getOriginalID());
        xml.addAttribute(ATTR_VMUID, processThread.getVmUID());
        ApplicationsWriter.writeSharedAttributes(xml, processThread);
    }

    private static void writeProcess(@NonNull XMLGenerator xml, @NonNull UniqueProcess uid) throws IOException {
        // Could not load outer class - annotation placement on inner may be incorrect
         @NonNull AbstractPerVmId.PerVmNonUniquePid vmPidOrTid = (AbstractPerVmId.PerVmNonUniquePid)uid.getNonUid().getId();
        xml.addAttribute(ATTR_PID, vmPidOrTid.id);
        xml.addAttribute(ATTR_VMUID, vmPidOrTid.vmUID);
        ApplicationsWriter.writeSharedAttributes(xml, uid);
    }

    private static void writeSharedAttributes(@NonNull XMLGenerator xml, @NonNull AbstractUniqueIdentifier<?> uid) throws IOException {
        xml.addAttribute(ATTR_UID, uid.getUid());
        xml.addAttributeNot(ATTR_NAME, uid.getNonUid().getName(), null);
        xml.addAttributeNot(ATTR_START_TIME, uid.getNonUid().getStartTime(), Long.MIN_VALUE);
        xml.addAttributeNot(ATTR_END_TIME, uid.getNonUid().getEndTime(), Long.MAX_VALUE);
    }

    private static void writeSharedAttributes(@NonNull XMLGenerator xml, @NonNull IUniqueProcessOrThread thread) throws IOException {
        xml.addAttribute(ATTR_UID, thread.getUID());
        xml.addAttributeNot(ATTR_NAME, thread.getName(), null);
        xml.addAttributeNot(ATTR_START_TIME, ApplicationsWriter.pickStartTime(thread), -1L);
        xml.addAttributeNot(ATTR_END_TIME, ApplicationsWriter.pickEndTime(thread), Long.MAX_VALUE);
    }

    private static void writeThread(@NonNull XMLGenerator xml, @NonNull IUniqueThread thread) throws IOException {
        xml.addAttribute(ATTR_TID, thread.getOriginalID());
        xml.addAttribute(ATTR_IS_KERNEL, thread.isKernel());
        xml.addAttribute(ATTR_IS_IDLE, thread.isIdle());
        ApplicationsWriter.writeSharedAttributes(xml, thread);
    }

    private static void writeThread(@NonNull XMLGenerator xml, @NonNull UniqueThread uid) throws IOException {
        // Could not load outer class - annotation placement on inner may be incorrect
         @NonNull AbstractPerVmId.PerVmNonUniqueTid vmPidOrTid = (AbstractPerVmId.PerVmNonUniqueTid)uid.getNonUid().getId();
        xml.addAttribute(ATTR_TID, vmPidOrTid.id);
        xml.addAttribute(ATTR_IS_KERNEL, uid.isKernel());
        xml.addAttribute(ATTR_IS_IDLE, uid.isIdle());
        ApplicationsWriter.writeSharedAttributes(xml, uid);
    }
}

