/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database;

import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.streamline.report.model.uids.AbstractPerVmId;
import com.arm.streamline.report.model.uids.IUniqueIds;
import com.arm.streamline.report.model.uids.NonUniqueId;
import com.arm.streamline.report.model.uids.UniqueIds;
import com.arm.streamline.report.model.uids.UniqueProcess;
import com.arm.streamline.report.model.uids.UniqueThread;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.jdt.annotation.NonNull;

public class ApplicationsReader {
    public static @NonNull IUniqueIds read(@NonNull File input) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (XMLParser in = XMLParser.create((File)input);){
            return ApplicationsReader.read(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static @NonNull IUniqueIds read(XMLParser in) throws IOException {
        String tag;
        @NonNull TLongObjectHashMap kernelProcesses = new TLongObjectHashMap();
        @NonNull ArrayList<@NonNull UniqueThread> threads = new ArrayList<UniqueThread>();
        @NonNull ArrayList<@NonNull UniqueProcess> processes = new ArrayList<UniqueProcess>();
        String marker = in.getMarker();
        while ((tag = in.nextTag(marker)) != null) {
            if ("applications".equals(tag)) {
                String applicationsMarker = in.getMarker();
                while ((tag = in.nextTag(applicationsMarker)) != null) {
                    if (!"process".equals(tag)) continue;
                    int upid = in.getIntegerAttribute("uid", -1);
                    @NonNull NonUniqueId<// Could not load outer class - annotation placement on inner may be incorrect
                    AbstractPerVmId.PerVmNonUniquePid> pid = ApplicationsReader.readNonUniquePid(in);
                    @NonNull UniqueProcess process = new UniqueProcess(pid, upid);
                    processes.add(process);
                    String processTag = in.getMarker();
                    while ((tag = in.nextTag(processTag)) != null) {
                        if (!"thread".equals(tag)) continue;
                        @NonNull NonUniqueId<// Could not load outer class - annotation placement on inner may be incorrect
                        AbstractPerVmId.PerVmNonUniqueTid> tid = ApplicationsReader.readNonUniqueTid(in, ((AbstractPerVmId.PerVmNonUniquePid)pid.getId()).vmUID);
                        int utid = in.getIntegerAttribute("uid", -1);
                        boolean isKernel = in.isAttributeSet("kernel", ((AbstractPerVmId.PerVmNonUniquePid)pid.getId()).id < 0);
                        boolean isIdle = in.isAttributeSet("idle", ((AbstractPerVmId.PerVmNonUniqueTid)tid.getId()).id == 0);
                        @NonNull UniqueThread thread = new UniqueThread(ApplicationsReader.fixIdleName(tid, isIdle), utid, isIdle, isKernel, process);
                        threads.add(thread);
                        if (!isKernel) continue;
                        kernelProcesses.put(((AbstractPerVmId.PerVmNonUniquePid)process.nonUid.getId()).vmUID, (Object)process);
                    }
                }
                continue;
            }
            in.skip();
        }
        return new UniqueIds((TLongObjectMap)kernelProcesses, threads, processes);
    }

    private static @NonNull NonUniqueId<// Could not load outer class - annotation placement on inner may be incorrect
    AbstractPerVmId.PerVmNonUniqueTid> fixIdleName(@NonNull NonUniqueId<// Could not load outer class - annotation placement on inner may be incorrect
    AbstractPerVmId.PerVmNonUniqueTid> id, boolean isIdle) {
        if (isIdle && id.getName() == null) {
            return new NonUniqueId(id.getStartTime(), id.getEndTime(), (AbstractPerVmId.PerVmNonUniquePidOrTid)((AbstractPerVmId.PerVmNonUniqueTid)id.getId()), "idle");
        }
        return id;
    }

    private static <T extends AbstractPerVmId.PerVmNonUniquePidOrTid> @NonNull NonUniqueId<T> readNonUniqueId(@NonNull XMLParser in, @NonNull T id) {
        String name = in.getAttribute("name");
        long startTime = in.getLongAttribute("start", Long.MIN_VALUE);
        long endTime = in.getLongAttribute("end", Long.MAX_VALUE);
        return new NonUniqueId(startTime, endTime, id, name);
    }

    private static @NonNull NonUniqueId<// Could not load outer class - annotation placement on inner may be incorrect
    AbstractPerVmId.PerVmNonUniquePid> readNonUniquePid(@NonNull XMLParser in) {
        int id = in.getIntegerAttribute("pid", -1);
        long vmUID = in.getLongAttribute("vmUID", 0L);
        return ApplicationsReader.readNonUniqueId(in, new AbstractPerVmId.PerVmNonUniquePid(vmUID, id));
    }

    private static @NonNull NonUniqueId<// Could not load outer class - annotation placement on inner may be incorrect
    AbstractPerVmId.PerVmNonUniqueTid> readNonUniqueTid(@NonNull XMLParser in, long vmUID) {
        int id = in.getIntegerAttribute("tid", -1);
        return ApplicationsReader.readNonUniqueId(in, new AbstractPerVmId.PerVmNonUniqueTid(vmUID, id));
    }
}

