/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.deviceconn.ssh;

import com.arm.streamline.deviceconn.IBasicInteractiveShell;
import com.arm.streamline.deviceconn.IInteractiveCommand;
import com.arm.streamline.deviceconn.lib.ISelfCleaningSession;
import com.arm.streamline.deviceconn.ssh.ISshCommandRunner;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.NonNull;

public class SshSelfCleaningSession
implements ISelfCleaningSession {
    private final @NonNull ISshCommandRunner commandRunner;
    private final @NonNull List<Runnable> cleanupActions;
    private final @NonNull Consumer<String> nonFatalErrorLogger;
    private static final String REMOTE_TMP_ROOT = "/tmp/";

    static @NonNull String joinDir(@NonNull String dir, @NonNull String fileName) throws IOException {
        String validDir = dir.replace('\\', '/').replaceAll("/+$", "");
        String validName = Path.of(fileName, new String[0]).getFileName().toString();
        if (!validName.equals(fileName) || validName.contains(".") || validName.contains("..")) {
            throw new IOException("Invalid remote filename: " + fileName);
        }
        return validDir.isEmpty() ? "/" + validName : validDir + "/" + validName;
    }

    public SshSelfCleaningSession(@NonNull ISshCommandRunner commandRunner, @NonNull Consumer<String> nonFatalErrorLogger) {
        this.commandRunner = commandRunner;
        this.nonFatalErrorLogger = nonFatalErrorLogger;
        this.cleanupActions = new ArrayList<Runnable>();
    }

    public @NonNull ISelfCleaningSession.IRemoteExecutable pushExecutable(@NonNull File exe, @NonNull String name, @NonNull String destination) throws IOException, ISelfCleaningSession.CommandFailedException {
        String packageExePath = this.pushFileAndSetPermissions(exe, name, "0777", destination);
        return new RemoteExecutable(packageExePath);
    }

    @Override
    public @NonNull ISelfCleaningSession.IRemoteExecutable pushExecutable(@NonNull File exe, @NonNull String name) throws IOException, ISelfCleaningSession.CommandFailedException {
        String packageExePath = this.pushFileAndSetPermissions(exe, name, "0777");
        return new RemoteExecutable(packageExePath);
    }

    @Override
    public @NonNull ISelfCleaningSession.IRemoteExecutable pushExecutable(@NonNull File exe) throws IOException, ISelfCleaningSession.CommandFailedException {
        return this.pushExecutable(exe, exe.getName());
    }

    @Override
    public void pushFile(@NonNull File file, @NonNull String name) throws IOException, ISelfCleaningSession.CommandFailedException {
        this.pushFileAndSetPermissions(file, name, "0666");
    }

    @Override
    public void pushFile(@NonNull File file) throws IOException, ISelfCleaningSession.CommandFailedException {
        this.pushFile(file, file.getName());
    }

    private @NonNull String pushFileAndSetPermissions(@NonNull File file, @NonNull String name, @NonNull String permissions) throws IOException, ISelfCleaningSession.CommandFailedException {
        return this.pushFileAndSetPermissions(file, name, permissions, REMOTE_TMP_ROOT);
    }

    private @NonNull String pushFileAndSetPermissions(@NonNull File file, @NonNull String name, @NonNull String permissions, @NonNull String destination) throws IOException, ISelfCleaningSession.CommandFailedException {
        String remotePath = this.commandRunner.scpPush(file, SshSelfCleaningSession.joinDir(destination.replace("~/", this.commandRunner.getUserHome() + "/"), name));
        this.cleanupActions.add(() -> this.removeRemoteFile(remotePath));
        IBasicInteractiveShell.InteractiveCommandResult chmodResult = this.commandRunner.runCommandAndGetOutput("chmod", permissions, remotePath);
        if (!chmodResult.status.isSuccessful()) {
            throw new ISelfCleaningSession.CommandFailedException("Failed to set permissions of file on remote device", chmodResult);
        }
        return remotePath;
    }

    private void removeRemoteFile(@NonNull String file) {
        try {
            IBasicInteractiveShell.InteractiveCommandResult result = this.commandRunner.runCommandAndGetOutput("rm", "-f", file);
            if (!result.status.isSuccessful()) {
                this.nonFatalErrorLogger.accept("Error removing remote file \"" + file + "\": " + result.errorsAndOutputJoined());
            }
        }
        catch (IOException e) {
            this.nonFatalErrorLogger.accept("Error removing remote file \"" + file + "\": " + e.getMessage());
        }
    }

    @Override
    public void close() throws Exception {
        this.cleanUp(() -> {});
    }

    @Override
    public int getNumberOfCleanUpActions() {
        return this.cleanupActions.size();
    }

    @Override
    public void cleanUp(Runnable actionCallback) {
        for (Runnable action : this.cleanupActions) {
            action.run();
            actionCallback.run();
        }
        this.cleanupActions.clear();
    }

    private class RemoteExecutable
    implements ISelfCleaningSession.IRemoteExecutable {
        private final @NonNull String exePath;

        private RemoteExecutable(String exePath) {
            this.exePath = exePath;
        }

        @Override
        public @NonNull IInteractiveCommand runExe(String ... args) throws IOException {
            return SshSelfCleaningSession.this.commandRunner.runInteractiveCommand(this.exePath, args);
        }

        @Override
        public @NonNull String getPath() {
            return this.exePath;
        }
    }
}

