/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.deviceconn.ssh;

import com.arm.streamline.deviceconn.ssh.BasicSshDeviceConnection;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public final class SshDeviceConfiguration {
    public static final int PORT = 22;
    private final @NonNull BasicSshDeviceConnection.SshSessionCredentials sessionCredentials;

    public SshDeviceConfiguration(@NonNull String hostname, int port, @NonNull String username, @NonNull File keyfile) throws FileNotFoundException {
        if (!keyfile.exists() || !keyfile.isFile()) {
            throw new FileNotFoundException("PrivateKey file could not be found at path: " + keyfile.getPath());
        }
        this.sessionCredentials = new BasicSshDeviceConnection.SshSessionCredentials(hostname, port, username, null, List.of(keyfile));
    }

    public SshDeviceConfiguration(@NonNull String hostname, int port, @NonNull String username, @NonNull List<@NonNull File> keyfiles) throws FileNotFoundException {
        if (keyfiles.isEmpty()) {
            throw new IllegalArgumentException("No keyfiles provided");
        }
        for (File keyfile : keyfiles) {
            if (keyfile.exists() && keyfile.isFile()) continue;
            throw new FileNotFoundException("PrivateKey file could not be found at path: " + keyfile.getPath());
        }
        this.sessionCredentials = new BasicSshDeviceConnection.SshSessionCredentials(hostname, port, username, null, keyfiles);
    }

    public SshDeviceConfiguration(@NonNull String hostname, int port, @NonNull String username, @NonNull String password) {
        this.sessionCredentials = new BasicSshDeviceConnection.SshSessionCredentials(hostname, port, username, password, Collections.emptyList());
    }

    public SshDeviceConfiguration(@NonNull String hostname, @NonNull String username, @NonNull File keyfile) throws FileNotFoundException {
        this(hostname, 22, username, keyfile);
    }

    public SshDeviceConfiguration(@NonNull String hostname, @NonNull String username, @NonNull String password) {
        this(hostname, 22, username, password);
    }

    public @NonNull BasicSshDeviceConnection.SshSessionCredentials getSessionCredentials() {
        return this.sessionCredentials;
    }

    public boolean isRoot() {
        return "root".contentEquals(this.sessionCredentials.username());
    }
}

