/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.deviceconn.ssh;

import com.arm.utils.NullChecking;
import com.arm.utils.collections.Pair;
import com.arm.utils.io.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.schmizz.sshj.userauth.keyprovider.KeyFormat;
import net.schmizz.sshj.userauth.keyprovider.KeyProviderUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class OpenSSHConfigParser {
    public static final int DEFAULT_PORT = 22;

    public static @NonNull String getDefaultSshUserName() {
        String name = System.getProperty("user.name");
        if (name != null) {
            return name;
        }
        return "root";
    }

    public static @NonNull OpenSSHConfig parse(@NonNull List<@NonNull Token> tokens, @Nullable OpenSSHConfig defaults) throws ParseError {
        OpenSSHConfig result = new OpenSSHConfig();
        while (!tokens.isEmpty()) {
            tokens = OpenSSHConfigParser.parseHost(tokens, result);
        }
        if (defaults != null) {
            result.appendDefaults(defaults);
        }
        return result;
    }

    public static @NonNull OpenSSHConfig parseConfigFile(@NonNull File path) {
        return OpenSSHConfigParser.parseConfigFile(path, null);
    }

    public static @NonNull OpenSSHConfig parseConfigFile(@NonNull File path, @Nullable OpenSSHConfig defaults) {
        try {
            String contents = OpenSSHConfigParser.readFileContents(path);
            List<Token> tokens = Tokenizer.tokenize(contents);
            return OpenSSHConfigParser.parse(tokens, defaults);
        }
        catch (ParseError | IOException e) {
            if (defaults != null) {
                return defaults;
            }
            return new OpenSSHConfig();
        }
    }

    public static @NonNull OpenSSHConfig parseSystemConfig() {
        File path = new File("/etc/ssh/ssh_config");
        if (path.canRead()) {
            return OpenSSHConfigParser.parseConfigFile(path);
        }
        path = new File("C:/ProgramData/ssh/ssh_config");
        if (path.canRead()) {
            return OpenSSHConfigParser.parseConfigFile(path);
        }
        return new OpenSSHConfig();
    }

    public static @NonNull OpenSSHConfig parseUserConfig() {
        OpenSSHConfig systemDefaults = OpenSSHConfigParser.parseSystemConfig();
        String userHome = System.getProperty("user.home");
        if (userHome == null || userHome.isEmpty()) {
            return systemDefaults;
        }
        File dir = new File(userHome, ".ssh");
        File config = new File(dir, "config");
        return OpenSSHConfigParser.parseConfigFile(config, systemDefaults);
    }

    private static @NonNull String asStringArg(@NonNull List<@NonNull Token> tokens) throws ParseError {
        if (tokens.size() == 3) {
            if (tokens.get(1).type() != TokenType.EQUALS) {
                throw new ParseError("Unexpected token, expected keyword line: ", tokens);
            }
            switch (tokens.get(2).type()) {
                case HOST_NAME: 
                case IDENTITY_FILE: 
                case INCLUDE: 
                case PORT: 
                case USER: 
                case WORD: {
                    return tokens.get(2).image();
                }
                case COMMA: 
                case EOL: 
                case EQUALS: 
                case HOST: 
                case INVALID: {
                    throw new ParseError("Unexpected token, expected keyword line: ", tokens);
                }
            }
            throw new AssertionError(tokens.get(2));
        }
        if (tokens.size() == 2) {
            switch (tokens.get(1).type()) {
                case HOST_NAME: 
                case IDENTITY_FILE: 
                case INCLUDE: 
                case PORT: 
                case USER: 
                case WORD: {
                    return tokens.get(1).image();
                }
                case COMMA: 
                case EOL: 
                case EQUALS: 
                case HOST: 
                case INVALID: {
                    throw new ParseError("Unexpected token, expected keyword line: ", tokens);
                }
            }
            throw new AssertionError(tokens.get(1));
        }
        throw new ParseError("Unexpected token, expected keyword line: ", tokens);
    }

    private static @NonNull List<@NonNull Token> parseHost(@NonNull List<@NonNull Token> tokens, @NonNull OpenSSHConfig result) throws ParseError {
        if ((tokens = OpenSSHConfigParser.stripEOL(tokens)).isEmpty()) {
            return tokens;
        }
        Token token = tokens.get(0);
        switch (token.type()) {
            case HOST: {
                Pair<List<Token>, Set<String>> pair = OpenSSHConfigParser.parseHostPatterns(tokens.subList(1, tokens.size()));
                Set patterns = (Set)pair.second;
                tokens = (List<Token>)pair.first;
                Host host = result.addHost(patterns);
                tokens = OpenSSHConfigParser.parseHostBody(tokens, host);
                return tokens;
            }
            case INCLUDE: {
                int i = 1;
                while (i < tokens.size()) {
                    if (tokens.get(i).type() == TokenType.EOL) {
                        return tokens.subList(i + 1, tokens.size());
                    }
                    ++i;
                }
                return Collections.emptyList();
            }
        }
        throw new ParseError("Unexpected token, expected HOST definition", token);
    }

    private static @NonNull List<@NonNull Token> parseHostBody(@NonNull List<@NonNull Token> tokens, @NonNull Host host) throws ParseError {
        boolean hostIsAllowed = true;
        int startIndex = 0;
        int i = 0;
        while (i < tokens.size()) {
            Token token = tokens.get(i);
            switch (token.type()) {
                case EOL: {
                    OpenSSHConfigParser.parseOneKeyword(tokens.subList(startIndex, i), host);
                    startIndex = i + 1;
                    hostIsAllowed = true;
                    break;
                }
                case HOST: {
                    if (!hostIsAllowed) break;
                    return tokens.subList(i, tokens.size());
                }
                case INVALID: {
                    throw new ParseError("Unexpected token, expected host-name pattern", token);
                }
                case COMMA: 
                case EQUALS: 
                case HOST_NAME: 
                case IDENTITY_FILE: 
                case INCLUDE: 
                case PORT: 
                case USER: 
                case WORD: {
                    hostIsAllowed = false;
                    break;
                }
                default: {
                    throw new AssertionError(token);
                }
            }
            ++i;
        }
        OpenSSHConfigParser.parseOneKeyword(tokens.subList(startIndex, tokens.size()), host);
        return Collections.emptyList();
    }

    private static @NonNull Pair<@NonNull List<@NonNull Token>, @NonNull Set<@NonNull String>> parseHostPatterns(@NonNull List<@NonNull Token> tokens) throws ParseError {
        HashSet<String> result = new HashSet<String>();
        while (!tokens.isEmpty()) {
            Token token = tokens.get(0);
            switch (token.type()) {
                case EOL: {
                    return new Pair(tokens.subList(1, tokens.size()), result);
                }
                case COMMA: 
                case EQUALS: 
                case INVALID: {
                    throw new ParseError("Unexpected token, expected host-name pattern", token);
                }
                case HOST: 
                case HOST_NAME: 
                case IDENTITY_FILE: 
                case INCLUDE: 
                case PORT: 
                case USER: 
                case WORD: {
                    result.add(token.image());
                    tokens = tokens.subList(1, tokens.size());
                    break;
                }
                default: {
                    throw new AssertionError(token);
                }
            }
        }
        return new Pair(tokens, result);
    }

    private static void parseOneKeyword(@NonNull List<@NonNull Token> tokens, @NonNull Host host) throws ParseError {
        if (tokens.isEmpty()) {
            return;
        }
        if (tokens.size() < 2) {
            throw new ParseError("Unexpected token, expected keyword line: ", tokens);
        }
        Token keyword = tokens.get(0);
        switch (keyword.type()) {
            case HOST_NAME: {
                host.setHostname(OpenSSHConfigParser.asStringArg(tokens));
                break;
            }
            case IDENTITY_FILE: {
                host.addIdentityFile(OpenSSHConfigParser.asStringArg(tokens));
                break;
            }
            case PORT: {
                host.setPort(OpenSSHConfigParser.asStringArg(tokens));
                break;
            }
            case USER: {
                host.setUser(OpenSSHConfigParser.asStringArg(tokens));
                break;
            }
            case WORD: {
                break;
            }
            case COMMA: 
            case EQUALS: {
                throw new ParseError("Unexpected token, expected keyword line: ", tokens);
            }
            default: {
                throw new AssertionError(keyword);
            }
        }
    }

    private static @NonNull String patternToRegex(@NonNull String pattern) {
        StringBuilder sb = new StringBuilder(pattern.length());
        int i = 0;
        while (i < pattern.length()) {
            char c = pattern.charAt(i);
            switch (c) {
                case '*': {
                    sb.append(".*");
                    break;
                }
                case '?': {
                    sb.append('.');
                    break;
                }
                case '$': 
                case '%': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '@': 
                case '[': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    sb.append('\\');
                    sb.append(c);
                    break;
                }
                case '\\': {
                    sb.append("\\\\");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    /*
     * Loose catch block
     */
    private static @NonNull String readFileContents(@NonNull File path) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            String string;
            BufferedReader bis;
            FileReader fis;
            block17: {
                block16: {
                    String line;
                    fis = new FileReader(path);
                    bis = new BufferedReader(fis);
                    StringBuilder sb = new StringBuilder();
                    while ((line = bis.readLine()) != null) {
                        sb.append(line).append('\n');
                    }
                    string = sb.toString();
                    if (bis == null) break block16;
                    bis.close();
                }
                if (fis == null) break block17;
                fis.close();
            }
            return string;
            {
                catch (Throwable throwable2) {
                    try {
                        if (bis != null) {
                            bis.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (fis != null) {
                            fis.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private static @NonNull List<@NonNull Token> stripEOL(@NonNull List<@NonNull Token> tokens) {
        while (!tokens.isEmpty() && tokens.get(0).type() == TokenType.EOL) {
            tokens = tokens.subList(1, tokens.size());
        }
        return tokens;
    }

    public static final class Host {
        private @Nullable String hostname;
        private @Nullable List<@NonNull String> identityFiles;
        private final @NonNull Set<@NonNull String> patterns;
        private @Nullable Integer port;
        private @Nullable String user;

        private static boolean matchesPattern(@NonNull String pattern, @NonNull String hostnameToMatch) {
            return Pattern.matches(OpenSSHConfigParser.patternToRegex(pattern), hostnameToMatch);
        }

        public Host(@NonNull Set<@NonNull String> patterns) {
            this.patterns = patterns;
        }

        public void addIdentityFile(@NonNull String val) {
            List<String> identityFiles = this.identityFiles;
            if (identityFiles == null) {
                identityFiles = new ArrayList<String>(1);
            }
            identityFiles.add(val);
            this.identityFiles = identityFiles;
        }

        public void setHostname(@NonNull String val) {
            this.hostname = val;
        }

        public void setPort(@NonNull String val) {
            try {
                this.port = Integer.valueOf(val);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public void setUser(@NonNull String val) {
            this.user = val;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("Host");
            for (String pattern : this.patterns) {
                result.append(" \"").append(pattern).append("\"");
            }
            result.append("\n");
            if (this.hostname != null) {
                result.append("\tHostName \"").append(this.hostname).append("\"\n");
            }
            if (this.identityFiles != null) {
                for (String identityFile : this.identityFiles) {
                    result.append("\tIdentityFile \"").append(identityFile).append("\"\n");
                }
            }
            if (this.port != null) {
                result.append("\tPort \"").append(this.port).append("\"\n");
            }
            if (this.user != null) {
                result.append("\tUser \"").append(this.user).append("\"\n");
            }
            return result.toString();
        }

        private boolean matchesPattern(@NonNull String hostnameToMatch) {
            for (String pattern : this.patterns) {
                if (!Host.matchesPattern(pattern, hostnameToMatch)) continue;
                return true;
            }
            return false;
        }

        private @Nullable HostDefaults tryApply(@Nullable HostDefaults current, @NonNull String hostnameToMatch) {
            if (!this.matchesPattern(hostnameToMatch)) {
                return current;
            }
            if (current == null) {
                return new HostDefaults(this.hostname, this.identityFiles, this.port, this.user);
            }
            return current.combine(this.hostname, this.identityFiles, this.port, this.user);
        }

        static /* synthetic */ Set access$0(Host host) {
            return host.patterns;
        }
    }

    public record HostDefaults(@Nullable String hostname, @Nullable List<@NonNull String> identityFiles, @Nullable Integer port, @Nullable String username) {
        public @NonNull HostDefaults combine(@Nullable String hostname, @Nullable List<@NonNull String> identityFiles, @Nullable Integer port, @Nullable String user) {
            String cHostname = this.hostname;
            List<String> cIdentityFiles = this.identityFiles;
            Integer cPort = this.port;
            String cUser = this.username;
            return new HostDefaults(cHostname != null && !cHostname.isBlank() ? cHostname : hostname, cIdentityFiles != null && !cIdentityFiles.isEmpty() ? cIdentityFiles : identityFiles, cPort != null && cPort > 0 && cPort < 65536 ? cPort : port, cUser != null && !cUser.isBlank() ? cUser : user);
        }

        /*
         * WARNING - void declaration
         */
        public @Nullable List<@NonNull File> computeIdentityFilePaths() {
            String lUsername = OpenSSHConfigParser.getDefaultSshUserName();
            String rUsername = this.username != null ? this.username : lUsername;
            String lHomeDir = System.getProperty("user.home");
            String rHostname = this.hostname;
            List<String> identityFiles = this.identityFiles;
            if (identityFiles == null) {
                return null;
            }
            ArrayList<File> result = new ArrayList<File>();
            for (String string : identityFiles) {
                void var7_8;
                File file;
                if (lHomeDir != null && !lHomeDir.isEmpty() && string.startsWith("~/")) {
                    String string2 = lHomeDir + "/" + string.substring(2);
                }
                if (lHomeDir != null && !lHomeDir.isEmpty()) {
                    void var7_11;
                    String string3 = var7_11.replace("%d", lHomeDir);
                }
                if (!lUsername.isEmpty()) {
                    void var7_13;
                    String string4 = var7_13.replace("%u", lUsername);
                }
                if (rHostname != null && !rHostname.isEmpty()) {
                    void var7_15;
                    String string5 = var7_15.replace("%h", rHostname);
                }
                if (!rUsername.isEmpty()) {
                    void var7_17;
                    String string6 = var7_17.replace("%h", rUsername);
                }
                if (!(file = FileUtils.canonicalise((File)new File((String)var7_8))).isFile() || !file.canRead()) continue;
                result.add(file);
            }
            return result;
        }
    }

    public static final class OpenSSHConfig {
        private final @NonNull List<@NonNull Host> hosts = new ArrayList<Host>();

        public static @Nullable List<@NonNull String> getDefaultIdentityFiles() {
            File[] files;
            block13: {
                String userHome;
                block12: {
                    userHome = System.getProperty("user.home");
                    if (userHome != null && !userHome.isEmpty()) break block12;
                    return null;
                }
                File dir = new File(userHome, ".ssh");
                files = dir.listFiles();
                if (files != null) break block13;
                return null;
            }
            try {
                ArrayList<String> result = new ArrayList<String>();
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (file.isFile() && !OpenSSHConfig.isPubKey(file.getName())) {
                        try {
                            KeyFormat type = KeyProviderUtil.detectKeyFileFormat((File)file);
                            switch (type) {
                                case PKCS8: 
                                case OpenSSH: 
                                case OpenSSHv1: 
                                case PuTTY: {
                                    result.add(FileUtils.canonicalisePath((File)file));
                                    break;
                                }
                                case Unknown: {
                                    break;
                                }
                                default: {
                                    throw new AssertionError(type);
                                }
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    ++n2;
                }
                result.sort((a, b) -> {
                    boolean bIsED25519;
                    boolean bIsECDSA;
                    boolean bIsRSA;
                    boolean aIsRSA = a.endsWith("/id_rsa") || a.endsWith("\\id_rsa");
                    boolean bl = bIsRSA = b.endsWith("/id_rsa") || b.endsWith("\\id_rsa");
                    if (aIsRSA) {
                        return bIsRSA ? a.compareTo((String)b) : -1;
                    }
                    if (bIsRSA) {
                        return 1;
                    }
                    boolean aIsECDSA = a.endsWith("/id_ecdsa") || a.endsWith("\\id_ecdsa");
                    boolean bl2 = bIsECDSA = b.endsWith("/id_ecdsa") || b.endsWith("\\id_ecdsa");
                    if (aIsECDSA) {
                        return bIsECDSA ? a.compareTo((String)b) : -1;
                    }
                    if (bIsECDSA) {
                        return 1;
                    }
                    boolean aIsED25519 = a.endsWith("/id_ed25519") || a.endsWith("\\id_ed25519");
                    boolean bl3 = bIsED25519 = b.endsWith("/id_ed25519") || b.endsWith("\\id_ed25519");
                    if (aIsED25519) {
                        return bIsED25519 ? a.compareTo((String)b) : -1;
                    }
                    if (bIsED25519) {
                        return 1;
                    }
                    return a.compareTo((String)b);
                });
                return !result.isEmpty() ? result : null;
            }
            catch (SecurityException e) {
                return null;
            }
        }

        private static boolean isNotHostnamePattern(@NonNull String pattern) {
            return pattern.indexOf(42) < 0 && pattern.indexOf(63) < 0;
        }

        private static boolean isPubKey(@NonNull String name) {
            return name.endsWith(".pub");
        }

        public @NonNull HostDefaults computeForHost(@NonNull String hostname) {
            HostDefaults result = null;
            for (Host host : this.hosts) {
                result = host.tryApply(result, hostname);
            }
            if (result != null) {
                return result.combine(hostname, OpenSSHConfig.getDefaultIdentityFiles(), 22, OpenSSHConfigParser.getDefaultSshUserName());
            }
            return new HostDefaults(hostname, OpenSSHConfig.getDefaultIdentityFiles(), 22, OpenSSHConfigParser.getDefaultSshUserName());
        }

        public @NonNull HostDefaults computeForHost(@Nullable String hostname, @Nullable List<@NonNull String> identityFiles, @Nullable Integer port, @Nullable String user) {
            @Nullable HostDefaults result = new HostDefaults(hostname, identityFiles, port, user);
            if (hostname != null) {
                for (Host host : this.hosts) {
                    result = host.tryApply(result, hostname);
                }
            }
            if (result != null) {
                return result.combine(hostname, OpenSSHConfig.getDefaultIdentityFiles(), 22, OpenSSHConfigParser.getDefaultSshUserName());
            }
            return new HostDefaults(hostname, OpenSSHConfig.getDefaultIdentityFiles(), 22, OpenSSHConfigParser.getDefaultSshUserName());
        }

        public @NonNull SSHTargetConfig createTargetConfig(@NonNull String hostname, @NonNull HostDefaults hostDefaults) {
            Integer sshPort;
            List<File> keyFilesToUse;
            for (Host host : this.hosts) {
                hostDefaults = (HostDefaults)NullChecking.neverNullOr((Object)host.tryApply(hostDefaults, hostname), (Object)hostDefaults);
            }
            hostDefaults = hostDefaults.combine(hostname, OpenSSHConfig.getDefaultIdentityFiles(), 22, OpenSSHConfigParser.getDefaultSshUserName());
            String usernameToUse = (String)NullChecking.neverNullOrCreate((Object)hostDefaults.username(), OpenSSHConfigParser::getDefaultSshUserName);
            List<File> keyFiles = hostDefaults.computeIdentityFilePaths();
            List<Object> list = keyFilesToUse = keyFiles != null ? keyFiles.stream().map(FileUtils::canonicalise).toList() : Collections.emptyList();
            if (keyFilesToUse.isEmpty()) {
                List<File> list2 = hostDefaults.computeIdentityFilePaths();
                if (list2 != null) {
                    keyFilesToUse = list2;
                } else {
                    List<String> kf = OpenSSHConfig.getDefaultIdentityFiles();
                    if (kf != null) {
                        keyFilesToUse = kf.stream().map(File::new).map(FileUtils::canonicalise).toList();
                    }
                }
            }
            int sshPortToUse = (sshPort = hostDefaults.port()) != null ? sshPort : 22;
            return new SSHTargetConfig(hostname, hostDefaults, (String)NullChecking.neverNullOr((Object)hostDefaults.hostname(), (Object)hostname), usernameToUse, keyFilesToUse, null, sshPortToUse);
        }

        public @NonNull SSHTargetConfig createTargetConfig(@NonNull String id, @NonNull String hostname, @Nullable String username, @Nullable String password, @Nullable List<@NonNull File> keyFiles, @Nullable Integer sshPort) {
            String passwordToUse;
            HostDefaults sshHostDefaults = this.computeForHost(hostname, keyFiles != null ? keyFiles.stream().map(FileUtils::canonicalisePath).toList() : null, sshPort == null || sshPort < 1 || sshPort > 65535 ? null : sshPort, username == null || username.isBlank() ? null : username);
            String usernameToUse = (String)NullChecking.neverNullOrCreate((Object)sshHostDefaults.username(), OpenSSHConfigParser::getDefaultSshUserName);
            String string = passwordToUse = password == null || password.isEmpty() ? null : password;
            if ((keyFiles == null || keyFiles.isEmpty()) && (passwordToUse == null || passwordToUse.isEmpty())) {
                List<File> list = sshHostDefaults.computeIdentityFilePaths();
                if (list != null) {
                    keyFiles = list;
                } else {
                    List<String> kf = OpenSSHConfig.getDefaultIdentityFiles();
                    if (kf != null) {
                        keyFiles = kf.stream().map(File::new).toList();
                    }
                }
            }
            int sshPortToUse = (sshPort = sshHostDefaults.port()) != null ? sshPort : 22;
            return new SSHTargetConfig(id.isEmpty() ? hostname : id, this.computeForHost(hostname), (String)NullChecking.neverNullOr((Object)sshHostDefaults.hostname(), (Object)hostname), usernameToUse, keyFiles != null ? keyFiles : Collections.emptyList(), passwordToUse, sshPortToUse);
        }

        public @NonNull Map<@NonNull String, @NonNull HostDefaults> enumerateHosts() {
            List allExplicitHostNames = this.hosts.stream().flatMap(h -> h.patterns.stream()).filter(OpenSSHConfig::isNotHostnamePattern).distinct().collect(Collectors.toList());
            TreeMap<String, HostDefaults> result = new TreeMap<String, HostDefaults>();
            for (String hostname : allExplicitHostNames) {
                result.put(hostname, this.computeForHost(hostname));
            }
            return result;
        }

        public String toString() {
            return this.hosts.stream().map(Host::toString).collect(Collectors.joining("\n", "", ""));
        }

        private @NonNull Host addHost(@NonNull Set<@NonNull String> patterns) {
            Host result = new Host(patterns);
            this.hosts.add(result);
            return result;
        }

        private void appendDefaults(@NonNull OpenSSHConfig defaults) {
            this.hosts.addAll(defaults.hosts);
        }
    }

    public static final class ParseError
    extends Exception {
        public ParseError(@NonNull String message) {
            super(message);
        }

        public ParseError(@NonNull String message, @NonNull List<@NonNull Token> tokens) {
            super(tokens.isEmpty() ? message : String.format("%s: %s", message, tokens.stream().map(t -> t.image()).collect(Collectors.joining(" ", "", ""))));
        }

        public ParseError(@NonNull String message, @NonNull Token token) {
            this(message, Arrays.asList(token));
        }
    }

    public record SSHTargetConfig(@NonNull String id, @NonNull HostDefaults unmodifiedHostDefaults, @NonNull String hostname, @NonNull String username, @NonNull List<@NonNull File> keyFiles, @Nullable String password, int port) {
    }

    public record Token(@NonNull TokenType type, @NonNull String image) {
    }

    public static enum TokenType {
        COMMA,
        EOL,
        EQUALS,
        HOST,
        HOST_NAME,
        IDENTITY_FILE,
        INCLUDE,
        INVALID,
        PORT,
        USER,
        WORD;

    }

    public static final class Tokenizer {
        private int currentOffset;
        private final @NonNull String fileContents;

        public static final @NonNull List<@NonNull Token> tokenize(@NonNull String fileContents) {
            ArrayList<Token> result = new ArrayList<Token>();
            Tokenizer tokenizer = new Tokenizer(fileContents);
            Token token = tokenizer.nextToken();
            while (token != null) {
                result.add(token);
                if (token.type() == TokenType.INVALID) break;
                token = tokenizer.nextToken();
            }
            return result;
        }

        private static @NonNull Token classifyToken(boolean inString, @NonNull String image) {
            if (inString || image.isEmpty()) {
                return new Token(TokenType.INVALID, image);
            }
            if (image.startsWith("\"")) {
                assert (image.endsWith("\""));
                return new Token(TokenType.WORD, image.substring(1, image.length() - 1));
            }
            switch (image.toLowerCase()) {
                case "\n": 
                case "\r": {
                    return new Token(TokenType.EOL, image);
                }
                case ",": {
                    return new Token(TokenType.COMMA, image);
                }
                case "=": {
                    return new Token(TokenType.EQUALS, image);
                }
                case "host": {
                    return new Token(TokenType.HOST, image);
                }
                case "hostname": {
                    return new Token(TokenType.HOST_NAME, image);
                }
                case "identityfile": {
                    return new Token(TokenType.IDENTITY_FILE, image);
                }
                case "include": {
                    return new Token(TokenType.INCLUDE, image);
                }
                case "port": {
                    return new Token(TokenType.PORT, image);
                }
                case "user": {
                    return new Token(TokenType.USER, image);
                }
            }
            return new Token(TokenType.WORD, image);
        }

        public Tokenizer(@NonNull String fileContents) {
            this.fileContents = fileContents;
            this.currentOffset = 0;
        }

        public @Nullable Token nextToken() {
            if (!this.skipWhiteSpaceAndComments()) {
                return null;
            }
            int tokenStart = this.currentOffset;
            boolean inString = false;
            boolean escaped = false;
            while (this.currentOffset < this.fileContents.length()) {
                char c = this.fileContents.charAt(this.currentOffset);
                if (inString) {
                    if (!escaped) {
                        if (c == '\\') {
                            escaped = true;
                        } else if (c == '\"') {
                            inString = false;
                            ++this.currentOffset;
                            break;
                        }
                    }
                } else if (c == '\"') {
                    if (this.currentOffset > tokenStart) break;
                    inString = true;
                    escaped = false;
                } else {
                    if (c == '\n' || c == '\r') {
                        if (this.currentOffset > tokenStart) break;
                        ++this.currentOffset;
                        break;
                    }
                    if (c <= ' ' || c == '#') {
                        assert (this.currentOffset > tokenStart);
                        break;
                    }
                    if (c == ',' || c == '=') {
                        if (this.currentOffset > tokenStart) break;
                        ++this.currentOffset;
                        break;
                    }
                }
                ++this.currentOffset;
            }
            return Tokenizer.classifyToken(inString, this.fileContents.substring(tokenStart, this.currentOffset));
        }

        private boolean skipWhiteSpaceAndComments() {
            boolean inComment = false;
            while (this.currentOffset < this.fileContents.length()) {
                char c = this.fileContents.charAt(this.currentOffset);
                if (inComment) {
                    if (c == '\n' || c == '\r') {
                        inComment = false;
                        return true;
                    }
                } else if (c == '#') {
                    inComment = true;
                } else if (c == '\n' || c == '\r' || c > ' ') {
                    return true;
                }
                ++this.currentOffset;
            }
            return false;
        }
    }
}

