/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.deviceconn.ssh;

import com.arm.streamline.deviceconn.ssh.sshj.ISSHClient;
import com.arm.utils.function.Throwing;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jdt.annotation.NonNull;

public final class BasicSshPortForwarderThread
implements Closeable {
    private static final int DEFAULT_BACKLOG = 5;
    private final @NonNull ISSHClient.ILocalPortForwarder forwarder;
    private final @NonNull ServerSocket socket;
    private @NonNull State state = State.PENDING;
    private final @NonNull Object stateMutex = new Object();
    private final @NonNull Thread thread;
    private final @NonNull String threadName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"UNENCRYPTED_SERVER_SOCKET"})
    public BasicSshPortForwarderThread(@NonNull ISSHClient sshClient, @NonNull String localHost, int localPort, @NonNull String remoteHost, int remotePort) throws IOException {
        assert (localPort >= 0 && localPort < 65536);
        assert (remotePort > 0 && remotePort < 65536);
        this.socket = new ServerSocket();
        try {
            this.socket.setReuseAddress(true);
            this.socket.bind(new InetSocketAddress(localHost, localPort), 5);
            this.threadName = String.format("Port forwarder for %s:%d to %s:%d", localHost, this.socket.getLocalPort(), remoteHost, remotePort);
            this.forwarder = sshClient.newLocalPortForwarder(localHost, localPort, remoteHost, remotePort, this.socket);
            try {
                AtomicReference launcherException = new AtomicReference();
                this.thread = new Thread(() -> {
                    try {
                        try {
                            this.setState(State.READY);
                            this.forwarder.listen();
                        }
                        catch (Throwable t) {
                            try {
                                Throwing.closeAll((Closeable[])new Closeable[]{this.forwarder, this.socket});
                            }
                            catch (Throwable t1) {
                                t.addSuppressed(t1);
                            }
                            launcherException.set(t);
                            this.setState(State.COMPLETE);
                        }
                    }
                    finally {
                        this.setState(State.COMPLETE);
                    }
                }, this.threadName);
                this.thread.setDaemon(true);
                this.thread.start();
                Object object = this.stateMutex;
                synchronized (object) {
                    while (this.state == State.PENDING && this.thread.isAlive()) {
                        try {
                            this.stateMutex.wait();
                        }
                        catch (InterruptedException e) {
                            throw new IOException("Interrupted waiting for worker to start", e);
                        }
                    }
                    if (!this.thread.isAlive()) {
                        throw new IOException("Failed in launcher thread", (Throwable)launcherException.get());
                    }
                }
            }
            catch (Throwable t) {
                try {
                    this.forwarder.close();
                }
                catch (Throwable t1) {
                    t.addSuppressed(t1);
                }
                throw t;
            }
        }
        catch (Throwable t) {
            try {
                this.socket.close();
            }
            catch (Throwable t1) {
                t.addSuppressed(t1);
            }
            throw t;
        }
    }

    @Override
    public void close() throws IOException {
        Throwing.closeAll((Closeable[])new Closeable[]{this.forwarder, this.socket});
    }

    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull State getState() {
        Object object = this.stateMutex;
        synchronized (object) {
            return this.state;
        }
    }

    public String toString() {
        return this.threadName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(@NonNull State state) {
        Object object = this.stateMutex;
        synchronized (object) {
            this.state = state;
            this.stateMutex.notify();
        }
    }

    private static enum State {
        COMPLETE,
        PENDING,
        READY;

    }
}

