/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.deviceconn.lib;

import com.arm.streamline.deviceconn.IBasicInteractiveShell;
import com.arm.streamline.deviceconn.IInteractiveCommand;
import com.arm.streamline.deviceconn.ITerminalConnection;
import com.arm.streamline.deviceconn.lib.AbstractAsyncByteReaderLineReaderAndLogger;
import com.arm.streamline.deviceconn.lib.AsyncInputStreamLineReaderAndLogger;
import com.arm.streamline.deviceconn.lib.IProcessInteractiveCommand;
import com.arm.streamline.deviceconn.lib.LineBuffer;
import com.arm.streamline.deviceconn.lib.TerminalWrapperDecoder;
import com.arm.utils.function.IThrowingSupplier;
import com.arm.utils.function.Throwing;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class TerminalWrapperDecoderInteractiveCommandAdapter
implements IProcessInteractiveCommand {
    private static final @NonNull IBasicInteractiveShell.CommandStatus STATUS_UNKNOWN = IBasicInteractiveShell.CommandStatus.unknown("no signal/exit recieved by terminal wrapper");
    private final @NonNull AtomicInteger childPid = new AtomicInteger(0);
    private final @NonNull TerminalWrapperDecoder.IDataConsumer consumer;
    private final @NonNull TerminalWrapperDecoder decoder;
    private final @NonNull AtomicReference<@NonNull IBasicInteractiveShell.CommandStatus> exitCode;
    private final @NonNull ICommandInputSource inputSource;
    private final @NonNull IRemoteKiller killer;
    private final @NonNull PipedInputStream pipeStdErr_R;
    private final @NonNull PipedOutputStream pipeStdErr_W;
    private final @NonNull PipedInputStream pipeStdOut_R;
    private final @NonNull PipedOutputStream pipeStdOut_W;
    private final @NonNull AbstractAsyncByteReaderLineReaderAndLogger processStdErr;
    private final @NonNull AbstractAsyncByteReaderLineReaderAndLogger processStdOut;
    private final @NonNull LineBuffer stdErrBuffer = new LineBuffer();
    private final @NonNull LineBuffer stdOutBuffer = new LineBuffer();
    private final @NonNull WorkerThread thread;

    public TerminalWrapperDecoderInteractiveCommandAdapter(@NonNull ICommandInputSource inputSource, boolean discardStdOutLines, boolean discardStdErrLines, @NonNull IThrowingSupplier<@NonNull AbstractAsyncByteReaderLineReaderAndLogger.IByteConsumer, IOException> stdOutConsumerFactory, @NonNull IThrowingSupplier<@NonNull AbstractAsyncByteReaderLineReaderAndLogger.IByteConsumer, IOException> stdErrConsumerFactory, @NonNull IRemoteKiller killer) throws IOException {
        this.inputSource = inputSource;
        this.killer = killer;
        this.exitCode = new AtomicReference<IBasicInteractiveShell.CommandStatus>(STATUS_UNKNOWN);
        this.pipeStdOut_W = new PipedOutputStream();
        this.pipeStdErr_W = new PipedOutputStream();
        this.pipeStdOut_R = new PipedInputStream(this.pipeStdOut_W);
        this.pipeStdErr_R = new PipedInputStream(this.pipeStdErr_W);
        this.processStdOut = new AsyncInputStreamLineReaderAndLogger("tw-exec-out", Charset.defaultCharset(), (InputStream)this.pipeStdOut_R, true, discardStdOutLines ? AbstractAsyncByteReaderLineReaderAndLogger.ILineConsumer.NULL_LINE_CONSUMER : this.stdOutBuffer, stdOutConsumerFactory);
        this.processStdErr = new AsyncInputStreamLineReaderAndLogger("tw-exec-err", Charset.defaultCharset(), (InputStream)this.pipeStdErr_R, true, discardStdErrLines ? AbstractAsyncByteReaderLineReaderAndLogger.ILineConsumer.NULL_LINE_CONSUMER : this.stdErrBuffer, stdErrConsumerFactory);
        this.consumer = new TerminalWrapperDecoder.IDataConsumer(){

            @Override
            public void onDebug(boolean child, @NonNull String message) throws IOException {
                System.err.printf("Terminal Wrapper: %sDEBUG: %s%n", child ? "CHILD " : "", message);
            }

            @Override
            public void onError(boolean child, @NonNull String message) throws IOException {
                System.err.printf("Terminal Wrapper: %sERROR: %s%n", child ? "CHILD " : "", message);
            }

            @Override
            public void onExit(int exitCode) throws IOException {
                if (!$assertionsDisabled && (exitCode & 0xFFFFFF00) != 0) {
                    throw new AssertionError();
                }
                IBasicInteractiveShell.CommandStatus x = TerminalWrapperDecoderInteractiveCommandAdapter.this.exitCode.getAndSet(IBasicInteractiveShell.CommandStatus.exited((byte)exitCode));
                if (!$assertionsDisabled && x != STATUS_UNKNOWN) {
                    throw new AssertionError();
                }
            }

            @Override
            public void onPid(int pid) {
                int x = TerminalWrapperDecoderInteractiveCommandAdapter.this.childPid.getAndSet(pid);
                if (!$assertionsDisabled && x != 0) {
                    throw new AssertionError();
                }
            }

            @Override
            public void onSignal(int signal, @NonNull String name) throws IOException {
                if (!$assertionsDisabled && (signal & 0xFFFFFF00) != 0) {
                    throw new AssertionError();
                }
                IBasicInteractiveShell.CommandStatus x = TerminalWrapperDecoderInteractiveCommandAdapter.this.exitCode.getAndSet(IBasicInteractiveShell.CommandStatus.signalled((byte)signal));
                if (!$assertionsDisabled && x != STATUS_UNKNOWN) {
                    throw new AssertionError();
                }
            }

            @Override
            public void onStdErr(byte @NonNull [] data) throws IOException {
                TerminalWrapperDecoderInteractiveCommandAdapter.this.pipeStdErr_W.write(data);
            }

            @Override
            public void onStdOut(byte @NonNull [] data) throws IOException {
                TerminalWrapperDecoderInteractiveCommandAdapter.this.pipeStdOut_W.write(data);
            }
        };
        this.decoder = new TerminalWrapperDecoder(this.consumer);
        this.thread = new WorkerThread();
        this.thread.start();
    }

    public TerminalWrapperDecoderInteractiveCommandAdapter(@NonNull IInteractiveCommand commandToAdapt, boolean discardStdOutLines, boolean discardStdErrLines, @NonNull IThrowingSupplier<@NonNull AbstractAsyncByteReaderLineReaderAndLogger.IByteConsumer, IOException> stdOutConsumerFactory, @NonNull IThrowingSupplier<@NonNull AbstractAsyncByteReaderLineReaderAndLogger.IByteConsumer, IOException> stdErrConsumerFactory, @NonNull IRemoteKiller killer) throws IOException {
        this(ICommandInputSource.wrap(commandToAdapt), discardStdOutLines, discardStdErrLines, stdOutConsumerFactory, stdErrConsumerFactory, killer);
    }

    @Override
    public void close() throws IOException {
        try {
            this.waitForExit();
        }
        catch (Throwable throwable) {
            Throwing.closeAll((Closeable[])new Closeable[]{this.pipeStdOut_W, this.pipeStdErr_W, this.processStdOut, this.processStdErr, this.pipeStdOut_R, this.pipeStdErr_R, this.inputSource});
            throw throwable;
        }
        Throwing.closeAll((Closeable[])new Closeable[]{this.pipeStdOut_W, this.pipeStdErr_W, this.processStdOut, this.processStdErr, this.pipeStdOut_R, this.pipeStdErr_R, this.inputSource});
    }

    @Override
    public @NonNull List<@NonNull String> collectAllRemainingOutputAndWaitForExit() throws IOException {
        ITerminalConnection.TerminalLine line;
        this.waitForExit();
        @NonNull ArrayList<@NonNull String> result = new ArrayList<String>();
        while ((line = this.stdOutBuffer.nextLine()) != null || this.processStdOut.isRunning() || this.processStdErr.isRunning()) {
            if (line != null && line.complete) {
                result.add(line.line);
                continue;
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public @Nullable List<@NonNull String> getErrorLines() {
        ITerminalConnection.TerminalLine line;
        @NonNull ArrayList<@NonNull String> result = new ArrayList<String>();
        while ((line = this.stdErrBuffer.nextLine()) != null) {
            if (!line.complete) continue;
            result.add(line.line);
        }
        return result;
    }

    @Override
    public @Nullable IBasicInteractiveShell.CommandStatus getExitCode() {
        if (this.isConnected()) {
            return null;
        }
        return this.exitCode.get();
    }

    @Override
    public void interrupt() throws Exception {
        int pid = this.childPid.get();
        this.killer.interrupt(pid);
    }

    @Override
    public boolean isConnected() {
        return this.thread.isAlive() || this.processStdOut.isRunning() || this.processStdErr.isRunning();
    }

    @Override
    public void kill() throws Exception {
        int pid = this.childPid.get();
        this.killer.kill(pid);
    }

    @Override
    public @Nullable ITerminalConnection.TerminalLine nextLine() throws IOException {
        return this.stdOutBuffer.nextLine();
    }

    @Override
    public void send(@NonNull String text) throws IOException {
        this.inputSource.send(text);
    }

    @Override
    public @NonNull IBasicInteractiveShell.CommandStatus waitForExitInterruptible() throws InterruptedException {
        while (this.isConnected()) {
            Thread.sleep(100L);
        }
        return this.exitCode.get();
    }

    public static interface ICommandInputSource
    extends Closeable {
        public static @NonNull ICommandInputSource wrap(final @NonNull IInteractiveCommand commandToAdapt) {
            return new ICommandInputSource(){

                @Override
                public void close() throws IOException {
                    commandToAdapt.close();
                }

                @Override
                public boolean isConnected() {
                    return commandToAdapt.isConnected();
                }

                @Override
                public @NonNull List<@NonNull String> readNextLines() throws IOException {
                    while (commandToAdapt.isConnected()) {
                        ITerminalConnection.TerminalLine line = commandToAdapt.nextLineOrWait();
                        if (line == null || !line.complete) continue;
                        return Arrays.asList(line.line);
                    }
                    return commandToAdapt.collectAllRemainingOutputAndWaitForExit();
                }

                @Override
                public void send(@NonNull String text) throws IOException {
                    commandToAdapt.send(text);
                }
            };
        }

        public boolean isConnected();

        public @NonNull List<@NonNull String> readNextLines() throws IOException;

        public void send(@NonNull String var1) throws IOException;
    }

    public static interface IRemoteKiller {
        public void interrupt(int var1) throws Exception;

        public void kill(int var1) throws Exception;
    }

    private class WorkerThread
    extends Thread {
        public WorkerThread() {
            super(WorkerThread.class.getSimpleName());
        }

        @Override
        public void run() {
            block14: {
                try {
                    try {
                        while (TerminalWrapperDecoderInteractiveCommandAdapter.this.inputSource.isConnected()) {
                            List<String> lines = TerminalWrapperDecoderInteractiveCommandAdapter.this.inputSource.readNextLines();
                            for (String line : lines) {
                                TerminalWrapperDecoderInteractiveCommandAdapter.this.decoder.onNextLine(line);
                            }
                        }
                        for (String line : TerminalWrapperDecoderInteractiveCommandAdapter.this.inputSource.readNextLines()) {
                            TerminalWrapperDecoderInteractiveCommandAdapter.this.decoder.onNextLine(line);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        try {
                            Throwing.closeAll((Closeable[])new Closeable[]{TerminalWrapperDecoderInteractiveCommandAdapter.this.pipeStdOut_W, TerminalWrapperDecoderInteractiveCommandAdapter.this.pipeStdErr_W});
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        Throwing.closeAll((Closeable[])new Closeable[]{TerminalWrapperDecoderInteractiveCommandAdapter.this.pipeStdOut_W, TerminalWrapperDecoderInteractiveCommandAdapter.this.pipeStdErr_W});
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    throw throwable;
                }
                try {
                    Throwing.closeAll((Closeable[])new Closeable[]{TerminalWrapperDecoderInteractiveCommandAdapter.this.pipeStdOut_W, TerminalWrapperDecoderInteractiveCommandAdapter.this.pipeStdErr_W});
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

