/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.deviceconn.lib;

import com.arm.utils.NullChecking;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;

public class TerminalWrapperDecoder {
    private static final Pattern LINE_PATTERN = Pattern.compile("^([^:]+): (.*)$");
    private static final Pattern SIGNAL_PATTERN = Pattern.compile("^(\\d+) '(.*)'$");
    private static final String TAG_CHILD_DEBUG = "d";
    private static final String TAG_CHILD_ERROR = "r";
    private static final String TAG_DEBUG = "D";
    private static final String TAG_ERROR = "R";
    private static final String TAG_EXITCODE = "X";
    private static final String TAG_EXITSIGNAL = "S";
    private static final String TAG_PID = "P";
    private static final String TAG_STDERR = "E";
    private static final String TAG_STDOUT = "O";
    private final @NonNull IDataConsumer consumer;

    private static byte @NonNull [] decode(@NonNull String data) throws IOException {
        byte @NonNull [] chars = data.getBytes(StandardCharsets.US_ASCII);
        int wpos = 0;
        int rpos = 0;
        while (rpos < chars.length) {
            if (chars[rpos] != 92) {
                chars[wpos] = chars[rpos];
                ++rpos;
                ++wpos;
                continue;
            }
            if (rpos + 1 >= chars.length) {
                throw new IOException("Invalid line data: '" + data + "'");
            }
            switch (chars[rpos + 1]) {
                case 92: {
                    chars[wpos] = 92;
                    rpos += 2;
                    ++wpos;
                    break;
                }
                case 110: {
                    chars[wpos] = 10;
                    rpos += 2;
                    ++wpos;
                    break;
                }
                case 120: {
                    if (rpos + 3 >= chars.length) {
                        throw new IOException("Invalid line data: '" + data + "'");
                    }
                    chars[wpos] = TerminalWrapperDecoder.fromHex(chars[rpos + 2], chars[rpos + 3]);
                    rpos += 4;
                    ++wpos;
                    break;
                }
                default: {
                    throw new IOException("Invalid line data: '" + data + "'");
                }
            }
        }
        if (wpos == chars.length) {
            return chars;
        }
        byte @NonNull [] result = new byte[wpos];
        System.arraycopy(chars, 0, result, 0, wpos);
        return result;
    }

    private static byte fromHex(byte chr) {
        if (chr >= 48 && chr <= 57) {
            return (byte)(chr - 48 & 0xF);
        }
        if (chr >= 97 && chr <= 102) {
            return (byte)((chr - 97 & 0xF) + 10);
        }
        if (chr >= 65 && chr <= 70) {
            return (byte)((chr - 65 & 0xF) + 10);
        }
        throw new NumberFormatException("Invalid hex char: " + (char)chr);
    }

    private static byte fromHex(byte hi, byte lo) {
        return (byte)(TerminalWrapperDecoder.fromHex(hi) << 4 | TerminalWrapperDecoder.fromHex(lo));
    }

    public TerminalWrapperDecoder(@NonNull IDataConsumer consumer) {
        this.consumer = consumer;
    }

    public void onNextLine(@NonNull String line) throws IOException {
        Matcher matcher = LINE_PATTERN.matcher(line);
        if (!matcher.matches()) {
            if (line.trim().isEmpty()) {
                return;
            }
            throw new IOException("Invalid data: '" + line + "'");
        }
        String tag = (String)NullChecking.neverNull((Object)matcher.group(1));
        String data = (String)NullChecking.neverNull((Object)matcher.group(2));
        switch (tag) {
            case "P": {
                int pid = Integer.parseInt(data, 10);
                this.consumer.onPid(pid);
                break;
            }
            case "R": {
                this.consumer.onError(false, data);
                break;
            }
            case "X": {
                this.consumer.onExit(Integer.parseInt(data));
                break;
            }
            case "S": {
                Matcher sigmatcher = SIGNAL_PATTERN.matcher(data);
                if (!sigmatcher.matches()) {
                    throw new IOException("Invalid data: '" + line + "'");
                }
                String val = (String)NullChecking.neverNull((Object)sigmatcher.group(1));
                String name = (String)NullChecking.neverNull((Object)sigmatcher.group(2));
                this.consumer.onSignal(Integer.parseInt(val), name);
                break;
            }
            case "O": {
                this.consumer.onStdOut(TerminalWrapperDecoder.decode(data));
                break;
            }
            case "E": {
                this.consumer.onStdErr(TerminalWrapperDecoder.decode(data));
                break;
            }
            case "r": {
                byte[] bytes = TerminalWrapperDecoder.decode(data);
                String str = new String(bytes, StandardCharsets.US_ASCII);
                this.consumer.onError(true, str);
                break;
            }
            case "D": {
                this.consumer.onDebug(false, data);
                break;
            }
            case "d": {
                byte[] bytes = TerminalWrapperDecoder.decode(data);
                String str = new String(bytes, StandardCharsets.US_ASCII);
                this.consumer.onDebug(true, str);
                break;
            }
            default: {
                throw new IOException("Invalid data: '" + line + "'");
            }
        }
    }

    public static interface IDataConsumer {
        public void onDebug(boolean var1, @NonNull String var2) throws IOException;

        public void onError(boolean var1, @NonNull String var2) throws IOException;

        public void onExit(int var1) throws IOException;

        public void onPid(int var1);

        public void onSignal(int var1, @NonNull String var2) throws IOException;

        public void onStdErr(byte @NonNull [] var1) throws IOException;

        public void onStdOut(byte @NonNull [] var1) throws IOException;
    }
}

