/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.deviceconn.lib;

import com.arm.streamline.deviceconn.lib.IProcess;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNull;

@FunctionalInterface
@SuppressFBWarnings(value={"COMMAND_INJECTION"})
public interface IProcessFactory {
    public static @NonNull IProcessFactory usingProcessBuilder() {
        return (commandAndArguments, workingDirectory, environment) -> {
            ProcessBuilder pBuilder = new ProcessBuilder(commandAndArguments);
            pBuilder.directory(workingDirectory);
            pBuilder.environment().putAll(environment);
            pBuilder.redirectErrorStream(false);
            pBuilder.redirectError(ProcessBuilder.Redirect.PIPE);
            pBuilder.redirectInput(ProcessBuilder.Redirect.PIPE);
            pBuilder.redirectOutput(ProcessBuilder.Redirect.PIPE);
            return new IProcess(pBuilder){
                private final Process process;
                {
                    this.process = processBuilder.start();
                }

                @Override
                public void destroy() {
                    this.process.destroy();
                }

                @Override
                public void destroyForcibly() {
                    this.process.destroyForcibly();
                }

                @Override
                public int exitValue() {
                    return this.process.exitValue();
                }

                @Override
                public @NonNull InputStream getErrorStream() {
                    return this.process.getErrorStream();
                }

                @Override
                public @NonNull InputStream getInputStream() {
                    return this.process.getInputStream();
                }

                @Override
                public @NonNull OutputStream getOutputStream() {
                    return this.process.getOutputStream();
                }

                @Override
                public boolean isAlive() {
                    return this.process.isAlive();
                }

                @Override
                public int waitFor() throws InterruptedException {
                    return this.process.waitFor();
                }

                @Override
                public boolean waitFor(long timeout, TimeUnit unit) throws InterruptedException {
                    return this.process.waitFor(timeout, unit);
                }
            };
        };
    }

    public @NonNull IProcess create(@NonNull String @NonNull [] var1, @NonNull File var2, @NonNull Map<@NonNull String, @NonNull String> var3) throws IOException;
}

