/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.deviceconn.lib;

import org.eclipse.jdt.annotation.NonNull;

public final class EscapeUtils {
    public static @NonNull String escapeAdbShellExecArg(@NonNull String command, String ... arguments) {
        @NonNull StringBuilder cmdString = new StringBuilder();
        cmdString.append("exec ").append(EscapeUtils.escapeArg(command));
        String[] stringArray = arguments;
        int n = arguments.length;
        int n2 = 0;
        while (n2 < n) {
            String argument = stringArray[n2];
            cmdString.append(' ').append(EscapeUtils.escapeArg(argument));
            ++n2;
        }
        return EscapeUtils.escapeArg(cmdString.toString());
    }

    public static @NonNull String escapeArg(@NonNull String argument) {
        StringBuilder result = new StringBuilder();
        int length = argument.length();
        result.append("'");
        int currentPos = 0;
        while (currentPos < length) {
            int nextQuote = EscapeUtils.findNextQuote(argument, currentPos, length);
            boolean found = nextQuote >= currentPos;
            int copyUpTo = found ? nextQuote : length;
            int nToCopy = copyUpTo - currentPos;
            if (nToCopy > 0) {
                result.append(argument.substring(currentPos, copyUpTo));
            }
            if (found) {
                result.append("'\\''");
            }
            currentPos = copyUpTo + 1;
        }
        result.append("'");
        return result.toString();
    }

    private static int findNextQuote(@NonNull String argument, int currentPos, int length) {
        int i = currentPos;
        while (i < length) {
            char c = argument.charAt(i);
            if (c == '\'') {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

