/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.deviceconn.adb.utils;

import java.util.Collections;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;

public class AdbInstalledPackage {
    private final @NonNull String location;
    private final @NonNull String packageName;
    private final @NonNull Set<@NonNull String> activities;
    private final boolean isDebuggable;

    public AdbInstalledPackage(@NonNull String location, @NonNull String packageName, @NonNull Set<@NonNull String> activities, boolean isDebuggable) {
        this.location = location;
        this.packageName = packageName;
        this.isDebuggable = isDebuggable;
        this.activities = Collections.unmodifiableSet(activities);
    }

    public @NonNull String getLocation() {
        return this.location;
    }

    public @NonNull String getPackageName() {
        return this.packageName;
    }

    public boolean isDebuggable() {
        return this.isDebuggable;
    }

    public @NonNull Set<@NonNull String> getMainActivities() {
        return this.activities;
    }

    public String toString() {
        return String.format("Package: %s Location: %s", this.getPackageName(), this.getLocation());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AdbInstalledPackage)) {
            return false;
        }
        AdbInstalledPackage other = (AdbInstalledPackage)obj;
        return this.packageName.matches(other.packageName) && this.location.matches(other.location) && this.isDebuggable == other.isDebuggable && this.activities.equals(other.activities);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

