/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.deviceconn.adb.utils;

import com.arm.streamline.deviceconn.IBasicInteractiveShell;
import com.arm.streamline.deviceconn.adb.IAdbProcessRunner;
import com.arm.streamline.deviceconn.adb.utils.AdbCommandIOException;
import com.arm.streamline.deviceconn.adb.utils.AdbDevice;
import com.arm.utils.NullChecking;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;

public final class AdbDeviceEnumeration {
    private static final @NonNull Pattern DEVICE_PATTERN = Pattern.compile("([^\\t]+)\t(.+)");

    public static final @NonNull Set<@NonNull AdbDevice> enumerate(@NonNull IAdbProcessRunner adbRunner) throws IOException {
        @NonNull IBasicInteractiveShell.InteractiveCommandResult adbDevices = adbRunner.runCommandAndGetOutput("devices");
        if (!adbDevices.status.isSuccessful()) {
            throw new AdbCommandIOException("adb devices", adbDevices);
        }
        @NonNull HashSet<@NonNull AdbDevice> devices = new HashSet<AdbDevice>();
        for (String line : adbDevices.output) {
            Matcher matcher = DEVICE_PATTERN.matcher(line);
            if (!matcher.matches()) continue;
            devices.add(new AdbDevice((String)NullChecking.neverNull((Object)matcher.group(1)), (String)NullChecking.neverNull((Object)matcher.group(2))));
        }
        return devices;
    }
}

