/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.deviceconn.adb.utils;

import org.eclipse.jdt.annotation.NonNull;

public class AdbDevice {
    private final @NonNull String serialNo;
    private final @NonNull String stateString;

    public AdbDevice(@NonNull String serialNo, @NonNull String stateSting) {
        this.serialNo = serialNo;
        this.stateString = stateSting;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AdbDevice) {
            AdbDevice that = (AdbDevice)obj;
            return this.serialNo.contentEquals(that.serialNo) && this.stateString.contentEquals(that.stateString);
        }
        return false;
    }

    public @NonNull String getSerialNo() {
        return this.serialNo;
    }

    public @NonNull AdbDeviceState getState() {
        return AdbDeviceState.parse(this.stateString);
    }

    public @NonNull String getStateString() {
        return this.stateString;
    }

    public int hashCode() {
        return this.serialNo.hashCode();
    }

    public String toString() {
        return String.format("%s: %s", this.stateString, this.serialNo);
    }

    public static enum AdbDeviceState {
        AVAILABLE,
        NOT_SUPPORTED,
        UNAUTHORIZED;


        public static @NonNull AdbDeviceState parse(@NonNull String stateString) {
            switch (stateString) {
                case "device": {
                    return AVAILABLE;
                }
                case "unauthorized": {
                    return UNAUTHORIZED;
                }
            }
            return NOT_SUPPORTED;
        }
    }
}

