/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.deviceconn.adb;

import com.arm.streamline.deviceconn.IBasicInteractiveShell;
import com.arm.streamline.deviceconn.adb.IAdbPackageCommandRunner;
import com.arm.streamline.deviceconn.adb.utils.AdbCommandIOException;
import com.arm.streamline.deviceconn.lib.AbstractAsyncByteReaderLineReaderAndLogger;
import com.arm.streamline.deviceconn.lib.AsyncCommandFuture;
import com.arm.streamline.deviceconn.lib.EscapeUtils;
import com.arm.streamline.deviceconn.lib.IProcessInteractiveCommand;
import com.arm.streamline.deviceconn.lib.TerminalWrapperDecoderInteractiveCommandAdapter;
import com.arm.utils.NullChecking;
import com.arm.utils.function.IThrowingBiFunction;
import com.arm.utils.function.IThrowingSupplier;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class AdbPackageCommandRunner
implements IAdbPackageCommandRunner {
    private final @NonNull IThrowingBiFunction<@NonNull String, @NonNull String @NonNull [], @NonNull IProcessInteractiveCommand, IOException> interactiveCommandRunner;
    private final @NonNull String packageDirectory;
    private final @NonNull String packageName;
    private final @NonNull TerminalWrapperDecoderInteractiveCommandAdapter.IRemoteKiller remoteKiller;
    private final @NonNull String terminalWrapperCommand;

    public AdbPackageCommandRunner(@NonNull String packageName, @NonNull String packageDirectory, @NonNull String terminalWrapperCommand, @NonNull TerminalWrapperDecoderInteractiveCommandAdapter.IRemoteKiller remoteKiller, @NonNull IThrowingBiFunction<@NonNull String, @NonNull String @NonNull [], @NonNull IProcessInteractiveCommand, IOException> interactiveCommandRunner) throws IOException {
        this.packageName = packageName;
        this.packageDirectory = packageDirectory;
        this.terminalWrapperCommand = terminalWrapperCommand;
        this.remoteKiller = remoteKiller;
        this.interactiveCommandRunner = interactiveCommandRunner;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void close() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            IProcessInteractiveCommand interactiveCommand = (IProcessInteractiveCommand)this.interactiveCommandRunner.apply((Object)"run-as", (Object)new String[]{this.packageName, "rm", "-f", this.terminalWrapperCommand});
            try {
                try (TerminalWrapperDecoderInteractiveCommandAdapter wrappedCommand = new TerminalWrapperDecoderInteractiveCommandAdapter(interactiveCommand, false, false, (IThrowingSupplier<AbstractAsyncByteReaderLineReaderAndLogger.IByteConsumer, IOException>)((IThrowingSupplier)() -> AbstractAsyncByteReaderLineReaderAndLogger.IByteConsumer.NULL_BYTE_CONSUMER), (IThrowingSupplier<AbstractAsyncByteReaderLineReaderAndLogger.IByteConsumer, IOException>)((IThrowingSupplier)() -> AbstractAsyncByteReaderLineReaderAndLogger.IByteConsumer.NULL_BYTE_CONSUMER), this.makeKiller(interactiveCommand));){
                    @NonNull List<@NonNull String> lines = interactiveCommand.collectAllRemainingOutputAndWaitForExit();
                    @Nullable List<@NonNull String> errorLines = interactiveCommand.getErrorLines();
                    IBasicInteractiveShell.InteractiveCommandResult result = new IBasicInteractiveShell.InteractiveCommandResult((IBasicInteractiveShell.CommandStatus)NullChecking.neverNull((Object)interactiveCommand.getExitCode()), lines, errorLines);
                    if (!result.status.isSuccessful()) {
                        throw new AdbCommandIOException(String.format("run-as %s rm -f %s", this.packageName, this.terminalWrapperCommand), result);
                    }
                }
                if (interactiveCommand == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (interactiveCommand == null) throw throwable;
                interactiveCommand.close();
                throw throwable;
            }
            interactiveCommand.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    @Override
    public @NonNull IBasicInteractiveShell.InteractiveCommandResult runCommandAndGetOutput(@NonNull String command, String ... arguments) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (@NonNull IProcessInteractiveCommand interactiveCommand = this.runInteractiveCommand(command, arguments);){
            @NonNull List<@NonNull String> lines = interactiveCommand.collectAllRemainingOutputAndWaitForExit();
            @Nullable List<@NonNull String> errorLines = interactiveCommand.getErrorLines();
            return new IBasicInteractiveShell.InteractiveCommandResult((IBasicInteractiveShell.CommandStatus)NullChecking.neverNull((Object)interactiveCommand.getExitCode()), lines, errorLines);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public @NonNull IBasicInteractiveShell.InteractiveCommandResult runCommandAndGetOutputAsStream(@NonNull IThrowingSupplier< @NonNull AbstractAsyncByteReaderLineReaderAndLogger.IByteConsumer, IOException> stdOutConsumerFactory, @NonNull String command, String ... arguments) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            IBasicInteractiveShell.InteractiveCommandResult interactiveCommandResult;
            TerminalWrapperDecoderInteractiveCommandAdapter wrappedCommand;
            IProcessInteractiveCommand interactiveCommand;
            block16: {
                block15: {
                    interactiveCommand = (IProcessInteractiveCommand)this.interactiveCommandRunner.apply((Object)"run-as", (Object)this.makeRunAsArguments(true, command, arguments));
                    wrappedCommand = new TerminalWrapperDecoderInteractiveCommandAdapter(interactiveCommand, true, false, stdOutConsumerFactory, (IThrowingSupplier<AbstractAsyncByteReaderLineReaderAndLogger.IByteConsumer, IOException>)((IThrowingSupplier)() -> AbstractAsyncByteReaderLineReaderAndLogger.IByteConsumer.NULL_BYTE_CONSUMER), this.makeKiller(interactiveCommand));
                    @NonNull List<@NonNull String> lines = interactiveCommand.collectAllRemainingOutputAndWaitForExit();
                    @Nullable List<@NonNull String> errorLines = interactiveCommand.getErrorLines();
                    interactiveCommandResult = new IBasicInteractiveShell.InteractiveCommandResult((IBasicInteractiveShell.CommandStatus)NullChecking.neverNull((Object)interactiveCommand.getExitCode()), lines, errorLines);
                    if (wrappedCommand == null) break block15;
                    wrappedCommand.close();
                }
                if (interactiveCommand == null) break block16;
                interactiveCommand.close();
            }
            return interactiveCommandResult;
            {
                catch (Throwable throwable2) {
                    try {
                        if (wrappedCommand != null) {
                            wrappedCommand.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (interactiveCommand != null) {
                            interactiveCommand.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    @Override
    public @NonNull AsyncCommandFuture runCommandAsync(final @NonNull String command, final String ... arguments) throws IOException {
        return new AsyncCommandFuture(new AsyncCommandFuture.IAsyncCommandFutureHelper(){
            private final @NonNull AtomicReference<@Nullable IProcessInteractiveCommand> interactiveCommandRef = new AtomicReference();

            @Override
            public void interrupt(boolean terminate) throws Exception {
                IProcessInteractiveCommand interactiveCommand = this.interactiveCommandRef.get();
                if (interactiveCommand != null) {
                    interactiveCommand.interrupt();
                }
            }

            @Override
            public void kill() throws Exception {
                IProcessInteractiveCommand interactiveCommand = this.interactiveCommandRef.get();
                if (interactiveCommand != null) {
                    interactiveCommand.kill();
                }
            }

            @Override
            public @NonNull String name() {
                return command;
            }

            /*
             * Loose catch block
             */
            @Override
            public @NonNull IBasicInteractiveShell.InteractiveCommandResult waitForResult() throws IOException {
                Throwable throwable = null;
                Object var2_3 = null;
                try {
                    IBasicInteractiveShell.InteractiveCommandResult interactiveCommandResult;
                    TerminalWrapperDecoderInteractiveCommandAdapter interactiveCommand;
                    IProcessInteractiveCommand processInteractiveCommand;
                    block16: {
                        block15: {
                            processInteractiveCommand = (IProcessInteractiveCommand)AdbPackageCommandRunner.this.interactiveCommandRunner.apply((Object)"run-as", (Object)AdbPackageCommandRunner.this.makeRunAsArguments(true, command, arguments));
                            interactiveCommand = new TerminalWrapperDecoderInteractiveCommandAdapter(processInteractiveCommand, false, false, (IThrowingSupplier<AbstractAsyncByteReaderLineReaderAndLogger.IByteConsumer, IOException>)((IThrowingSupplier)() -> AbstractAsyncByteReaderLineReaderAndLogger.IByteConsumer.NULL_BYTE_CONSUMER), (IThrowingSupplier<AbstractAsyncByteReaderLineReaderAndLogger.IByteConsumer, IOException>)((IThrowingSupplier)() -> AbstractAsyncByteReaderLineReaderAndLogger.IByteConsumer.NULL_BYTE_CONSUMER), AdbPackageCommandRunner.this.makeKiller(processInteractiveCommand));
                            this.interactiveCommandRef.set(interactiveCommand);
                            @NonNull List<@NonNull String> lines = interactiveCommand.collectAllRemainingOutputAndWaitForExit();
                            @Nullable List<@NonNull String> errorLines = interactiveCommand.getErrorLines();
                            interactiveCommandResult = new IBasicInteractiveShell.InteractiveCommandResult((IBasicInteractiveShell.CommandStatus)NullChecking.neverNull((Object)interactiveCommand.getExitCode()), lines, errorLines);
                            if (interactiveCommand == null) break block15;
                            interactiveCommand.close();
                        }
                        if (processInteractiveCommand == null) break block16;
                        processInteractiveCommand.close();
                    }
                    return interactiveCommandResult;
                    {
                        catch (Throwable throwable2) {
                            try {
                                if (interactiveCommand != null) {
                                    interactiveCommand.close();
                                }
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                if (processInteractiveCommand != null) {
                                    processInteractiveCommand.close();
                                }
                                throw throwable;
                            }
                        }
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
        });
    }

    @Override
    public @NonNull IProcessInteractiveCommand runInteractiveCommand(@NonNull String command, String ... arguments) throws IOException {
        IProcessInteractiveCommand processInteractiveCommand = (IProcessInteractiveCommand)this.interactiveCommandRunner.apply((Object)"run-as", (Object)this.makeRunAsArguments(true, command, arguments));
        return new TerminalWrapperDecoderInteractiveCommandAdapter(processInteractiveCommand, false, false, (IThrowingSupplier<AbstractAsyncByteReaderLineReaderAndLogger.IByteConsumer, IOException>)((IThrowingSupplier)() -> AbstractAsyncByteReaderLineReaderAndLogger.IByteConsumer.NULL_BYTE_CONSUMER), (IThrowingSupplier<AbstractAsyncByteReaderLineReaderAndLogger.IByteConsumer, IOException>)((IThrowingSupplier)() -> AbstractAsyncByteReaderLineReaderAndLogger.IByteConsumer.NULL_BYTE_CONSUMER), this.makeKiller(processInteractiveCommand));
    }

    private @NonNull TerminalWrapperDecoderInteractiveCommandAdapter.IRemoteKiller makeKiller(final @NonNull IProcessInteractiveCommand command) {
        return new TerminalWrapperDecoderInteractiveCommandAdapter.IRemoteKiller(){

            @Override
            public void interrupt(int pid) throws Exception {
                if (pid == 0) {
                    command.interrupt();
                } else {
                    AdbPackageCommandRunner.this.remoteKiller.interrupt(pid);
                }
            }

            @Override
            public void kill(int pid) throws Exception {
                if (pid == 0) {
                    command.kill();
                } else {
                    AdbPackageCommandRunner.this.remoteKiller.kill(pid);
                }
            }
        };
    }

    private @NonNull String @NonNull [] makeRunAsArguments(boolean shellWrap, @NonNull String command, String ... arguments) {
        @NonNull String @NonNull [] result = new String[4 + (shellWrap ? 3 : 1 + arguments.length)];
        result[0] = this.packageName;
        result[1] = this.terminalWrapperCommand;
        result[2] = "-d";
        result[3] = this.packageDirectory;
        if (shellWrap) {
            @NonNull StringBuilder cmdString = new StringBuilder();
            cmdString.append("exec ");
            cmdString.append(EscapeUtils.escapeArg(command));
            String[] stringArray = arguments;
            int n = arguments.length;
            int n2 = 0;
            while (n2 < n) {
                String argument = stringArray[n2];
                cmdString.append(' ').append(EscapeUtils.escapeArg(argument));
                ++n2;
            }
            cmdString.append("");
            result[4] = "sh";
            result[5] = "-c";
            result[6] = cmdString.toString();
        } else {
            result[4] = command;
            System.arraycopy(arguments, 0, result, 5, arguments.length);
        }
        return result;
    }
}

