/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.deviceconn;

import com.arm.utils.NullChecking;
import com.arm.utils.collections.Triplet;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.NonNull;

public class Log {
    private static final @NonNull Triplet<@NonNull Consumer<@NonNull String>, @NonNull Consumer<@NonNull String>, @NonNull Consumer<@NonNull String>> CONSUMERS = Log.initConsumers();

    private static @NonNull Triplet<@NonNull Consumer<@NonNull String>, @NonNull Consumer<@NonNull String>, @NonNull Consumer<@NonNull String>> initConsumers() {
        Consumer<@NonNull String> infoConsumer = s -> {
            PrintStream printStream = System.err.printf("INFO: %s%n", s);
        };
        Consumer<@NonNull String> warnConsumer = s -> {
            PrintStream printStream = System.err.printf("WARNING: %s%n", s);
        };
        Consumer<@NonNull String> errorConsumer = s -> {
            PrintStream printStream = System.err.printf("ERROR: %s%n", s);
        };
        try {
            Class<?> ilogClass = Class.forName("org.eclipse.core.runtime.ILog");
            Method ofMethod = (Method)NullChecking.neverNull((Object)ilogClass.getDeclaredMethod("of", Class.class));
            Method infoMethod = (Method)NullChecking.neverNull((Object)ilogClass.getDeclaredMethod("info", String.class));
            Method warnMethod = (Method)NullChecking.neverNull((Object)ilogClass.getDeclaredMethod("warn", String.class));
            Method errorMethod = (Method)NullChecking.neverNull((Object)ilogClass.getDeclaredMethod("error", String.class));
            Object logInstance = NullChecking.neverNull((Object)ofMethod.invoke(null, Log.class));
            infoConsumer = Log.makeLogInvoke(logInstance, infoMethod, infoConsumer);
            warnConsumer = Log.makeLogInvoke(logInstance, warnMethod, warnConsumer);
            errorConsumer = Log.makeLogInvoke(logInstance, errorMethod, errorConsumer);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return new Triplet(infoConsumer, warnConsumer, errorConsumer);
    }

    private static @NonNull Consumer<@NonNull String> makeLogInvoke(@NonNull Object instance, @NonNull Method method, Consumer<@NonNull String> defaultConsumer) {
        return s -> {
            try {
                method.invoke(instance, s);
            }
            catch (Throwable e) {
                defaultConsumer.accept((String)s);
                e.printStackTrace();
            }
        };
    }

    public static void info(@NonNull String s) {
        ((Consumer)Log.CONSUMERS.first).accept(s);
    }

    public static void warn(@NonNull String s) {
        ((Consumer)Log.CONSUMERS.second).accept(s);
    }

    public static void error(@NonNull String s) {
        ((Consumer)Log.CONSUMERS.third).accept(s);
    }
}

