/* Copyright (C) 2010-2025 by Arm Limited. All rights reserved. */

#ifndef SESSION_XML_H
#define SESSION_XML_H

#include <string>

#include <mxml.h>

struct ConfigParameters {
    /// buffer mode, "streaming", "low", "normal", "high" defines oneshot and buffer size
    std::string buffer_mode;
    /// capture mode, "high", "normal", or "low"
    std::string sample_rate;
    /// GPU timeline, "yes", "no", or "auto"
    std::string gpu_timeline;
    /// Metric sampling mode, "strobing", "ebs", or "auto"
    std::string metric_sampling_mode;
    /// whether stack unwinding is performed
    bool call_stack_unwinding = false;
    int live_rate = 0;
};

class SessionXML {
public:
    ConfigParameters parameters;

    SessionXML(const char * str);

    // Intentionally unimplemented
    SessionXML(const SessionXML &) = delete;
    SessionXML & operator=(const SessionXML &) = delete;
    SessionXML(SessionXML &&) = delete;
    SessionXML & operator=(SessionXML &&) = delete;

    void parse();

private:
    const char * mSessionXML;

    static void sessionImage(mxml_node_t * node);

    void sessionTag(mxml_node_t * tree, mxml_node_t * node);
};

#endif // SESSION_XML_H
