#!/usr/bin/env bash
# This confidential and proprietary software may be used only as
# authorised by a licensing agreement from Arm Ltd.
#   Copyright: 2025 Arm Ltd. All Rights Reserved.
# The entire notice above must be reproduced on all authorised
# copies and copies may only be made to the extent permitted
# by a licensing agreement from Arm Ltd.

# Script to remove Frame Advisor desktop icons on Linux.

if ! which xdg-icon-resource > /dev/null
then
    echo "ERROR: This script requires xdg-icon-resource to be installed." >&2
    echo "This is part of xdg-utils. Install xdg-utils and try again." >&2
    exit 1
fi

DESKTOP_FILE_BASENAME="Frame Advisor.desktop"
MAIN_INSTALL_PATH="$HOME/.local/share/applications/$DESKTOP_FILE_BASENAME"
DESKTOP_FOLDER_INSTALL_PATH="$HOME/Desktop/$DESKTOP_FILE_BASENAME"

# Remove some Gnome-specific settings.
# (Gnome is the default desktop environment for Ubuntu.)
if [ -f "$MAIN_INSTALL_PATH" ] && which gio > /dev/null
then
    FRAME_ADVISOR_INSTALL_DIR=$(sed -n '/^Path=/s/Path=//p' "$MAIN_INSTALL_PATH")
    FA_FULL_PATH="${FRAME_ADVISOR_INSTALL_DIR}/FrameAdvisor-gui"

    if [ -f "${FA_FULL_PATH}" ]
    then
        echo "Unsetting custom icon in installation directory..."
        gio set -t unset "${FA_FULL_PATH}" metadata::custom-icon-name
    fi
fi

for launcher in "$MAIN_INSTALL_PATH" "$DESKTOP_FOLDER_INSTALL_PATH"
do
    if [ -f "$launcher" ]
    then
        echo "Removing launcher ${launcher}..."
        rm "$launcher"
    fi
done

echo "Removing Frame Advisor icon..."
xdg-icon-resource uninstall --size 256 FrameAdvisor-PS.png

echo "Frame Advisor icons removed."
exit 0
