/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.misc;

import com.arm.streamline.analysis.model.StaticCounterSeriesKey;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.counters.SpeCaptureRecord;
import com.arm.streamline.common.utility.ClusterNameUtils;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class StaticCounterSerieses {
    private final StaticCounterSeriesKey linuxPowerCpuFreq;
    private final @NonNull TIntObjectMap<StaticCounterSeriesKey> linuxPowerCpuFreqByClusterNumber = new TIntObjectHashMap(10, 0.5f, 0);
    private final @NonNull TIntObjectMap<StaticCounterSeriesKey> staticCounterRecordsByKey = new TIntObjectHashMap(10, 0.5f, 0);
    private final @NonNull Map<@NonNull String, @NonNull StaticCounterSeriesKey> tracepointCountersByName = new HashMap<String, StaticCounterSeriesKey>();
    private @NonNull TIntObjectMap<SpeCaptureRecord> speCaptureRecordsByKey = new TIntObjectHashMap();

    public StaticCounterSerieses(@NonNull List<@NonNull CounterRecord> staticCounterRecords, @NonNull TIntObjectMap<String> clusterNames, @NonNull Set<@NonNull SpeCaptureRecord> speCaptureRecords) {
        StaticCounterSeriesKey linuxPowerCpuFreq_ = null;
        speCaptureRecords.forEach(r -> {
            Object object = this.speCaptureRecordsByKey.put(r.getKey(), r);
        });
        for (CounterRecord counterRecord : staticCounterRecords) {
            int key = counterRecord.getKey();
            String name = counterRecord.getCounter();
            String tracepoint = counterRecord.getTracepoint();
            StaticCounterSeriesKey counterSeriesKey = new StaticCounterSeriesKey(counterRecord);
            assert (!this.staticCounterRecordsByKey.containsKey(key));
            this.staticCounterRecordsByKey.put(key, (Object)counterSeriesKey);
            if (name.startsWith("ftrace_") && tracepoint != null) {
                @NonNull String @NonNull [] parts = tracepoint.split("/");
                String tracepointName = parts[parts.length - 1];
                assert (!this.tracepointCountersByName.containsKey(tracepointName));
                this.tracepointCountersByName.put(tracepointName, counterSeriesKey);
                continue;
            }
            if ("Linux_power_cpu_freq".equals(name)) {
                assert (linuxPowerCpuFreq_ == null);
                linuxPowerCpuFreq_ = counterSeriesKey;
                continue;
            }
            if (!name.endsWith("_freq")) continue;
            boolean found = false;
            @NonNull String counterCluster = name.substring(0, name.length() - 5);
            @Nullable String prettyName = ClusterNameUtils.getPrettyName((String)counterCluster);
            TIntObjectIterator itr = clusterNames.iterator();
            while (itr.hasNext() && !found) {
                itr.advance();
                int clusterNumber = itr.key();
                String clusterName = (String)itr.value();
                if (clusterNames.size() != 1 && !clusterName.equals(counterCluster) && (prettyName == null || !clusterName.equals(prettyName))) continue;
                assert (!this.linuxPowerCpuFreqByClusterNumber.containsKey(clusterNumber));
                this.linuxPowerCpuFreqByClusterNumber.put(clusterNumber, (Object)counterSeriesKey);
                found = true;
            }
            assert (found) : String.format("Missing '%s' ('%s'/'%s') from '%s", name, counterCluster, prettyName, clusterNames);
        }
        this.linuxPowerCpuFreq = linuxPowerCpuFreq_;
    }

    public @NonNull Collection<@NonNull StaticCounterSeriesKey> getAllStaticCounterSeries() {
        return Collections.unmodifiableCollection(this.staticCounterRecordsByKey.valueCollection());
    }

    public @Nullable StaticCounterSeriesKey getLinuxPowerCpuFreq(int clusterNumber) {
        @Nullable StaticCounterSeriesKey result = (StaticCounterSeriesKey)this.linuxPowerCpuFreqByClusterNumber.get(clusterNumber);
        if (result != null) {
            return result;
        }
        return this.linuxPowerCpuFreq;
    }

    public @Nullable SpeCaptureRecord getSpeCaptureRecordByKey(int key) {
        return (SpeCaptureRecord)this.speCaptureRecordsByKey.get(key);
    }

    public @Nullable StaticCounterSeriesKey getStaticCounterRecordByKey(int key) {
        return (StaticCounterSeriesKey)this.staticCounterRecordsByKey.get(key);
    }

    public @NonNull Map<@NonNull String, @NonNull StaticCounterSeriesKey> getTracepointCountersByName() {
        return Collections.unmodifiableMap(this.tracepointCountersByName);
    }

    public @Nullable StaticCounterSeriesKey getTracepointCounterSeriesKeyByName(@NonNull String name) {
        return this.tracepointCountersByName.get(name);
    }
}

