/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.misc;

import com.arm.streamline.protocol.misc.ApkEntries;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class AttachedApkEntries {
    private final @NonNull Map<@NonNull String, @NonNull ApkEntries> apksByName;
    private final @NonNull Map<@NonNull String, @NonNull ApkEntries> possiblePackageFragments = new HashMap<String, ApkEntries>();

    public AttachedApkEntries(@NonNull Map<@NonNull String, @NonNull ApkEntries> apksByName) {
        this.apksByName = apksByName;
        apksByName.entrySet().stream().filter(n -> ((String)n.getKey()).endsWith(".apk")).forEach(e -> {
            String n = (String)e.getKey();
            String k = String.format("/%s-", n.substring(0, n.length() - ".apk".length()));
            this.possiblePackageFragments.put(k, (ApkEntries)e.getValue());
        });
    }

    public @Nullable ApkEntries getApkEntriesByFilename(@NonNull String filename) {
        return this.apksByName.get(filename);
    }

    public @Nullable ApkEntries getApkEntriesForNameMatched(@NonNull String executableCompletePath) {
        List apkEntries = this.possiblePackageFragments.entrySet().stream().filter(n -> executableCompletePath.contains((CharSequence)n.getKey())).map(n -> (ApkEntries)n.getValue()).collect(Collectors.toList());
        return apkEntries.size() == 1 ? (ApkEntries)apkEntries.get(0) : null;
    }

    public boolean hasApksAttached() {
        return !this.apksByName.isEmpty();
    }

    public @Nullable ApkEntries getOnlyApk() {
        if (this.apksByName.size() != 1) {
            return null;
        }
        return this.apksByName.values().iterator().next();
    }
}

