/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.misc;

import com.arm.streamline.analysis.model.threads.IExecutablePath;
import com.arm.streamline.protocol.misc.ApkEntries;
import com.arm.streamline.protocol.misc.AttachedApkEntries;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class ApkEntryUtility {
    public static final @NonNull String EXTN_APK = ".apk";
    public static final @NonNull String BASE_APK = "base.apk";

    public static @Nullable ApkEntries findZipFileByExecutablePath(@NonNull IExecutablePath executablePath, @NonNull AttachedApkEntries attachedApkEntries, boolean allowMatchingSingleApk) {
        ApkEntries exactlyMatchedEntryByPackage;
        String executableName = executablePath.getBaseName();
        ApkEntries exactlyMatchedEntryByBaseName = attachedApkEntries.getApkEntriesByFilename(executableName);
        if (exactlyMatchedEntryByBaseName != null) {
            return exactlyMatchedEntryByBaseName;
        }
        String packageName = executablePath.extractAndroidPackageName();
        ApkEntries apkEntries = exactlyMatchedEntryByPackage = packageName != null ? attachedApkEntries.getApkEntriesByFilename(packageName + EXTN_APK) : null;
        if (exactlyMatchedEntryByPackage != null) {
            return exactlyMatchedEntryByPackage;
        }
        if (!ApkEntryUtility.isBaseApk(executableName)) {
            return null;
        }
        ApkEntries fuzzyMatchedByPath = attachedApkEntries.getApkEntriesForNameMatched(executablePath.getFullPath());
        if (fuzzyMatchedByPath != null) {
            return fuzzyMatchedByPath;
        }
        if (!allowMatchingSingleApk) {
            return null;
        }
        return attachedApkEntries.getOnlyApk();
    }

    public static boolean isApkName(@NonNull String baseName) {
        return baseName.endsWith(EXTN_APK);
    }

    private static boolean isBaseApk(@NonNull String fileName) {
        return fileName.contentEquals(BASE_APK);
    }
}

