/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.gator.io;

import com.arm.streamline.protocol.gator.io.APCByteDataCodec;
import java.io.IOException;
import java.nio.charset.Charset;
import org.eclipse.jdt.annotation.NonNull;

public interface IAPCByteWriter {
    default public void write(byte @NonNull [] value) throws IOException {
        this.write(value, 0, value.length);
    }

    public void write(byte @NonNull [] var1, int var2, int var3);

    public void writeByte(byte var1) throws IOException;

    default public void writeGatorString(@NonNull String value) throws IOException {
        APCByteDataCodec.writeGatorString(this, value);
    }

    default public void writeLEInt(int value) throws IOException {
        this.write(new byte[]{(byte)(value >>> 0), (byte)(value >>> 8), (byte)(value >>> 16), (byte)(value >>> 24)});
    }

    default public void writeLELong(long value) throws IOException {
        this.write(new byte[]{(byte)(value >>> 0), (byte)(value >>> 8), (byte)(value >>> 16), (byte)(value >>> 24), (byte)(value >>> 32), (byte)(value >>> 40), (byte)(value >>> 48), (byte)(value >>> 56)});
    }

    default public void writeNullTerminatedString(@NonNull String value, @NonNull Charset characterSet) throws IOException {
        APCByteDataCodec.writeNullTerminatedString(this, value, characterSet);
    }

    default public void writePackedInt(int value) throws IOException {
        APCByteDataCodec.writePackedInt(this, value);
    }

    default public void writePackedLong(long value) throws IOException {
        APCByteDataCodec.writePackedLong(this, value);
    }
}

