/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.gator.io;

import com.arm.streamline.protocol.gator.io.IAPCByteReader;
import com.arm.streamline.protocol.gator.io.IAPCByteWriter;
import gnu.trove.list.array.TByteArrayList;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.eclipse.jdt.annotation.NonNull;

public final class APCByteDataCodec {
    public static int getPackedInt(@NonNull IAPCByteReader stream) throws IOException {
        return (int)APCByteDataCodec.getPackedLong(stream);
    }

    public static long getPackedLong(@NonNull IAPCByteReader stream) throws IOException {
        long size = 64L;
        long l = 0L;
        long shift = 0L;
        int b = -1;
        while ((b & 0x80) != 0) {
            b = stream.getSignedByte();
            l |= (long)(b & 0x7F) << (int)shift;
            shift += 7L;
        }
        if (shift < 64L && (b & 0x40) != 0) {
            l |= -(1L << (int)shift);
        }
        return l;
    }

    public static @NonNull String readGatorString(@NonNull IAPCByteReader stream) throws IOException {
        int length = stream.getPackedInt();
        if (length <= 0) {
            return "";
        }
        byte[] buffer = new byte[length];
        stream.get(buffer);
        return new String(buffer, 0, length, StandardCharsets.US_ASCII);
    }

    public static @NonNull String readNullTerminatedString(@NonNull IAPCByteReader stream, @NonNull Charset characterSet) throws IOException {
        TByteArrayList buffer = new TByteArrayList();
        while (stream.hasRemaining()) {
            byte b = stream.getSignedByte();
            if (b == 0) break;
            buffer.add(b);
        }
        return new String(buffer.toArray(), characterSet);
    }

    public static void writeGatorString(@NonNull IAPCByteWriter stream, @NonNull String value) throws IOException {
        byte @NonNull [] bytes = value.getBytes(StandardCharsets.US_ASCII);
        stream.writePackedInt(bytes.length);
        stream.write(bytes);
    }

    public static void writeNullTerminatedString(@NonNull IAPCByteWriter stream, @NonNull String value, @NonNull Charset characterSet) throws IOException {
        byte @NonNull [] bytes = value.getBytes(characterSet);
        int nullTerminatorIndex = APCByteDataCodec.findNullTerminator(bytes);
        assert (nullTerminatorIndex == bytes.length);
        stream.write(bytes, 0, nullTerminatorIndex);
        stream.writeByte((byte)0);
    }

    public static void writePackedInt(@NonNull IAPCByteWriter stream, int value) throws IOException {
        APCByteDataCodec.writePackedLong(stream, value);
    }

    public static void writePackedLong(@NonNull IAPCByteWriter stream, long value) throws IOException {
        boolean more = true;
        while (more) {
            byte b = (byte)(value & 0x7FL);
            if ((value >>= 7) == 0L && (b & 0x40) == 0 || value == -1L && (b & 0x40) != 0) {
                more = false;
            } else {
                b = (byte)(b | 0x80);
            }
            stream.writeByte(b);
        }
    }

    private static int findNullTerminator(byte @NonNull [] bytes) {
        int i = 0;
        while (i < bytes.length) {
            if (bytes[i] == 0) {
                return i;
            }
            ++i;
        }
        return bytes.length;
    }
}

