/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.protocol.v22;

import com.arm.streamline.analysis.database.api.profiling.IBacktraceSource;
import com.arm.streamline.ftrace.TracepointFormat;
import com.arm.streamline.protocol.capture.apc.io.APCFrameAddress;
import com.arm.streamline.protocol.capture.apc.protocol.IGatorPerVirtualMachineProtocolEventConsumer;
import com.arm.streamline.protocol.capture.apc.time.ClockSource;
import com.arm.streamline.protocol.gator.v22.BlockCounterFrame;
import com.arm.streamline.protocol.gator.v22.ExternalFrame;
import com.arm.streamline.protocol.gator.v22.MetadataFrame;
import com.arm.streamline.protocol.gator.v22.ProcFrame;
import com.arm.streamline.protocol.gator.v22.SummaryFrame;
import com.arm.streamline.protocol.gator.v22.perf.IStreamingMessageConsumerPerfV22;
import com.arm.streamline.protocol.gator.v22.perf.PerfAuxFrame;
import com.arm.streamline.protocol.gator.v22.perf.PerfDataFrame;
import com.arm.streamline.protocol.gator.v22.perf.PerfSyncThreadFrame;
import com.arm.streamline.protocol.misc.TaskId;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;

public class GatorPassStreamingMessageConsumerV22
implements IStreamingMessageConsumerPerfV22 {
    public static final long VMUID = 0L;
    protected final @NonNull APCFrameAddress address;
    protected final @NonNull IGatorPerVirtualMachineProtocolEventConsumer eventConsumer;
    protected final @NonNull IBacktraceSource gatorBacktraceSource;

    protected static @NonNull IGatorPerVirtualMachineProtocolEventConsumer.SchedulerSwitchReason mapSwitchReason(int state) {
        switch (state) {
            case 0: {
                return IGatorPerVirtualMachineProtocolEventConsumer.SchedulerSwitchReason.SCHEDULED;
            }
            case 1: {
                return IGatorPerVirtualMachineProtocolEventConsumer.SchedulerSwitchReason.CONTENTION;
            }
            case 2: {
                return IGatorPerVirtualMachineProtocolEventConsumer.SchedulerSwitchReason.WAIT_IO;
            }
        }
        assert (false);
        return IGatorPerVirtualMachineProtocolEventConsumer.SchedulerSwitchReason.SCHEDULED;
    }

    public GatorPassStreamingMessageConsumerV22(@NonNull APCFrameAddress address, @NonNull IBacktraceSource gatorBacktraceSource, @NonNull IGatorPerVirtualMachineProtocolEventConsumer eventConsumer) {
        this.address = address;
        this.eventConsumer = eventConsumer;
        this.gatorBacktraceSource = gatorBacktraceSource;
    }

    @Override
    public  @NonNull BlockCounterFrame.IBlockCounterFrameMessageConsumer consume(int cpu) throws IOException {
        return new BlockCounterFrame.IBlockCounterFrameMessageConsumer(cpu){
            private @NonNull ClockSource clockSource = ClockSource.BEFORE_START;
            private @NonNull Integer deviceNumber;
            private int tid;
            private long timestamp;
            {
                this.deviceNumber = n;
                this.tid = 0;
                this.timestamp = 0L;
            }

            @Override
            public void close() throws IOException {
            }

            @Override
            public void consume( @NonNull BlockCounterFrame.BlockCounterRecord record) throws IOException {
                switch (record.key) {
                    case 0: {
                        this.clockSource = ClockSource.MONOTONIC_DELTA;
                        this.timestamp = record.value;
                        this.tid = 0;
                        return;
                    }
                    case -1: {
                        this.clockSource = ClockSource.LOCAL_CLOCK_OR_MONOTONIC_RAW;
                        this.timestamp = record.value;
                        this.tid = 0;
                        return;
                    }
                    case 1: {
                        this.tid = (int)record.value;
                        return;
                    }
                    case 2: {
                        this.deviceNumber = (int)record.value;
                        return;
                    }
                }
                if (this.tid == 0) {
                    GatorPassStreamingMessageConsumerV22.this.eventConsumer.counter(GatorPassStreamingMessageConsumerV22.this.address, this.clockSource, this.timestamp, this.deviceNumber, null, record.key, record.value);
                } else if (this.tid == -1) {
                    GatorPassStreamingMessageConsumerV22.this.eventConsumer.counter(GatorPassStreamingMessageConsumerV22.this.address, this.clockSource, this.timestamp, null, null, record.key, record.value);
                } else {
                    GatorPassStreamingMessageConsumerV22.this.eventConsumer.counter(GatorPassStreamingMessageConsumerV22.this.address, this.clockSource, this.timestamp, null, new TaskId(this.tid), record.key, record.value);
                }
            }
        };
    }

    @Override
    public @NonNull ProcFrame.IProcFrameMessageConsumer consume(@NonNull ProcFrame message) throws IOException {
        return new ProcFrame.IProcFrameMessageConsumer(){

            @Override
            public void close() throws IOException {
            }

            @Override
            public void consume(@NonNull ProcFrame message, @NonNull ProcFrame.CommMessage record) throws IOException {
                GatorPassStreamingMessageConsumerV22.this.eventConsumer.threadProperties(GatorPassStreamingMessageConsumerV22.this.address, ClockSource.BEFORE_START, 0L, null, new TaskId(record.pid, record.tid), record.comm, record.image, null);
            }

            @Override
            public void consume(@NonNull ProcFrame message, @NonNull ProcFrame.CountersMessage record) throws IOException {
                int @NonNull [] cpus = record.cpus;
                int @NonNull [] keys = record.keys;
                long @NonNull [] values = record.values;
                if (!$assertionsDisabled && cpus.length != keys.length) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && keys.length != values.length) {
                    throw new AssertionError();
                }
                int i = 0;
                while (i < record.cpus.length) {
                    GatorPassStreamingMessageConsumerV22.this.eventConsumer.counter(GatorPassStreamingMessageConsumerV22.this.address, ClockSource.MONOTONIC_DELTA, record.timestamp, cpus[i], null, keys[i], values[i]);
                    ++i;
                }
            }

            @Override
            public void consume(@NonNull ProcFrame message, @NonNull ProcFrame.FormatMessage record) throws IOException {
                GatorPassStreamingMessageConsumerV22.this.eventConsumer.tracepointFormat(new TracepointFormat(record.string));
            }

            @Override
            public void consume(@NonNull ProcFrame message, @NonNull ProcFrame.HeaderEventMessage record) throws IOException {
                GatorPassStreamingMessageConsumerV22.this.eventConsumer.tracepointFormat(new TracepointFormat(-2147483646, record.string));
            }

            @Override
            public void consume(@NonNull ProcFrame message, @NonNull ProcFrame.HeaderPageMessage record) throws IOException {
                GatorPassStreamingMessageConsumerV22.this.eventConsumer.tracepointFormat(new TracepointFormat(-2147483647, record.string));
            }

            @Override
            public void consume(@NonNull ProcFrame message, @NonNull ProcFrame.KAllSymsMessage record) throws IOException {
                GatorPassStreamingMessageConsumerV22.this.eventConsumer.kAllSyms(record.string);
            }

            @Override
            public void consume(@NonNull ProcFrame message, @NonNull ProcFrame.MapsMessage record) throws IOException {
                GatorPassStreamingMessageConsumerV22.this.eventConsumer.threadMaps(GatorPassStreamingMessageConsumerV22.this.address, ClockSource.BEFORE_START, 0L, new TaskId(record.pid, record.tid), record.maps);
            }

            @Override
            public void consume(@NonNull ProcFrame message, @NonNull ProcFrame.OnlineOfflineCpuMessage record) throws IOException {
                GatorPassStreamingMessageConsumerV22.this.eventConsumer.idle(GatorPassStreamingMessageConsumerV22.this.address, ClockSource.MONOTONIC_DELTA, record.timestamp, record.cpu, record.online);
            }

            @Override
            public void consume(@NonNull ProcFrame message, @NonNull ProcFrame.PerfEventAttributeMessage record) throws IOException {
                GatorPassStreamingMessageConsumerV22.this.eventConsumer.addPerfEventAttributeByKey(record.key, record.attribute);
            }

            @Override
            public void consume(@NonNull ProcFrame message, @NonNull ProcFrame.PerfKeysMessage record) throws IOException {
                int i = 0;
                while (i < record.ids.length) {
                    GatorPassStreamingMessageConsumerV22.this.eventConsumer.addPerfEventAttributeIdToKeyMapping(record.ids[i], record.keys[i]);
                    ++i;
                }
            }

            @Override
            public void consume(@NonNull ProcFrame message, @NonNull ProcFrame.PerfLegacyKeysMessage record) throws IOException {
                int i = 0;
                while (i < record.ids.length) {
                    GatorPassStreamingMessageConsumerV22.this.eventConsumer.addPerfEventAttributeIdToKeyMapping(record.ids[i], record.keys[i]);
                    ++i;
                }
            }

            @Override
            public void consume(@NonNull ProcFrame message, @NonNull ProcFrame.MetricKeyMessage record) throws IOException {
            }

            @Override
            public void consume(@NonNull ProcFrame message, @NonNull ProcFrame.KernelBuildIdMessage kernelBuildIdMessage) throws IOException {
            }

            @Override
            public void consume(@NonNull ProcFrame message, @NonNull ProcFrame.KernelModuleBuildIdMessage kernelModuleBuildIdMessage) throws IOException {
            }
        };
    }

    @Override
    public  @NonNull ExternalFrame.IExternalFrameMessageConsumer consumeExternalFrame() throws IOException {
        return new ExternalFrame.IExternalFrameMessageConsumer(){

            @Override
            public void close() throws IOException {
            }

            @Override
            public void consume( @NonNull ExternalFrame.ExternalDataChannelCloseRecord record) throws IOException {
                GatorPassStreamingMessageConsumerV22.this.eventConsumer.externalClosed(record.fd);
            }

            @Override
            public void consume( @NonNull ExternalFrame.ExternalDataRecord record) throws IOException {
                GatorPassStreamingMessageConsumerV22.this.eventConsumer.externalData(GatorPassStreamingMessageConsumerV22.this.address, record.fd, record.offset, record.data);
            }
        };
    }

    @Override
    public  @NonNull MetadataFrame.IRecordConsumer consumeMetadataFrame() throws IOException {
        return new MetadataFrame.IRecordConsumer(){

            @Override
            public void close() throws IOException {
            }

            @Override
            public void consume( @NonNull MetadataFrame.Record record) throws IOException {
                GatorPassStreamingMessageConsumerV22.this.eventConsumer.metadata(GatorPassStreamingMessageConsumerV22.this.address, record.key, record.value);
            }
        };
    }

    @Override
    public void consumePerfAuxFrame(@NonNull PerfAuxFrame frame) throws IOException {
        this.eventConsumer.perfAuxBuffer(this.address, frame.cpu, frame.offset, frame.data);
    }

    @Override
    public  @NonNull PerfDataFrame.IPerfDataFrameMessageConsumer consumePerfDataFrame() throws IOException {
        return new PerfDataFrame.IPerfDataFrameMessageConsumer(){

            @Override
            public void close() throws IOException {
            }

            @Override
            public void consume( @NonNull PerfDataFrame.PerfDataFrameRecord record) throws IOException {
                GatorPassStreamingMessageConsumerV22.this.eventConsumer.perfDataBuffer(GatorPassStreamingMessageConsumerV22.this.address, record.cpu, record.data);
            }
        };
    }

    @Override
    public void consumePerfSyncThreadFrame(@NonNull PerfSyncThreadFrame frame) throws IOException {
        int i = 0;
        while (i < frame.monotonicRaws.length) {
            if (frame.freq != 0L) {
                this.eventConsumer.perfSpeSyncEvent(frame.cpu, frame.monotonicRaws[i], frame.vcounts[i], frame.freq);
            }
            ++i;
        }
    }

    @Override
    public  @NonNull SummaryFrame.ISummaryFrameMessageConsumer consumeSummaryFrame() throws IOException {
        return new SummaryFrame.ISummaryFrameMessageConsumer(){

            @Override
            public void close() throws IOException {
            }

            @Override
            public void consume( @NonNull SummaryFrame.CoreNameMessage record) throws IOException {
                GatorPassStreamingMessageConsumerV22.this.eventConsumer.processingElementProperties(record.core, record.cpuid, record.name, null);
            }

            @Override
            public void consume( @NonNull SummaryFrame.SummaryMessage record) throws IOException {
                boolean nosync = record.attributes.containsKey("nosync");
                GatorPassStreamingMessageConsumerV22.this.eventConsumer.captureProperties(record.wallClockTime, record.bootTime, record.monotonicTime, nosync, record.attributes);
            }
        };
    }
}

