/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.protocol.external.tl;

import com.arm.streamline.protocol.capture.apc.protocol.external.tl.OpenClDevice;
import java.util.HashMap;
import java.util.Map;
import java.util.function.IntSupplier;
import org.eclipse.jdt.annotation.NonNull;

public final class OpenClContext {
    private final @NonNull Map<@NonNull String, @NonNull OpenClDevice> devices;
    private final long id;
    private final int trackUID;
    private final @NonNull IntSupplier trackUIDSupplier;

    public OpenClContext(long id, @NonNull IntSupplier trackUIDSupplier) {
        this.id = id;
        this.trackUIDSupplier = trackUIDSupplier;
        this.trackUID = trackUIDSupplier.getAsInt();
        this.devices = new HashMap<String, OpenClDevice>();
    }

    public long getId() {
        return this.id;
    }

    public @NonNull OpenClDevice getOrCreateDevice(@NonNull String deviceName) {
        assert (!deviceName.isEmpty());
        return this.devices.computeIfAbsent(deviceName, dn -> new OpenClDevice(this, (String)dn, this.trackUIDSupplier.getAsInt()));
    }

    public int getTrackUID() {
        return this.trackUID;
    }

    public String toString() {
        return String.format("0x%x", this.id);
    }
}

