/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.protocol.external.mipe;

import com.arm.streamline.protocol.ProtocolException;
import com.arm.streamline.protocol.capture.apc.protocol.external.mipe.MipeHeader;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class MipePacket_Huge_WinDump {
    public final int bpp;
    public final @NonNull MipeHeader header;
    public final int height;
    public final byte @NonNull [] imageData;
    public final int maskA;
    public final int maskB;
    public final int maskG;
    public final int maskR;
    public final long timestamp;
    public final int width;

    public static @Nullable MipePacket_Huge_WinDump create(@NonNull MipeHeader header, byte @NonNull [] data) throws ProtocolException {
        if (header.getPacketFamily() != 2 || header.getPacketClass() != 0 || header.getPacketType() != 0) {
            throw new IllegalArgumentException();
        }
        int dataLength = header.getDataLength();
        if (dataLength == 0) {
            return null;
        }
        if (dataLength > data.length) {
            throw new IllegalArgumentException();
        }
        if (dataLength < 32) {
            throw new ProtocolException(ProtocolException.Reason.INVALID_MALI_ENCAPSULATED_DATA);
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(data, 0, dataLength);
        byteBuffer.order(header.getByteOrder());
        long timestamp = byteBuffer.getLong();
        int size = byteBuffer.getInt();
        int height = size & 0xFFFF;
        int width = size >>> 16 & 0xFFFF;
        int bppWord = byteBuffer.getInt();
        assert ((bppWord & 0xFFFFFF00) == 0);
        int bpp = bppWord & 0xFF;
        int maskR = byteBuffer.getInt();
        int maskG = byteBuffer.getInt();
        int maskB = byteBuffer.getInt();
        int maskA = byteBuffer.getInt();
        byte[] imageData = new byte[byteBuffer.remaining()];
        byteBuffer.get(imageData);
        return new MipePacket_Huge_WinDump(header, timestamp, width, height, bpp, maskR, maskG, maskB, maskA, imageData);
    }

    protected MipePacket_Huge_WinDump(@NonNull MipeHeader header, long timestamp, int width, int height, int bpp, int maskR, int maskG, int maskB, int maskA, byte @NonNull [] imageData) {
        this.header = header;
        this.timestamp = timestamp;
        this.width = width;
        this.height = height;
        this.bpp = bpp;
        this.maskR = maskR;
        this.maskG = maskG;
        this.maskB = maskB;
        this.maskA = maskA;
        this.imageData = imageData;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MipePacket_Huge_WinDump) {
            MipePacket_Huge_WinDump that = (MipePacket_Huge_WinDump)obj;
            return this.header.equals(that.header) && this.timestamp == that.timestamp && this.width == that.width && this.height == that.height && this.bpp == that.bpp && this.maskR == that.maskR && this.maskG == that.maskG && this.maskB == that.maskB && this.maskA == that.maskA && Arrays.equals(this.imageData, that.imageData);
        }
        return false;
    }

    public int hashCode() {
        return this.header.hashCode() * 31 + Long.hashCode(this.timestamp);
    }

    public String toString() {
        return String.format("MipePacket_Huge_WinDump [header=%s, timestamp=%s, width=%s, height=%s, bpp=%s, maskR=0x%08x, maskG=0x%08x, maskB=0x%08x, maskA=0x%08x, imageData=%s]", this.header, this.timestamp, this.width, this.height, this.bpp, this.maskR, this.maskG, this.maskB, this.maskA, String.format("<%d bytes>", this.imageData.length));
    }
}

