/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.protocol.external;

import com.arm.streamline.common.analysis.model.AnnotationColour;
import com.arm.streamline.common.utility.text.NumberUtils;
import com.arm.streamline.protocol.capture.apc.pass_two.warnings.WarningsFactory;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolEventStream;
import com.arm.streamline.protocol.capture.apc.protocol.external.IMaliOpenCLCAMGenerator;
import com.arm.streamline.protocol.capture.apc.protocol.external.mipe.MipeVersion;
import com.arm.streamline.protocol.capture.apc.protocol.external.tl.OpenClClosure;
import com.arm.streamline.protocol.capture.apc.protocol.external.tl.OpenClCommand;
import com.arm.streamline.protocol.capture.apc.protocol.external.tl.OpenClContext;
import com.arm.streamline.protocol.capture.apc.protocol.external.tl.OpenClDevice;
import com.arm.streamline.protocol.capture.apc.protocol.external.tl.OpenClEvent;
import com.arm.streamline.protocol.capture.apc.protocol.external.tl.OpenClKernel;
import com.arm.streamline.protocol.capture.apc.protocol.external.tl.OpenClQueue;
import com.arm.streamline.protocol.capture.apc.protocol.external.tl.OpenClTimeline;
import com.arm.streamline.protocol.capture.apc.protocol.external.tl.SyncCmd;
import com.arm.streamline.protocol.capture.apc.time.ClockSource;
import com.arm.utils.NullChecking;
import com.arm.utils.numbers.UnsignedLong;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongIntHashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class MaliOpenCLCAMGenerator
implements IMaliOpenCLCAMGenerator {
    public static final @NonNull String EXECUTION_TRACK_NAME = "Execution";
    public static final @NonNull String HOST_NAME = "Host";
    public static final @NonNull String JOB_CHAIN_JOB_NAME_FORMAT = "%d jobs";
    public static final @NonNull String JOB_CHAIN_TRACK_NAME = "Job Chain";
    public static final @NonNull String MEMORY_TRACK_NAME = "Memory";
    public static final @NonNull String OPENCL_CONTEXT_PREFIX = "OpenCL Context: ";
    public static final @NonNull String QUEUE_NAME_PREFIX = "Queue ";
    public static final @NonNull String SYNC_TRACK_NAME = "Sync";
    public static final @NonNull String THREAD_NAME_PREFIX = "Thread ";
    public static final @NonNull String VIEW_NAME = "OpenCL";
    protected static final boolean DEBUG = false;
    protected static final boolean LOG = false;
    private static final String JOB_CHAIN_JOB_NAME = "%d jobs";
    private static final int MALI_GRAPHICS_VIEW_UID = 19901127;
    private static final int @NonNull [] NO_DEPENDENCIES = new int[0];
    private static final int NO_PRIMARY_DEPENDENCY = -1;
    private static final @NonNull String UNKNOWN = "Unknown";
    private static final @NonNull String UNKNOWN_CONTEXT = "Unknown Context";
    private static final long UNKNOWN_CONTEXT_ID = 0L;
    private static final @NonNull String UNKNOWN_DEVICE = "Unknown Device";
    private final @NonNull TLongObjectMap<DeletedCommand> deletedCommands = new TLongObjectHashMap(10, 0.5f, 0L);
    private int mCyclicChainColor = 0;
    private int mCyclicExecColor = 1;
    private int mCyclicMemColor = 2;
    private int mCyclicSyncColor = 3;
    private final @NonNull TIntHashSet mDroppedJobs = new TIntHashSet();
    private boolean mGPUCORE1193Fixes;
    private int mHostTrack = 1;
    private int mJobUID = 1;
    private final @NonNull Map<@NonNull String, @NonNull AnnotationColour> mNameToColorMap = new HashMap<String, AnnotationColour>();
    private final @NonNull TLongObjectHashMap<ArrayDeque<SyncCmd>> mThreadToSyncCmds = new TLongObjectHashMap();
    private final @NonNull TLongIntHashMap mThreadtoThreadUIDMap = new TLongIntHashMap();
    private boolean mTimestampWarning;
    private int mTrackUID = 2;
    private final @NonNull IExternalProtocolEventStream outputStream;
    private final @NonNull Set<@NonNull OpenClQueue> queuesUsed = new HashSet<OpenClQueue>();
    private final @NonNull Set<@NonNull OpenClQueue> queuesWithChainTrack = new HashSet<OpenClQueue>();
    private final @NonNull OpenClTimeline timeline;

    public static boolean isNotSpeciallyNamedOpenCLTrack(@NonNull String title) {
        return !title.startsWith(OPENCL_CONTEXT_PREFIX) && !title.startsWith(QUEUE_NAME_PREFIX) && !title.startsWith(THREAD_NAME_PREFIX) && !title.startsWith(SYNC_TRACK_NAME) && !title.startsWith(EXECUTION_TRACK_NAME) && !title.startsWith(MEMORY_TRACK_NAME) && !title.startsWith(HOST_NAME);
    }

    public static void log(String text) {
    }

    private static void debug(String text) {
    }

    private static long findStartTime(@NonNull List<@NonNull OpenClCommand.OpenClCommandChainJob> validJobs) {
        return validJobs.stream().mapToLong(OpenClCommand.OpenClCommandChainJob::getStartTimestamp).min().orElse(0L);
    }

    private static long findStopTime(@NonNull List<@NonNull OpenClCommand.OpenClCommandChainJob> validJobs) {
        return validJobs.stream().mapToLong(OpenClCommand.OpenClCommandChainJob::getStopTimestamp).max().orElse(0L);
    }

    private static int mapCommandTypeToLeafTrack(@NonNull OpenClQueue queue, @NonNull OpenClCommand.OpenClCommandType type) {
        switch (type) {
            case EXEC: {
                return queue.getExecTrackUID();
            }
            case MEM: {
                return queue.getMemoryTrackUID();
            }
        }
        throw new AssertionError((Object)type);
    }

    public MaliOpenCLCAMGenerator(@NonNull IExternalProtocolEventStream outputStream) throws IOException {
        this.outputStream = outputStream;
        outputStream.camView(19901127, VIEW_NAME);
        outputStream.camTrack(19901127, -1, this.mHostTrack, HOST_NAME);
        this.timeline = new OpenClTimeline(() -> this.mTrackUID++, () -> this.mJobUID++);
    }

    @Override
    public void attributeClosureTimestamps(long timestamp, long threadID, long closure, long start, long stop) throws IOException {
        DeletedCommand deletedCommand;
        MaliOpenCLCAMGenerator.log("attributeClosureTimestamps timestamp=" + timestamp + ", threadID=" + threadID + ", closure=" + closure + ", start=" + start + ", stop=" + stop);
        @Nullable OpenClCommand commandObject = this.timeline.getCommandForClosure(closure);
        if (commandObject == null) {
            MaliOpenCLCAMGenerator.debug("Unable to associate attributeClosureTimestamps to a job");
            return;
        }
        commandObject.setAccurateStartAndStopTimes(start, stop);
        if (commandObject.seenAccurateTimestamps() && (deletedCommand = (DeletedCommand)this.deletedCommands.get(commandObject.getId())) != null && deletedCommand.commandObject == commandObject) {
            this.deletedCommands.remove(commandObject.getId());
            this.flushCommand(deletedCommand.timestamp, deletedCommand.threadID, deletedCommand.commandObject);
        }
    }

    @Override
    public void attributeCommandAPIName(long timestamp, long threadID, long command, String apiName) {
        MaliOpenCLCAMGenerator.log("attributeCommandAPIName timestamp=" + timestamp + ", threadID=" + threadID + ", command=" + command + ", apiName=" + apiName);
        @Nullable OpenClCommand commandObject = this.timeline.getCommand(command);
        if (commandObject == null) {
            MaliOpenCLCAMGenerator.debug("Invalid closure received in attributeCommandAPIName");
            return;
        }
        commandObject.setCommandApiName(apiName);
    }

    @Override
    public void attributeKernelName(long timestamp, long threadID, long kernel, String name) {
        MaliOpenCLCAMGenerator.log("attributeKernelName timestamp=" + timestamp + ", threadID=" + threadID + ", kernel=" + kernel + ", name=" + name);
        @NonNull OpenClKernel kernelObject = this.timeline.getOrCreateKernel(kernel);
        if (!name.isEmpty()) {
            kernelObject.setName(name);
        }
    }

    @Override
    public void attributeQueueDeviceName(long timestamp, long threadID, long queue, String deviceName) throws IOException {
        MaliOpenCLCAMGenerator.log("attributeQueueDeviceName timestamp=" + timestamp + ", threadID=" + threadID + ", queue=" + queue + ", deviceName=" + deviceName);
        if (deviceName.isEmpty()) {
            return;
        }
        @NonNull OpenClQueue queueObject = this.timeline.getOrCreateQueue(queue);
        @Nullable OpenClContext contextObject = queueObject.getContext();
        if (contextObject != null) {
            @NonNull OpenClDevice deviceObject = contextObject.getOrCreateDevice(deviceName);
            queueObject.setDevice(deviceObject);
        } else {
            queueObject.setDeviceName(deviceName);
        }
    }

    @Override
    public void attributeThreadAPIName(long timestamp, long threadID, String apiName) {
        ArrayDeque<SyncCmd> syncCmds;
        MaliOpenCLCAMGenerator.log("attributeThreadAPIName timestamp=" + timestamp + ", threadID=" + threadID + ", apiName=" + apiName);
        if (apiName.isEmpty()) {
            MaliOpenCLCAMGenerator.debug("Sync command apiName not found: " + apiName);
            apiName = UNKNOWN;
        }
        if ((syncCmds = (ArrayDeque<SyncCmd>)this.mThreadToSyncCmds.get(threadID)) == null) {
            syncCmds = new ArrayDeque<SyncCmd>();
            this.mThreadToSyncCmds.put(threadID, syncCmds);
        }
        syncCmds.add(new SyncCmd(timestamp, apiName));
    }

    @Override
    public void blockQueue(long timestamp, long threadID, long queue) throws IOException {
        this.dependencyThreadToQueueOrBlockQueue("blockQueue", timestamp, threadID, queue);
    }

    @Override
    public void close() throws IOException {
        ArrayList deletedCommandsCopy = new ArrayList(this.deletedCommands.valueCollection());
        this.deletedCommands.clear();
        for (DeletedCommand deletedCommand : deletedCommandsCopy) {
            this.flushCommand(deletedCommand.timestamp, deletedCommand.threadID, deletedCommand.commandObject);
        }
        @NonNull HashSet<@NonNull OpenClContext> emittedContexts = new HashSet<OpenClContext>();
        @NonNull HashSet<@NonNull OpenClDevice> emittedDevices = new HashSet<OpenClDevice>();
        @NonNull HashSet<@NonNull OpenClQueue> emittedQueues = new HashSet<OpenClQueue>();
        for (OpenClQueue queueObject : this.timeline.getQueues()) {
            if (!this.queuesUsed.contains(queueObject)) continue;
            @Nullable OpenClDevice queueDeviceObject = queueObject.getDevice();
            if (queueDeviceObject != null) {
                this.emitQueueTracks(queueObject, queueDeviceObject, emittedContexts, emittedDevices, emittedQueues);
                continue;
            }
            @Nullable OpenClContext queueContextObject = queueObject.getContext();
            @NonNull OpenClContext contextObjectToUse = queueContextObject != null ? queueContextObject : this.timeline.getOrCreateContext(0L);
            @Nullable String queueDeviceName = queueObject.getDeviceName();
            @NonNull String deviceNameToUse = queueDeviceName != null ? queueDeviceName : UNKNOWN_DEVICE;
            @NonNull OpenClDevice deviceObjectToUse = contextObjectToUse.getOrCreateDevice(deviceNameToUse);
            queueObject.setContext(contextObjectToUse);
            queueObject.setDevice(deviceObjectToUse);
            this.emitQueueTracks(queueObject, deviceObjectToUse, emittedContexts, emittedDevices, emittedQueues);
        }
    }

    @Override
    public void deleteClosure(long timestamp, long threadID, long closure) {
        MaliOpenCLCAMGenerator.log("deleteClosure timestamp=" + timestamp + ", threadID=" + threadID + ", closure=" + closure);
        this.timeline.deleteClosure(closure);
    }

    @Override
    public void deleteCommand(long timestamp, long threadID, long command) throws IOException {
        MaliOpenCLCAMGenerator.log("deleteCommand timestamp=" + timestamp + ", threadID=" + threadID + ", command=" + command);
        @Nullable OpenClCommand commandObject = this.timeline.getCommand(command);
        if (commandObject == null) {
            MaliOpenCLCAMGenerator.debug("deleteCommand called with an unknown command");
        } else {
            if (commandObject.seenAccurateTimestamps()) {
                this.flushCommand(timestamp, threadID, commandObject);
            } else {
                commandObject.resetAccurateTimestamps();
                @Nullable DeletedCommand previousCommand = (DeletedCommand)this.deletedCommands.put(commandObject.getId(), (Object)new DeletedCommand(timestamp, threadID, commandObject));
                if (previousCommand != null) {
                    this.flushCommand(previousCommand.timestamp, previousCommand.threadID, previousCommand.commandObject);
                }
            }
            this.timeline.deleteCommand(command);
        }
    }

    @Override
    public void deleteEvent(long timestamp, long threadID, long event) {
        MaliOpenCLCAMGenerator.log("deleteEvent timestamp=" + timestamp + ", threadID=" + threadID + ", event=" + event);
        this.timeline.deleteEvent(event);
    }

    @Override
    public void dependencyCommandToEvent(long timestamp, long threadID, long command, long event) {
        MaliOpenCLCAMGenerator.log("dependencyCommandToEvent timestamp=" + timestamp + ", threadID=" + threadID + ", command=" + command + ", event=" + event);
        if (!this.mGPUCORE1193Fixes) {
            this.dependencyEventToCommandOrOldDependencyCommandToEvent(event, command);
        }
        if (this.mGPUCORE1193Fixes) {
            this.dependencyCommandToEventOrOldRetainEventToCommand(command, event);
        }
    }

    @Override
    public void dependencyEventToCommand(long timestamp, long threadID, long event, long command) {
        MaliOpenCLCAMGenerator.log("dependencyEventToCommand timestamp=" + timestamp + ", threadID=" + threadID + ", event=" + event + ", command=" + command);
        if (this.mGPUCORE1193Fixes) {
            this.dependencyEventToCommandOrOldDependencyCommandToEvent(event, command);
        }
    }

    @Override
    public void dependencyThreadToQueue(long timestamp, long threadID, long queue) throws IOException {
        this.dependencyThreadToQueueOrBlockQueue("dependencyThreadToQueue", timestamp, threadID, queue);
    }

    @Override
    public void newClosure(long timestamp, long threadID, long closure) {
        MaliOpenCLCAMGenerator.log("newClosure timestamp=" + timestamp + ", threadID=" + threadID + ", closure=" + closure);
        this.timeline.createClosure(closure);
    }

    @Override
    public void newCommand(long timestamp, long threadID, long command) {
        MaliOpenCLCAMGenerator.log("newCommand timestamp=" + timestamp + ", threadID=" + threadID + ", command=" + command);
        this.timeline.createCommand(command);
    }

    @Override
    public void newQueue(long timestamp, long threadID, long queue) throws IOException {
        MaliOpenCLCAMGenerator.log("newQueue timestamp=" + timestamp + ", threadID=" + threadID + ", queue=" + queue);
        this.timeline.getOrCreateQueue(queue);
    }

    @Override
    public void nRetainClosureToAtom(long timestamp, long threadID, long closure, long atom) {
        MaliOpenCLCAMGenerator.log("nRetainClosureToAtom timestamp=" + timestamp + ", threadID=" + threadID + ", closure=" + closure + ", atom=" + atom);
        @Nullable OpenClCommand commandObject = this.timeline.getCommandForClosure(closure);
        if (commandObject == null) {
            MaliOpenCLCAMGenerator.debug("Unable to associate retainClosureToAtom to a command");
            return;
        }
        commandObject.setInaccurateStopTime(timestamp);
    }

    @Override
    public void nRetainClosureToLPU(long timestamp, long threadID, long closure, long lpu) {
        MaliOpenCLCAMGenerator.log("nRetainClosureToLPU timestamp=" + timestamp + ", threadID=" + threadID + ", closure=" + closure + ", lpu=" + lpu);
        @Nullable OpenClCommand commandObject = this.timeline.getCommandForClosure(closure);
        if (commandObject == null) {
            MaliOpenCLCAMGenerator.debug("Unable to associate nRetainClosureToLPU to a command");
            return;
        }
        commandObject.setInaccurateStopTime(timestamp);
    }

    @Override
    public void retainClosureToAtom(long timestamp, long threadID, long closure, long atom) {
        MaliOpenCLCAMGenerator.log("retainClosureToAtom timestamp=" + timestamp + ", threadID=" + threadID + ", closure=" + closure + ", atom=" + atom);
        @Nullable OpenClCommand commandObject = this.timeline.getCommandForClosure(closure);
        if (commandObject == null) {
            MaliOpenCLCAMGenerator.debug("Unable to associate retainClosureToAtom to a command");
            return;
        }
        commandObject.setInaccurateStartTime(timestamp);
        commandObject.setType(OpenClCommand.OpenClCommandType.EXEC);
    }

    @Override
    public void retainClosureToCommand(long timestamp, long threadID, long closure, long command) {
        MaliOpenCLCAMGenerator.log("retainClosureToCommand timestamp=" + timestamp + ", threadID=" + threadID + ", closure=" + closure + ", command=" + command);
        if (this.mGPUCORE1193Fixes) {
            this.closureToCommand(closure, command);
        }
    }

    @Override
    public void retainClosureToKernel(long timestamp, long threadID, long closure, long kernel) {
        MaliOpenCLCAMGenerator.log("retainClosureToKernel timestamp=" + timestamp + ", threadID=" + threadID + ", closure=" + closure + ", kernel=" + kernel);
        @NonNull OpenClKernel kernelObject = this.timeline.getOrCreateKernel(kernel);
        @NonNull OpenClClosure closureObject = this.timeline.getOrCreateClosure(closure);
        closureObject.setKernel(timestamp, kernelObject);
        @Nullable OpenClCommand commandObject = closureObject.getCommand();
        if (commandObject == null) {
            MaliOpenCLCAMGenerator.debug("Unable to associate retainClosureToKernel to a command");
            return;
        }
        commandObject.setKernel(timestamp, kernelObject);
        commandObject.setType(OpenClCommand.OpenClCommandType.EXEC);
    }

    @Override
    public void retainClosureToLPU(long timestamp, long threadID, long closure, long lpu) {
        MaliOpenCLCAMGenerator.log("retainClosureToLPU timestamp=" + timestamp + ", threadID=" + threadID + ", closure=" + closure + ", lpu=" + lpu);
        @Nullable OpenClCommand commandObject = this.timeline.getCommandForClosure(closure);
        if (commandObject == null) {
            MaliOpenCLCAMGenerator.debug("Unable to associate retainClosureToLPU to a command");
            return;
        }
        commandObject.setInaccurateStartTime(timestamp);
        commandObject.setType(OpenClCommand.OpenClCommandType.EXEC);
    }

    @Override
    public void retainCommandToClosure(long timestamp, long threadID, long command, long closure) {
        MaliOpenCLCAMGenerator.log("retainCommandToClosure timestamp=" + timestamp + ", threadID=" + threadID + ", command=" + command + ", closure=" + closure);
        if (!this.mGPUCORE1193Fixes) {
            this.closureToCommand(closure, command);
        }
    }

    @Override
    public void retainCommandToQueue(long timestamp, long threadID, long command, long queue) throws IOException {
        MaliOpenCLCAMGenerator.log("retainCommandToQueue timestamp=" + timestamp + ", threadID=" + threadID + ", command=" + command + ", queue=" + queue);
        @Nullable OpenClCommand commandObject = this.timeline.getCommand(command);
        if (commandObject == null) {
            MaliOpenCLCAMGenerator.debug("retainCommandToQueue called even though the associated command/queue was never created");
            return;
        }
        @NonNull OpenClQueue queueObject = this.timeline.getOrCreateQueue(queue);
        commandObject.setType(OpenClCommand.OpenClCommandType.MEM);
        commandObject.setQueue(timestamp, queueObject);
    }

    @Override
    public void retainEventToCommand(long timestamp, long threadID, long event, long command) {
        MaliOpenCLCAMGenerator.log("retainEventToCommand timestamp=" + timestamp + ", threadID=" + threadID + ", event=" + event + ", command=" + command);
        if (!this.mGPUCORE1193Fixes) {
            this.dependencyCommandToEventOrOldRetainEventToCommand(command, event);
        }
    }

    @Override
    public void retainQueueToContext(long timestamp, long threadID, long queue, long ctx) throws IOException {
        MaliOpenCLCAMGenerator.log("retainQueueToContext timestamp=" + timestamp + ", threadID=" + threadID + ", queue=" + queue + ", ctx=" + ctx);
        @NonNull OpenClContext contextObject = this.timeline.getOrCreateContext(ctx);
        @NonNull OpenClQueue queueObject = this.timeline.getOrCreateQueue(queue);
        @Nullable String deviceName = queueObject.getDeviceName();
        if (deviceName == null) {
            return;
        }
        @NonNull OpenClDevice deviceObject = contextObject.getOrCreateDevice(deviceName);
        queueObject.setDevice(deviceObject);
    }

    @Override
    public void setProtocolVersion(@Nullable MipeVersion protocolVersion) {
        int tiebreak = protocolVersion != null ? protocolVersion.major : 0;
        MaliOpenCLCAMGenerator.log("Compatibility tiebreak=" + tiebreak);
        this.mGPUCORE1193Fixes = tiebreak >= 2;
    }

    private void closureToCommand(long closure, long command) {
        @Nullable OpenClCommand commandObject = this.timeline.getCommand(command);
        if (commandObject == null) {
            MaliOpenCLCAMGenerator.debug("closureToCommand called with an unknown command");
            return;
        }
        @NonNull OpenClClosure closureObject = this.timeline.getOrCreateClosure(closure);
        closureObject.setCommand(commandObject);
        @Nullable OpenClKernel kernelObject = closureObject.getKernel();
        if (kernelObject != null) {
            commandObject.setKernel(closureObject.getKernelTimestamp(), kernelObject);
            commandObject.setType(OpenClCommand.OpenClCommandType.EXEC);
        }
    }

    private void dependencyCommandToEventOrOldRetainEventToCommand(long command, long event) {
        @Nullable OpenClCommand commandObject = this.timeline.getCommand(command);
        if (commandObject == null) {
            MaliOpenCLCAMGenerator.debug("dependencyCommandToEventOrOldRetainEventToCommand called with an unknown command");
            return;
        }
        @NonNull OpenClEvent eventObject = this.timeline.getOrCreateEvent(event);
        eventObject.add(commandObject);
    }

    private void dependencyEventToCommandOrOldDependencyCommandToEvent(long event, long command) {
        @Nullable OpenClCommand commandObject = this.timeline.getCommand(command);
        if (commandObject == null) {
            MaliOpenCLCAMGenerator.debug("dependencyEventToCommandOrOldDependencyCommandToEvent called with an unknown command");
            return;
        }
        @Nullable OpenClEvent eventObject = this.timeline.getEvent(event);
        if (eventObject == null) {
            return;
        }
        commandObject.addDependencies(eventObject.getDependantCommands());
    }

    private void dependencyThreadToQueueOrBlockQueue(String name, long timestamp, long threadID, long queue) throws IOException {
        MaliOpenCLCAMGenerator.log(name + " timestamp=" + timestamp + ", threadID=" + threadID + ", queue=" + queue);
        @Nullable ArrayDeque syncCmds = (ArrayDeque)this.mThreadToSyncCmds.remove(threadID);
        if (syncCmds == null) {
            MaliOpenCLCAMGenerator.log("no sync commands associated with queue");
            return;
        }
        if (syncCmds.isEmpty()) {
            return;
        }
        @NonNull OpenClQueue queueObject = this.timeline.getOrCreateQueue(queue);
        int syncTrack = queueObject.getSyncTrackUID();
        this.queuesUsed.add(queueObject);
        for (SyncCmd syncCmd : syncCmds) {
            AnnotationColour color = this.mNameToColorMap.get(syncCmd.mApiName);
            if (color == null) {
                color = AnnotationColour.mapCyclicColour((int)this.mCyclicSyncColor++);
                this.mNameToColorMap.put(syncCmd.mApiName, color);
            }
            this.outputStream.camJob(19901127, ClockSource.MONOTONIC_RAW, syncCmd.mTimestamp, 0L, syncTrack, this.mJobUID++, syncCmd.mApiName, color, -1, NO_DEPENDENCIES);
        }
    }

    private void emitQueueTracks(@NonNull OpenClQueue queueObject, @NonNull OpenClDevice deviceObject, @NonNull Set<@NonNull OpenClContext> emittedContexts, @NonNull Set<@NonNull OpenClDevice> emittedDevices, @NonNull Set<@NonNull OpenClQueue> emittedQueues) throws IOException {
        Object name;
        @NonNull OpenClContext contextObject = deviceObject.getContext();
        int contextTrackUID = contextObject.getTrackUID();
        if (emittedContexts.add(contextObject)) {
            long context = contextObject.getId();
            name = context != 0L ? OPENCL_CONTEXT_PREFIX + NumberUtils.formatAddress((long)context) : UNKNOWN_CONTEXT;
            this.outputStream.camTrack(19901127, -1, contextTrackUID, (String)name);
        }
        int deviceTrackUID = deviceObject.getTrackUID();
        if (emittedDevices.add(deviceObject)) {
            this.outputStream.camTrack(19901127, contextTrackUID, deviceTrackUID, deviceObject.getName());
        }
        if (emittedQueues.add(queueObject)) {
            int queueTrackUID = queueObject.getTrackUID();
            name = QUEUE_NAME_PREFIX + deviceObject.getQueueNumber(queueObject);
            this.outputStream.camTrack(19901127, deviceTrackUID, queueTrackUID, (String)name);
            if (this.queuesWithChainTrack.contains(queueObject)) {
                this.outputStream.camTrack(19901127, queueTrackUID, queueObject.getChainTrackUID(), JOB_CHAIN_TRACK_NAME);
            }
            this.outputStream.camTrack(19901127, queueTrackUID, queueObject.getExecTrackUID(), EXECUTION_TRACK_NAME);
            this.outputStream.camTrack(19901127, queueTrackUID, queueObject.getSyncTrackUID(), SYNC_TRACK_NAME);
            this.outputStream.camTrack(19901127, queueTrackUID, queueObject.getMemoryTrackUID(), MEMORY_TRACK_NAME);
        }
    }

    private void flushCommand(long timestamp, long threadID, @NonNull OpenClCommand commandObject) throws NullPointerException, IOException {
        @NonNull ArrayList<@NonNull OpenClCommand.OpenClCommandChainJob> validJobs = new ArrayList<OpenClCommand.OpenClCommandChainJob>();
        for (OpenClCommand.OpenClCommandChainJob jobObject : commandObject.getJobChain()) {
            if (this.validateJob(timestamp, commandObject, jobObject)) {
                validJobs.add(jobObject);
                continue;
            }
            this.mDroppedJobs.add(jobObject.getJobUID());
        }
        int jobChainJobUID = commandObject.getJobChainJobUID();
        if (validJobs.isEmpty()) {
            this.mDroppedJobs.add(jobChainJobUID);
        } else {
            Collections.sort(validJobs, (a, b) -> {
                int result = UnsignedLong.compare((long)a.getStartTimestamp(), (long)b.getStartTimestamp());
                if (result != 0) {
                    return result;
                }
                result = UnsignedLong.compare((long)a.getStopTimestamp(), (long)b.getStopTimestamp());
                if (result != 0) {
                    return result;
                }
                return Integer.compare(a.getJobUID(), b.getJobUID());
            });
            boolean createJobChainJob = validJobs.size() > 1;
            int @NonNull [] commandDependencies = this.pruneDependencies(commandObject.getDependencies());
            @NonNull OpenClCommand.OpenClCommandType commandType = (OpenClCommand.OpenClCommandType)((Object)NullChecking.neverNull((Object)((Object)commandObject.getType())));
            @NonNull OpenClQueue queue = (OpenClQueue)NullChecking.neverNull((Object)commandObject.getQueue());
            int threadTrackUID = this.getThreadTrackUID(threadID);
            long queueTime = commandObject.getQueueTimestamp();
            int leafTrack = MaliOpenCLCAMGenerator.mapCommandTypeToLeafTrack(queue, commandType);
            if (createJobChainJob) {
                long chainStartTime = MaliOpenCLCAMGenerator.findStartTime(validJobs);
                long chainStopTime = MaliOpenCLCAMGenerator.findStopTime(validJobs);
                long chainDuration = chainStopTime - chainStartTime;
                int chainTrack = queue.getChainTrackUID();
                @NonNull String name = String.format("%d jobs", validJobs.size());
                @NonNull AnnotationColour color = AnnotationColour.mapCyclicColour((int)this.mCyclicChainColor++);
                int @NonNull [] dependencies = validJobs.stream().mapToInt(OpenClCommand.OpenClCommandChainJob::getJobUID).toArray();
                this.outputStream.camJob(19901127, ClockSource.MONOTONIC_RAW, chainStartTime, chainDuration, chainTrack, jobChainJobUID, name, color, -1, dependencies);
                this.queuesUsed.add(queue);
                this.queuesWithChainTrack.add(queue);
            }
            int @NonNull [] jobDependencies = commandDependencies;
            for (OpenClCommand.OpenClCommandChainJob jobObject : validJobs) {
                int threadJobID;
                int rawUID = jobObject.getJobUID();
                int jobUID = createJobChainJob ? rawUID : jobChainJobUID;
                long startTimestamp = jobObject.getStartTimestamp();
                long stopTimestamp = jobObject.getStopTimestamp();
                long duration = stopTimestamp - startTimestamp;
                @NonNull String name = (String)NullChecking.neverNull((Object)jobObject.getName());
                ++this.mJobUID;
                @NonNull AnnotationColour color = this.mapNameToColour(name, commandType);
                @Nullable Long kernelTimestamp = jobObject.getKernelTimestamp();
                long threadTimestamp = kernelTimestamp != null ? kernelTimestamp : queueTime;
                this.outputStream.camJob(19901127, ClockSource.MONOTONIC_RAW, threadTimestamp, 0L, threadTrackUID, threadJobID, name, color, -1, NO_DEPENDENCIES);
                this.outputStream.camJob(19901127, ClockSource.MONOTONIC_RAW, startTimestamp, duration, leafTrack, jobUID, name, color, threadJobID, jobDependencies);
                this.queuesUsed.add(queue);
                jobDependencies = new int[]{jobUID};
            }
        }
    }

    private int getThreadTrackUID(long threadID) throws IOException {
        int trackUID = this.mThreadtoThreadUIDMap.get(threadID);
        if (trackUID == 0) {
            trackUID = this.mTrackUID++;
            this.mThreadtoThreadUIDMap.put(threadID, trackUID);
            this.outputStream.camTrack(19901127, this.mHostTrack, trackUID, THREAD_NAME_PREFIX + threadID);
        }
        return trackUID;
    }

    private @NonNull AnnotationColour mapNameToColour(@NonNull String name, @NonNull OpenClCommand.OpenClCommandType commandType) {
        AnnotationColour color = this.mNameToColorMap.get(name);
        if (color == null) {
            switch (commandType) {
                case EXEC: {
                    color = AnnotationColour.mapCyclicColour((int)this.mCyclicExecColor++);
                    break;
                }
                case MEM: {
                    color = AnnotationColour.mapCyclicColour((int)this.mCyclicMemColor++);
                    break;
                }
                default: {
                    throw new AssertionError((Object)commandType);
                }
            }
            this.mNameToColorMap.put(name, color);
        }
        return color;
    }

    private int @NonNull [] pruneDependencies(@NonNull Set<@NonNull OpenClCommand> commands) throws IOException {
        TIntHashSet set = new TIntHashSet();
        for (OpenClCommand command : commands) {
            int dependency;
            @Nullable DeletedCommand deletedCommand = (DeletedCommand)this.deletedCommands.get(command.getId());
            if (deletedCommand != null && deletedCommand.commandObject == command) {
                MaliOpenCLCAMGenerator.log("Flushing deleted dependency for command " + String.valueOf(command) + " -> " + String.valueOf(deletedCommand.commandObject));
                this.deletedCommands.remove(command.getId());
                this.flushCommand(deletedCommand.timestamp, deletedCommand.threadID, deletedCommand.commandObject);
            }
            if (this.mDroppedJobs.contains(dependency = command.getJobChainJobUID())) continue;
            set.add(dependency);
        }
        int @NonNull [] result = set.toArray();
        return result;
    }

    private boolean validateJob(long timestamp, @NonNull OpenClCommand commandObject, @NonNull OpenClCommand.OpenClCommandChainJob jobObject) throws IOException {
        long startTimestamp = jobObject.getStartTimestamp();
        long stopTimestamp = jobObject.getStopTimestamp();
        long queueTimestamp = commandObject.getQueueTimestamp();
        @Nullable OpenClCommand.OpenClCommandType commandType = commandObject.getType();
        @Nullable String name = jobObject.getName();
        @Nullable OpenClQueue queue = commandObject.getQueue();
        if (startTimestamp == 0L) {
            return false;
        }
        if (stopTimestamp < startTimestamp) {
            jobObject.fixStopTime(UnsignedLong.max((long)timestamp, (long)startTimestamp));
            MaliOpenCLCAMGenerator.debug("stopTime <= startTime for command " + String.valueOf(jobObject));
        }
        if (startTimestamp < queueTimestamp) {
            MaliOpenCLCAMGenerator.debug("startTime < queueTime for command " + String.valueOf(jobObject));
            return false;
        }
        if (commandType != OpenClCommand.OpenClCommandType.EXEC && commandType != OpenClCommand.OpenClCommandType.MEM) {
            MaliOpenCLCAMGenerator.debug("trackOffset is neither set to execution nor memory");
            return false;
        }
        if (queue == null) {
            MaliOpenCLCAMGenerator.debug("queue is null for command");
            return false;
        }
        if (name == null || name.isEmpty()) {
            MaliOpenCLCAMGenerator.debug("attributeCommandAPIName never called for command: " + String.valueOf(commandObject));
            jobObject.setName(UNKNOWN);
        }
        if (!this.mTimestampWarning && commandType == OpenClCommand.OpenClCommandType.EXEC && !jobObject.areTimestampsAreAccurate()) {
            this.outputStream.warning(WarningsFactory.inaccurateOpenCLTimestamps());
            this.mTimestampWarning = true;
        }
        return true;
    }

    private static final class DeletedCommand {
        public final @NonNull OpenClCommand commandObject;
        public final long threadID;
        public final long timestamp;

        public DeletedCommand(long timestamp, long threadID, @NonNull OpenClCommand commandObject) {
            this.timestamp = timestamp;
            this.threadID = threadID;
            this.commandObject = commandObject;
        }
    }
}

