/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.protocol.external;

import com.arm.streamline.analysis.model.ICounterSeriesKey;
import com.arm.streamline.analysis.model.StaticCounterSeriesKey;
import com.arm.streamline.common.analysis.model.AnnotationColour;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.protocol.capture.apc.pass_two.warnings.WarningsFactory;
import com.arm.streamline.protocol.capture.apc.protocol.external.AtraceParser;
import com.arm.streamline.protocol.capture.apc.protocol.external.ExternalProtocolChannel;
import com.arm.streamline.protocol.capture.apc.protocol.external.FTraceCommon;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolDecoder;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolEventStream;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolPassTwoState;
import com.arm.streamline.protocol.capture.apc.time.ClockSource;
import com.arm.streamline.protocol.misc.TaskId;
import com.arm.utils.NullChecking;
import com.arm.utils.collections.IntPair;
import com.arm.utils.numbers.UnsignedLong;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class EStateFtraceV1
implements IExternalProtocolDecoder {
    public static final String PROTOCOL = "FTRACE 1";
    private static final Pattern PATTERN_CPU_ID = Pattern.compile("\\bcpu_id=(\\d+)\\b");
    private static final Pattern PATTERN_STATE = Pattern.compile("\\bstate=(\\d+)\\b");
    private static final Pattern PATTERN_FTRACE_LINE = Pattern.compile("^.*-([0-9]+) +\\[(\\d+)\\] [^:]* ([0-9]+\\.[0-9]+): ([^:]+): (.*)$");
    private static final String TRACING_MARK_WRITE = "tracing_mark_write";
    private final @NonNull AtraceParser atraceParser;
    private final @NonNull ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private final @NonNull FTraceCommon commonProcessing;
    private final @NonNull List<@NonNull FtraceCounter> ftraceCounters = new ArrayList<FtraceCounter>();
    private @NonNull ClockSource lastSeenClockSource = ClockSource.BEFORE_START;
    private long lastSeenTimestamp = 0L;
    private final @NonNull IExternalProtocolEventStream outputStream;
    private final @NonNull IExternalProtocolPassTwoState passTwoState;
    private final boolean enableAtrace;

    private static @Nullable IntPair extractCpuAndState(@NonNull String args) {
        Matcher cpuIdMatcher = PATTERN_CPU_ID.matcher(args);
        Matcher stateMatcher = PATTERN_STATE.matcher(args);
        if (!cpuIdMatcher.find() || !stateMatcher.find()) {
            return null;
        }
        int cpuId = Integer.parseInt(cpuIdMatcher.group(1));
        int state = (int)Long.parseLong(stateMatcher.group(1));
        return new IntPair(cpuId, state);
    }

    private static int findNewline(byte[] buf, int begin, int end) {
        int pos = begin;
        while (pos < end) {
            if (buf[pos] == 10) {
                return pos;
            }
            ++pos;
        }
        return -1;
    }

    public EStateFtraceV1(@NonNull ExternalProtocolChannel channel, @NonNull IExternalProtocolPassTwoState passTwoState, @NonNull IExternalProtocolEventStream outputStream, boolean enableAtrace) {
        this.passTwoState = passTwoState;
        this.outputStream = outputStream;
        this.enableAtrace = enableAtrace;
        this.atraceParser = new AtraceParser(channel, passTwoState, outputStream);
        for (StaticCounterSeriesKey counterSeriesKey : passTwoState.getStaticCounterSeries().getAllStaticCounterSeries()) {
            @NonNull CounterRecord counterRecord = counterSeriesKey.getCounterRecord();
            if (!counterRecord.getCounter().startsWith("ftrace_")) continue;
            this.ftraceCounters.add(new FtraceCounter(counterSeriesKey));
        }
        this.commonProcessing = new FTraceCommon(passTwoState, outputStream);
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void process(byte @NonNull [] data) throws IOException {
        int pos = 0;
        while (pos < data.length) {
            int nextPos = EStateFtraceV1.findNewline(data, pos, data.length);
            if (nextPos < 0) {
                this.baos.write(data, pos, data.length - pos);
                break;
            }
            int baosSize = this.baos.size();
            if (baosSize == 0) {
                this.parse(new String(data, pos, nextPos - pos, StandardCharsets.UTF_8));
            } else {
                byte[] merged = new byte[baosSize + nextPos - pos];
                System.arraycopy(this.baos.toByteArray(), 0, merged, 0, baosSize);
                System.arraycopy(data, pos, merged, baosSize, nextPos - pos);
                this.parse(new String(merged, StandardCharsets.UTF_8));
                this.baos.reset();
            }
            pos = nextPos + 1;
        }
    }

    @Override
    public boolean reorderable() {
        return false;
    }

    private void parse(@NonNull String line) throws IOException {
        Matcher matcher;
        if (line.startsWith("CPU:")) {
            this.outputStream.annotationMarker(this.lastSeenClockSource, this.lastSeenTimestamp, new TaskId(0), AnnotationColour.WARNING_COLOUR, line);
            this.outputStream.warning(WarningsFactory.ftraceDataLost());
        }
        if ((matcher = PATTERN_FTRACE_LINE.matcher(line)).find()) {
            int tid = Integer.parseInt(matcher.group(1));
            int cpu = Integer.parseInt(matcher.group(2), 10);
            String timeStr = matcher.group(3);
            long time = (long)(Double.parseDouble(timeStr) * 1.0E9);
            this.lastSeenClockSource = ClockSource.MONOTONIC_RAW;
            this.lastSeenTimestamp = UnsignedLong.max((long)time, (long)this.lastSeenTimestamp);
            if (time != -1L) {
                @NonNull String name = (String)NullChecking.neverNull((Object)matcher.group(4));
                @NonNull String args = (String)NullChecking.neverNull((Object)matcher.group(5));
                @NonNull String row = String.format("%s: %s", name, args);
                @NonNull TaskId taskId = new TaskId(tid);
                for (FtraceCounter ftraceCounter : this.ftraceCounters) {
                    Matcher counterMatcher;
                    String tracepoint = ftraceCounter.tracepoint;
                    Pattern pattern = ftraceCounter.pattern;
                    if (tracepoint != null && tracepoint.contentEquals("power/cpu_frequency") && name.contentEquals("cpu_frequency")) {
                        IntPair cpuAndState = EStateFtraceV1.extractCpuAndState(args);
                        if (cpuAndState == null) continue;
                        int cpuId = cpuAndState.first;
                        int state = cpuAndState.second;
                        this.commonProcessing.onCpuFrequency((ICounterSeriesKey)ftraceCounter.counterSeriesKey, time, cpuId, state);
                        continue;
                    }
                    if (pattern == null || !(counterMatcher = pattern.matcher(row)).find()) continue;
                    long value = counterMatcher.groupCount() == 0 ? 1L : Long.parseLong(counterMatcher.group(1));
                    this.outputStream.counter((ICounterSeriesKey)ftraceCounter.counterSeriesKey, ClockSource.MONOTONIC_RAW, time, this.passTwoState.mapPeReference(ftraceCounter.counterSeriesKey.getDeviceTypeOrDefault(), cpu), taskId, value);
                }
                if (name.equals(TRACING_MARK_WRITE) && this.enableAtrace) {
                    this.atraceParser.parseAtrace(ClockSource.MONOTONIC_RAW, time, taskId, args);
                }
            }
        }
    }

    private static class FtraceCounter {
        public final @NonNull StaticCounterSeriesKey counterSeriesKey;
        public final @Nullable Pattern pattern;
        public final @Nullable String tracepoint;

        public FtraceCounter(@NonNull StaticCounterSeriesKey counterSeriesKey) {
            this.counterSeriesKey = counterSeriesKey;
            CounterRecord cr = counterSeriesKey.getCounterRecord();
            this.tracepoint = cr.getTracepoint();
            String rx = cr.getRegex();
            this.pattern = rx != null ? Pattern.compile(rx) : null;
        }
    }
}

