/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.pass_two;

import com.arm.streamline.analysis.database.api.profiling.IBacktraceSource;
import com.arm.streamline.analysis.model.DynamicCounterSeriesKey;
import com.arm.streamline.analysis.model.ICounterSeriesKey;
import com.arm.streamline.analysis.model.KernelAnnotationSeriesKey;
import com.arm.streamline.analysis.model.threads.IExecutablePath;
import com.arm.streamline.analysis.model.threads.IUniqueThread;
import com.arm.streamline.common.analysis.model.AnnotationColour;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.xml.spe.SpeOperationTypeClass;
import com.arm.streamline.ftrace.TracepointFormat;
import com.arm.streamline.jni.common.WarningItem;
import com.arm.streamline.protocol.capture.apc.pass_two.IGatorPassTwoForAnalysisEventStream;
import com.arm.utils.ArrayUtils;
import com.arm.utils.StreamUtils;
import gnu.trove.TShortCollection;
import gnu.trove.map.TByteShortMap;
import gnu.trove.set.TShortSet;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class GatorPassTwoForAnalysisEventStreamLogger
implements IGatorPassTwoForAnalysisEventStream {
    private long eventCounter;
    private final @NonNull IGatorPassTwoForAnalysisEventStream forwardTo;
    private long lastTimestamp = -1L;
    private final @NonNull PrintStream output;
    private final long vmUID;

    private static <T> @NonNull String arrayToString(T[] array) {
        return array != null ? Arrays.toString(array) : "null";
    }

    public GatorPassTwoForAnalysisEventStreamLogger(long vmUID, @NonNull PrintStream output, @NonNull IGatorPassTwoForAnalysisEventStream forwardTo) {
        this.vmUID = vmUID;
        this.output = output;
        this.forwardTo = forwardTo;
        output.printf("VM\tEVENT\tARGS%n", new Object[0]);
    }

    @Override
    public void absoluteBacktrace(long timestamp, IBacktraceSource backtraceSource, @NonNull ProcessingElementReference peReference, @NonNull IUniqueThread uniqueThread, long @NonNull [] addresses) throws IOException {
        this.checkTimestamp(timestamp);
        this.log("absoluteBacktrace", "%s, %s, %s, %s, %s", timestamp, backtraceSource, peReference, uniqueThread, ArrayUtils.toString((long[])addresses, a -> String.format("0x%016x", a)));
        this.forwardTo.absoluteBacktrace(timestamp, backtraceSource, peReference, uniqueThread, addresses);
    }

    @Override
    public void activityStop(@NonNull ICounterSeriesKey counterKey, long timestamp, @NonNull ProcessingElementReference peReference, @Nullable IUniqueThread uniqueThread, int activity) throws IOException {
        this.checkTimestamp(timestamp);
        this.log("activityStop", "%s, %s, %s, %s, %s", timestamp, counterKey, peReference, uniqueThread, activity);
        this.forwardTo.activityStop(counterKey, timestamp, peReference, uniqueThread, activity);
    }

    @Override
    public void activitySwitch(@NonNull ICounterSeriesKey counterKey, long timestamp, @NonNull ProcessingElementReference peReference, @Nullable IUniqueThread uniqueThread, int activity, int reason) throws IOException {
        this.checkTimestamp(timestamp);
        this.log("activityStop", "%s, %s, %s, %s, %s", timestamp, counterKey, peReference, uniqueThread, activity);
        this.forwardTo.activitySwitch(counterKey, timestamp, peReference, uniqueThread, activity, reason);
    }

    @Override
    public void annotationMarker(long timestamp, @NonNull IUniqueThread uniqueThread, @NonNull AnnotationColour colour, @NonNull String text) throws IOException {
        this.checkTimestamp(timestamp);
        this.log("annotationMarker", "%s, %s, %s, %s", timestamp, uniqueThread, colour, text);
        this.forwardTo.annotationMarker(timestamp, uniqueThread, colour, text);
    }

    @Override
    public void annotationText(long timestamp, @NonNull IUniqueThread uniqueThread, int channel, @NonNull AnnotationColour colour, @NonNull String text) throws IOException {
        this.checkTimestamp(timestamp);
        this.log("annotationText", "%s, %s, %s, %s, %s", timestamp, uniqueThread, channel, colour, text);
        this.forwardTo.annotationText(timestamp, uniqueThread, channel, colour, text);
    }

    @Override
    public void annotationTextAsync(long timestamp, @NonNull IUniqueThread uniqueThread, @NonNull String title, int id, @NonNull AnnotationColour colour, @NonNull String text) throws IOException {
        this.checkTimestamp(timestamp);
        this.log("annotationTextAsync", "%s, %s, %s, %s, %s, %s", timestamp, uniqueThread, title, id, colour, text);
        this.forwardTo.annotationTextAsync(timestamp, uniqueThread, title, id, colour, text);
    }

    @Override
    public void annotationTextAsyncEnd(long timestamp, @NonNull IUniqueThread uniqueThread, @NonNull String title, int id) throws IOException {
        this.checkTimestamp(timestamp);
        this.log("annotationTextAsyncEnd", "%s, %s, %s, %s", timestamp, uniqueThread, title, id);
        this.forwardTo.annotationTextAsyncEnd(timestamp, uniqueThread, title, id);
    }

    @Override
    public void annotationTextNameChannel(long timestamp, @NonNull IUniqueThread uniqueThread, int channel, int group, @NonNull String text) throws IOException {
        this.checkTimestamp(timestamp);
        this.log("annotationTextNameChannel", "%s, %s, %s, %s, %s", timestamp, uniqueThread, channel, group, text);
        this.forwardTo.annotationTextNameChannel(timestamp, uniqueThread, channel, group, text);
    }

    @Override
    public void annotationTextNameGroup(long timestamp, @NonNull IUniqueThread uniqueThread, int group, @NonNull String text) throws IOException {
        this.checkTimestamp(timestamp);
        this.log("annotationTextNameGroup", "%s, %s, %s, %s", timestamp, uniqueThread, group, text);
        this.forwardTo.annotationTextNameGroup(timestamp, uniqueThread, group, text);
    }

    @Override
    public void annotationTextPop(long timestamp, @NonNull IUniqueThread uniqueThread, @NonNull String title) throws IOException {
        this.checkTimestamp(timestamp);
        this.log("annotationTextPop", "%s, %s, %s", timestamp, uniqueThread, title);
        this.forwardTo.annotationTextPop(timestamp, uniqueThread, title);
    }

    @Override
    public void annotationTextPush(long timestamp, @NonNull IUniqueThread uniqueThread, @NonNull String title, @NonNull AnnotationColour colour, @NonNull String text) throws IOException {
        this.checkTimestamp(timestamp);
        this.log("annotationTextPush", "%s, %s, %s, %s, %s", timestamp, uniqueThread, title, colour, text);
        this.forwardTo.annotationTextPush(timestamp, uniqueThread, title, colour, text);
    }

    @Override
    public void annotationVisual(long timestamp, @NonNull IUniqueThread uniqueThread, @NonNull String text, byte @NonNull [] image) throws IOException {
        this.checkTimestamp(timestamp);
        this.log("annotationVisual", "%s, %s, %s, %s", timestamp, uniqueThread, text, ArrayUtils.toString((byte[])image, b -> String.format("0x%02x", b)));
        this.forwardTo.annotationVisual(timestamp, uniqueThread, text, image);
    }

    @Override
    public void atraceCounter(long timestamp, @NonNull String name, @NonNull IUniqueThread uniqueThread, long value) throws IOException {
        this.checkTimestamp(timestamp);
        this.log("atraceCounter", "%s, %s, %s, %s", timestamp, name, uniqueThread, value);
        this.forwardTo.atraceCounter(timestamp, name, uniqueThread, value);
    }

    @Override
    public void camJob(int viewUID, long startTime, long duration, int track, int jobUID, @NonNull String name, @NonNull AnnotationColour colour, int primaryDependency, int @NonNull [] dependencies) throws IOException {
        this.checkTimestamp(startTime);
        this.log("camJob", "%s, %s, %s, %s, %s, %s, %s, %s, %s", viewUID, startTime, duration, track, jobUID, name, colour, primaryDependency, ArrayUtils.toString((int[])dependencies, Integer::toString));
        this.forwardTo.camJob(viewUID, startTime, duration, track, jobUID, name, colour, primaryDependency, dependencies);
    }

    @Override
    public void camJob(@NonNull IUniqueThread uniqueThread, int viewUID, long startTime, long duration, int track, int jobUID, @NonNull String name, @NonNull AnnotationColour colour, int primaryDependency, int @NonNull [] dependencies) throws IOException {
        this.checkTimestamp(startTime);
        this.log("camJob", "%s, %s, %s, %s, %s, %s, %s, %s, %s, %s", uniqueThread, viewUID, startTime, duration, track, jobUID, name, colour, primaryDependency, ArrayUtils.toString((int[])dependencies, Integer::toString));
        this.forwardTo.camJob(uniqueThread, viewUID, startTime, duration, track, jobUID, name, colour, primaryDependency, dependencies);
    }

    @Override
    public void camJob(@NonNull IUniqueThread uniqueThread, int viewUID, long startTime, long duration, int track, int jobUID, @NonNull String name, @NonNull AnnotationColour colour, int primaryDependency, int @NonNull [] dependencies, @NonNull String detailText) throws IOException {
        this.checkTimestamp(startTime);
        this.log("camJob", "%s, %s, %s, %s, %s, %s, %s, %s, %s, %s %s", uniqueThread, viewUID, startTime, duration, track, jobUID, name, colour, primaryDependency, ArrayUtils.toString((int[])dependencies, Integer::toString), detailText);
        this.forwardTo.camJob(uniqueThread, viewUID, startTime, duration, track, jobUID, name, colour, primaryDependency, dependencies, detailText);
    }

    @Override
    public void camJobDependencies(@NonNull IUniqueThread uniqueThread, int viewUID, long timestamp, int jobUID, int primaryDependency, int @NonNull [] dependencies) throws IOException {
        this.checkTimestamp(timestamp);
        this.log("camJobDependencies", "%s, %s, %s, %s, %s, %s", uniqueThread, viewUID, timestamp, jobUID, primaryDependency, ArrayUtils.toString((int[])dependencies, Integer::toString));
        this.forwardTo.camJobDependencies(uniqueThread, viewUID, timestamp, jobUID, primaryDependency, dependencies);
    }

    @Override
    public void camJobStart(@NonNull IUniqueThread uniqueThread, int viewUID, long timestamp, int track, int jobUID, @NonNull String name, @NonNull AnnotationColour colour) throws IOException {
        this.checkTimestamp(timestamp);
        this.log("camJobStart", "%s, %s, %s, %s, %s, %s, %s", uniqueThread, viewUID, timestamp, track, jobUID, name, colour);
        this.forwardTo.camJobStart(uniqueThread, viewUID, timestamp, track, jobUID, name, colour);
    }

    @Override
    public void camJobStart(@NonNull IUniqueThread uniqueThread, int viewUID, long timestamp, int track, int jobUID, @NonNull String name, @NonNull AnnotationColour colour, @NonNull String detailText) throws IOException {
        this.checkTimestamp(timestamp);
        this.log("camJobStart", "%s, %s, %s, %s, %s, %s, %s, %s", uniqueThread, viewUID, timestamp, track, jobUID, name, colour, detailText);
        this.forwardTo.camJobStart(uniqueThread, viewUID, timestamp, track, jobUID, name, colour, detailText);
    }

    @Override
    public void camJobStop(@NonNull IUniqueThread uniqueThread, int viewUID, long timestamp, int jobUID) throws IOException {
        this.checkTimestamp(timestamp);
        this.log("camJobStop", "%s, %s, %s, %s", uniqueThread, viewUID, timestamp, jobUID);
        this.forwardTo.camJobStop(uniqueThread, viewUID, timestamp, jobUID);
    }

    @Override
    public void camTrack(int viewUID, int parentTrack, int trackUID, @NonNull String name) throws IOException {
        this.log("camTrack", "%s, %s, %s, %s", viewUID, parentTrack, trackUID, name);
        this.forwardTo.camTrack(viewUID, parentTrack, trackUID, name);
    }

    @Override
    public void camTrack(@NonNull IUniqueThread uniqueThread, int viewUID, long timestamp, int parentTrack, int trackUID, @NonNull String name) throws IOException {
        this.checkTimestamp(timestamp);
        this.log("camTrack", "%s, %s, %s, %s, %s, %s", uniqueThread, viewUID, timestamp, parentTrack, trackUID, name);
        this.forwardTo.camTrack(uniqueThread, viewUID, timestamp, parentTrack, trackUID, name);
    }

    @Override
    public void camView(int viewUID, @NonNull String name) throws IOException {
        this.log("camView", "%s, %s", viewUID, name);
        this.forwardTo.camView(viewUID, name);
    }

    @Override
    public void camView(@NonNull IUniqueThread uniqueThread, int viewUID, long timestamp, @NonNull String name) throws IOException {
        this.checkTimestamp(timestamp);
        this.log("camView", "%s, %s, %s, %s", uniqueThread, viewUID, timestamp, name);
        this.forwardTo.camView(uniqueThread, viewUID, timestamp, name);
    }

    @Override
    public void close() throws IOException {
        this.output.close();
    }

    @Override
    public void counter(@NonNull ICounterSeriesKey counterKey, long timestamp, @NonNull ProcessingElementReference peReference, @Nullable IUniqueThread uniqueThread, long value) throws IOException {
        this.checkTimestamp(timestamp);
        this.log("counter", "%s, %s, %s, %s, %s", timestamp, counterKey, peReference, uniqueThread, value);
        this.forwardTo.counter(counterKey, timestamp, peReference, uniqueThread, value);
    }

    @Override
    public void createDynamicCounterSeries(@NonNull DynamicCounterSeriesKey counterKey, @NonNull CounterRecord counterRecord) {
        this.log("createDynamicCounterSeries", "%s, %s", counterKey, counterRecord);
        this.forwardTo.createDynamicCounterSeries(counterKey, counterRecord);
    }

    @Override
    public void createKernelAnnotationsCounterSeries(@NonNull KernelAnnotationSeriesKey counterKey, @NonNull CounterRecord counterRecord) {
        this.log("createKernelAnnotationsCounterSeries", "%s, %s", counterKey, counterRecord);
        this.forwardTo.createKernelAnnotationsCounterSeries(counterKey, counterRecord);
    }

    @Override
    public void gatorBacktrace(long timestamp, IBacktraceSource backtraceSource, @NonNull ProcessingElementReference peReference, @NonNull IUniqueThread uniqueThread, @Nullable IExecutablePath appExecutablePath, @Nullable IExecutablePath @NonNull [] offsetExecutablePaths, long @NonNull [] offsets) throws IOException {
        this.checkTimestamp(timestamp);
        this.log("gatorBacktrace", "%s, %s, %s, %s, %s, %s, %s", timestamp, backtraceSource, peReference, uniqueThread, appExecutablePath, GatorPassTwoForAnalysisEventStreamLogger.arrayToString(offsetExecutablePaths), ArrayUtils.toString((long[])offsets, o -> String.format("0x%08x", o)));
        this.forwardTo.gatorBacktrace(timestamp, backtraceSource, peReference, uniqueThread, appExecutablePath, offsetExecutablePaths, offsets);
    }

    public long getEventCounter() {
        return this.eventCounter;
    }

    @Override
    public void idle(long timestamp, @NonNull ProcessingElementReference peReference, boolean online) throws IOException {
        this.checkTimestamp(timestamp);
        this.log("idle", "%s, %s, %s", timestamp, peReference, online);
        this.forwardTo.idle(timestamp, peReference, online);
    }

    @Override
    public void schedSwitch(long timestamp, @NonNull ProcessingElementReference peReference, @NonNull IUniqueThread uniqueThread,  @NonNull IGatorPerVirtualMachineProtocolEventConsumer.SchedulerSwitchReason reason) throws IOException {
        this.checkTimestamp(timestamp);
        this.log("schedSwitch", "%s, %s, %s, %s", new Object[]{timestamp, peReference, uniqueThread, reason});
        this.forwardTo.schedSwitch(timestamp, peReference, uniqueThread, reason);
    }

    @Override
    public void threadExit(long timestamp, @NonNull IUniqueThread uniqueThread) throws IOException {
        this.checkTimestamp(timestamp);
        this.log("threadExit", "%s, %s", timestamp, uniqueThread);
        this.forwardTo.threadExit(timestamp, uniqueThread);
    }

    @Override
    public void tracepointEvent(long timestamp, @Nullable IUniqueThread uniqueThread, @NonNull TracepointFormat tracepointFormat, byte @NonNull [] raw) throws IOException {
        this.checkTimestamp(timestamp);
        this.log("tracepointEvent", "%s, %s, %s, %s", timestamp, uniqueThread, tracepointFormat, ArrayUtils.toString((byte[])raw, b -> String.format("0x%02x", b)));
        this.forwardTo.tracepointEvent(timestamp, uniqueThread, tracepointFormat, raw);
    }

    @Override
    public void warning(long timestamp, @NonNull IUniqueThread uniqueThread, @NonNull WarningItem warning) throws IOException {
        this.checkTimestamp(timestamp);
        this.log("warning", "%s, %s", timestamp, warning);
        this.forwardTo.warning(timestamp, uniqueThread, warning);
    }

    @Override
    public void warning(@NonNull WarningItem warning) throws IOException {
        this.log("warning", "%s", warning);
        this.forwardTo.warning(warning);
    }

    private void checkTimestamp(long timestamp) {
        assert (this.lastTimestamp <= timestamp) : this.lastTimestamp + " vs " + timestamp;
        this.lastTimestamp = timestamp;
        ++this.eventCounter;
    }

    private void log(String name, String format, Object ... objects) {
        this.output.printf("%d\t%s\t(%s)%n", this.vmUID, name, String.format(format, objects));
    }

    @Override
    public void speSample(int key, long timestamp, @NonNull ProcessingElementReference peReference, @NonNull IUniqueThread uniqueThread, long pc, @Nullable SpeOperationTypeClass opTypeClass, byte opTypeSubclass, long events, @NonNull TShortSet dataSource, @NonNull TByteShortMap counterMap) throws IOException {
        this.log("speSample", "%s, %s, %s, %s, %s", key, timestamp, peReference, uniqueThread, GatorPassTwoForAnalysisEventStreamLogger.speSampleLogText(pc, opTypeClass, opTypeSubclass, events, dataSource, counterMap));
        this.forwardTo.speSample(key, timestamp, peReference, uniqueThread, pc, opTypeClass, opTypeSubclass, events, dataSource, counterMap);
    }

    public static @NonNull String speSampleLogText(long pc, @Nullable SpeOperationTypeClass opTypeClass, byte opTypeSubclass, long events, @NonNull TShortSet dataSource, @NonNull TByteShortMap counterMap) {
        String oprType = opTypeClass != null ? ", operation type: " + opTypeClass.name() + ":0b" + Integer.toBinaryString(Byte.toUnsignedInt(opTypeSubclass)) : "";
        String eventsString = ", events: 0b" + Long.toBinaryString(events);
        String dataSourcesValues = StreamUtils.ofUnsigned((TShortCollection)dataSource).sorted().mapToObj(Integer::toBinaryString).map(d -> "0b" + d).collect(Collectors.joining(", "));
        Object dataSourcesString = !dataSource.isEmpty() ? ", data sources: [" + dataSourcesValues + "]" : "";
        String counterMapString = !counterMap.isEmpty() ? ", counters : " + String.valueOf(counterMap) : "";
        return String.format("SPE sample at 0x%016x", pc) + oprType + eventsString + (String)dataSourcesString + counterMapString;
    }
}

