/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.pass_one;

import com.arm.streamline.protocol.capture.apc.pass_one.GatorPassOnePerVirtualMachineProtocolEventConsumer;
import com.arm.streamline.protocol.capture.apc.pass_one.IGatorPassOneGlobalStateTracker;
import com.arm.streamline.protocol.capture.apc.protocol.IGatorProtocolEventConsumer;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.function.LongFunction;
import org.eclipse.jdt.annotation.NonNull;

public class GatorPassOneProtocolEventConsumer
implements IGatorProtocolEventConsumer,
Closeable {
    private final @NonNull TLongObjectMap<GatorPassOnePerVirtualMachineProtocolEventConsumer> perVmStates = new TLongObjectHashMap();
    private final @NonNull LongFunction<@NonNull GatorPassOnePerVirtualMachineProtocolEventConsumer> stateFactory;
    private final @NonNull IGatorPassOneGlobalStateTracker stateTracker;

    public GatorPassOneProtocolEventConsumer(@NonNull IGatorPassOneGlobalStateTracker stateTracker, @NonNull LongFunction<@NonNull GatorPassOnePerVirtualMachineProtocolEventConsumer> stateFactory) {
        this.stateTracker = stateTracker;
        this.stateFactory = stateFactory;
    }

    @Override
    public @NonNull GatorPassOnePerVirtualMachineProtocolEventConsumer getVm(long vmUID) {
        GatorPassOnePerVirtualMachineProtocolEventConsumer result = (GatorPassOnePerVirtualMachineProtocolEventConsumer)this.perVmStates.get(vmUID);
        if (result == null) {
            result = this.stateFactory.apply(vmUID);
            this.perVmStates.put(vmUID, (Object)result);
        }
        return result;
    }

    @Override
    public void globalSummary(long wallClockTime, @NonNull Map<@NonNull String, @NonNull String> attributes) {
        this.stateTracker.globalSummary(wallClockTime, attributes);
    }

    @Override
    public void close() throws IOException {
        this.perVmStates.clear();
    }
}

