/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.jni.common;

import com.arm.streamline.jni.common.WarningSeverity;
import com.arm.streamline.jni.common.WarningType;
import java.text.MessageFormat;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class WarningItem {
    private final @NonNull String mDescription;
    private final boolean mPersist;
    private final @NonNull WarningSeverity mSeverity;
    private final @NonNull String mTitle;
    private final @NonNull WarningType mType;
    private final @Nullable String mVariableSubstitutionString;
    private final @Nullable String mVariableWithinList;

    static @NonNull WarningItem make(int n, int n2, @NonNull String string, @NonNull String string2) {
        WarningType warningType = WarningType.fromCxxOrdinal(n);
        WarningSeverity warningSeverity = WarningSeverity.fromCxxOrdinal(n2);
        if (warningType == null || warningSeverity == null) {
            throw new AssertionError((Object)"Invalid type or severity");
        }
        return new WarningItem(warningType, warningSeverity, string, string2);
    }

    public WarningItem(@NonNull WarningType warningType, @NonNull WarningSeverity warningSeverity, @NonNull String string, @NonNull String string2) {
        this(warningType, warningSeverity, string, string2, true);
    }

    public WarningItem(@NonNull WarningType warningType, @NonNull WarningSeverity warningSeverity, @NonNull String string, @NonNull String string2, boolean bl) {
        this.mType = warningType;
        this.mSeverity = warningSeverity;
        this.mTitle = string;
        this.mDescription = string2;
        this.mPersist = bl;
        this.mVariableSubstitutionString = null;
        this.mVariableWithinList = null;
    }

    public WarningItem(@NonNull WarningType warningType, @NonNull WarningSeverity warningSeverity, @NonNull String string, @NonNull String string2, @NonNull String string3) {
        this.mType = warningType;
        this.mSeverity = warningSeverity;
        this.mTitle = string;
        this.mDescription = MessageFormat.format(string2, string3);
        this.mPersist = true;
        this.mVariableSubstitutionString = string2;
        this.mVariableWithinList = string3;
    }

    public boolean equals(Object object) {
        if (object instanceof WarningItem) {
            WarningItem warningItem = (WarningItem)object;
            return this.mPersist == warningItem.mPersist && Objects.equals(this.mDescription, warningItem.mDescription) && Objects.equals((Object)this.mSeverity, (Object)warningItem.mSeverity) && Objects.equals(this.mTitle, warningItem.mTitle) && Objects.equals((Object)this.mType, (Object)warningItem.mType) && Objects.equals(this.mVariableSubstitutionString, warningItem.mVariableSubstitutionString) && Objects.equals(this.mVariableWithinList, warningItem.mVariableWithinList);
        }
        return false;
    }

    public final @NonNull String getDescription() {
        return this.mDescription;
    }

    public final @NonNull WarningSeverity getSeverity() {
        return this.mSeverity;
    }

    public final @NonNull String getTitle() {
        return this.mTitle;
    }

    public final @NonNull WarningType getType() {
        return this.mType;
    }

    public final @Nullable String getVariable() {
        return this.mVariableWithinList;
    }

    public final @Nullable String getVariableSubstitutionString() {
        return this.mVariableSubstitutionString;
    }

    public final boolean isPersistant() {
        return this.mPersist;
    }

    public int hashCode() {
        String string = this.mVariableSubstitutionString;
        String string2 = this.mVariableWithinList;
        int n = 1;
        n = 31 * n + this.mDescription.hashCode();
        n = 31 * n + (this.mPersist ? 1231 : 1237);
        n = 31 * n + this.mSeverity.hashCode();
        n = 31 * n + this.mTitle.hashCode();
        n = 31 * n + this.mType.hashCode();
        n = 31 * n + (string == null ? 0 : string.hashCode());
        n = 31 * n + (string2 == null ? 0 : string2.hashCode());
        return n;
    }

    public String toString() {
        return String.format("WarningItem [mType=%s, mSeverity=%s, mTitle=%s, mDescription=%s]", new Object[]{this.mType, this.mSeverity, this.mTitle, this.mDescription});
    }
}

