/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.jni.common;

import java.lang.ref.Cleaner;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongConsumer;
import org.eclipse.jdt.annotation.NonNull;

public final class NativeHandle
implements AutoCloseable {
    private static final Cleaner CLEANER = Cleaner.create();
    private final @NonNull CleanerFunction cleaner;
    private final @NonNull AtomicLong nativePointer;

    @SafeVarargs
    public static final void closeAll(Iterable<? extends AutoCloseable> ... iterableArray) throws Exception {
        Exception exception = null;
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
        for (Iterable<? extends AutoCloseable> iterable : iterableArray) {
            if (iterable == null) continue;
            for (AutoCloseable autoCloseable : iterable) {
                if (autoCloseable == null) continue;
                try {
                    autoCloseable.close();
                }
                catch (Exception exception2) {
                    if (exception == null) {
                        exception = exception2;
                    }
                    arrayList.add(exception2);
                }
                catch (Throwable throwable) {
                    arrayList.add(throwable);
                }
            }
        }
        if (exception != null && arrayList.size() == 1) {
            throw exception;
        }
        if (!arrayList.isEmpty()) {
            throw new MultipleExceptionsException(arrayList);
        }
    }

    public NativeHandle(long l, @NonNull LongConsumer longConsumer) {
        this.nativePointer = new AtomicLong(l);
        this.cleaner = new CleanerFunction(this.nativePointer, longConsumer);
        CLEANER.register(this, this.cleaner);
    }

    @Override
    public void close() {
        this.cleaner.run();
    }

    public <R, T1 extends Throwable, T2 extends Throwable> Optional<R> doIf(@NonNull Action<@NonNull R, T1, T2> action) throws T1, T2 {
        long l = this.nativePointer.get();
        if (l == 0L) {
            return Optional.empty();
        }
        return Optional.of(action.run(l));
    }

    public <T extends Throwable> void doIf(@NonNull VoidAction<T> voidAction) throws T {
        long l = this.nativePointer.get();
        if (l == 0L) {
            return;
        }
        voidAction.run(l);
    }

    public <R, T1 extends Throwable, T2 extends Throwable> R doWithResult(@NonNull Action<R, T1, T2> action) throws T1, T2 {
        long l = this.nativePointer.get();
        if (l == 0L) {
            throw new IllegalStateException("Native handle pointer is null");
        }
        return action.run(l);
    }

    public <T extends Throwable> void doWith(@NonNull VoidAction<T> voidAction) throws T {
        long l = this.nativePointer.get();
        if (l == 0L) {
            throw new IllegalStateException("Native handle pointer is null");
        }
        voidAction.run(l);
    }

    public long getPointer() {
        return this.nativePointer.get();
    }

    public boolean isValid() {
        return this.nativePointer.get() != 0L;
    }

    public static final class MultipleExceptionsException
    extends Exception {
        public MultipleExceptionsException(@NonNull ArrayList<Throwable> arrayList) {
            super("Multiple exceptions were caught when closing handles");
            for (Throwable throwable : arrayList) {
                this.addSuppressed(throwable);
            }
        }
    }

    private static class CleanerFunction
    implements Runnable {
        private final @NonNull LongConsumer deleter;
        private final @NonNull AtomicLong nativePointer;

        public CleanerFunction(@NonNull AtomicLong atomicLong, @NonNull LongConsumer longConsumer) {
            this.nativePointer = atomicLong;
            this.deleter = longConsumer;
        }

        @Override
        public void run() {
            long l = this.nativePointer.getAndSet(0L);
            if (l != 0L) {
                this.deleter.accept(l);
            }
        }
    }

    @FunctionalInterface
    public static interface Action<R, T1 extends Throwable, T2 extends Throwable> {
        public R run(long var1) throws T1, T2;
    }

    @FunctionalInterface
    public static interface VoidAction<T extends Throwable> {
        public void run(long var1) throws T;
    }
}

