/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.jni.common;

import com.arm.streamline.jni.StreamlineLib;
import com.arm.streamline.jni.common.IProgressMonitorFactory;
import com.arm.streamline.jni.common.NativeHandle;
import java.util.concurrent.ExecutorService;
import org.eclipse.jdt.annotation.NonNull;

public final class Executor {
    private final @NonNull ExecutorService realExecutor;
    private final @NonNull IProgressMonitorFactory progressMonitorFactory;

    private static native void destroyTask(long var0);

    private static native void runTask(long var0, @NonNull IProgressMonitorFactory var2);

    public Executor(@NonNull ExecutorService executorService, @NonNull IProgressMonitorFactory iProgressMonitorFactory) {
        this.realExecutor = executorService;
        this.progressMonitorFactory = iProgressMonitorFactory;
    }

    public void submit(@NonNull Runnable runnable) {
        this.realExecutor.submit(runnable);
    }

    private final void submitNativeTask(long l) {
        this.submit(new WrappedNativeTask(new NativeHandle(l, Executor::destroyTask), this.progressMonitorFactory));
    }

    private final void submitNativeTaskNow(long l) throws Exception {
        try (WrappedNativeTask wrappedNativeTask = new WrappedNativeTask(new NativeHandle(l, Executor::destroyTask), this.progressMonitorFactory);){
            wrappedNativeTask.run();
        }
    }

    static {
        if (!StreamlineLib.isLoaded) {
            throw new AssertionError((Object)"Failed to load common JNI lib");
        }
    }

    private static final class WrappedNativeTask
    implements AutoCloseable,
    Runnable {
        private final @NonNull NativeHandle handle;
        private final @NonNull IProgressMonitorFactory progressMonitorFactory;

        private WrappedNativeTask(@NonNull NativeHandle nativeHandle, @NonNull IProgressMonitorFactory iProgressMonitorFactory) {
            this.handle = nativeHandle;
            this.progressMonitorFactory = iProgressMonitorFactory;
        }

        @Override
        public void run() {
            try {
                this.handle.doWith(l -> Executor.runTask(l, this.progressMonitorFactory));
            }
            finally {
                this.handle.close();
            }
        }

        @Override
        public void close() throws Exception {
            this.handle.close();
        }
    }
}

