/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.jni.apcdbgen.proto;

import com.arm.streamline.jni.apcdbgen.proto.IExtractable;
import com.arm.streamline.jni.apcdbgen.proto.IOptionalSourceLineReference;
import com.arm.streamline.jni.apcdbgen.proto.ISamplesReportDataForDisasmAndSourceAnnotations;
import com.arm.streamline.jni.apcdbgen.proto.ISourceLineReference;
import com.arm.streamline.jni.apcdbgen.proto.ImageFile;
import com.arm.streamline.jni.apcdbgen.proto.ReferencedSymbol;
import com.arm.streamline.jni.apcdbgen.proto.SimpleSourceReference;
import com.arm.streamline.jni.apcdbgen.proto.SourceLocation;
import com.arm.streamline.jni.apcdbgen.proto.SymbolName;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class Symbol
implements Comparable<Symbol>,
IExtractable,
IOptionalSourceLineReference {
    public static final long UNKNOWN_UID = 0L;
    public final long address;
    public final @NonNull List<@NonNull SymbolName> aliases;
    public final long fileOffset;
    public final @NonNull ImageFile image;
    public final @Nullable SymbolName inlinedSymbolName;
    public final @Nullable ISamplesReportDataForDisasmAndSourceAnnotations.InstructionRange instructionRange;
    public final @NonNull SymbolName name;
    public final @Nullable ReferencedSymbol referencedSymbol;
    public final long sizeInBytes;
    public final @Nullable SourceLocation sourceLocation;
    public final long stackFrameSize;
    public final long uid;

    public Symbol(@NonNull ImageFile imageFile, long l, @NonNull SymbolName symbolName, @Nullable SymbolName symbolName2, long l2, long l3, long l4, long l5, @Nullable List<@NonNull SymbolName> list, @Nullable SourceLocation sourceLocation, @Nullable ISamplesReportDataForDisasmAndSourceAnnotations.InstructionRange instructionRange) {
        this.referencedSymbol = null;
        this.uid = l;
        this.image = imageFile;
        this.name = symbolName;
        this.inlinedSymbolName = symbolName2;
        this.fileOffset = l2;
        this.address = l3;
        this.sizeInBytes = l4;
        this.stackFrameSize = l5;
        this.aliases = list != null ? list : Collections.emptyList();
        this.sourceLocation = sourceLocation;
        this.instructionRange = instructionRange;
    }

    public Symbol(long l, @NonNull ImageFile imageFile, long l2) {
        this.referencedSymbol = new ReferencedSymbol(l, this);
        this.uid = l2;
        this.image = imageFile;
        this.name = imageFile.uid == 0L ? new SymbolName("<unknown code>", null) : new SymbolName("<unknown code in " + imageFile.imageName + ">", null);
        this.inlinedSymbolName = null;
        this.fileOffset = 0L;
        this.address = 0L;
        this.sizeInBytes = 0L;
        this.stackFrameSize = 0L;
        this.aliases = Collections.emptyList();
        this.sourceLocation = null;
        this.instructionRange = null;
    }

    public Symbol(long l, @NonNull ImageFile imageFile, long l2, @NonNull SymbolName symbolName, @Nullable SymbolName symbolName2, long l3, long l4, long l5, long l6, @Nullable List<@NonNull SymbolName> list, @Nullable SourceLocation sourceLocation, @Nullable ISamplesReportDataForDisasmAndSourceAnnotations.InstructionRange instructionRange) {
        this.referencedSymbol = new ReferencedSymbol(l, this);
        this.uid = l2;
        this.image = imageFile;
        this.name = symbolName;
        this.inlinedSymbolName = symbolName2;
        this.fileOffset = l3;
        this.address = l4;
        this.sizeInBytes = l5;
        this.stackFrameSize = l6;
        this.aliases = list != null ? list : Collections.emptyList();
        this.sourceLocation = sourceLocation;
        this.instructionRange = instructionRange;
    }

    public Symbol(long l, @NonNull Symbol symbol, long l2, @NonNull SymbolName symbolName) {
        assert (symbol.inlinedSymbolName == null);
        this.referencedSymbol = new ReferencedSymbol(l, this);
        this.uid = l2;
        this.image = symbol.image;
        this.name = symbol.name;
        this.inlinedSymbolName = symbolName;
        this.fileOffset = symbol.fileOffset;
        this.address = symbol.address;
        this.sizeInBytes = symbol.sizeInBytes;
        this.stackFrameSize = symbol.stackFrameSize;
        this.aliases = symbol.aliases;
        this.sourceLocation = symbol.sourceLocation;
        this.instructionRange = symbol.instructionRange;
    }

    public Symbol(@Nullable Long l, @NonNull ImageFile imageFile, long l2, @NonNull SymbolName symbolName, @Nullable SymbolName symbolName2, long l3, long l4, long l5, long l6, @Nullable List<@NonNull SymbolName> list, @Nullable SourceLocation sourceLocation, @Nullable ISamplesReportDataForDisasmAndSourceAnnotations.InstructionRange instructionRange) {
        this.referencedSymbol = l != null ? new ReferencedSymbol(l, this) : null;
        this.uid = l2;
        this.image = imageFile;
        this.name = symbolName;
        this.inlinedSymbolName = symbolName2;
        this.fileOffset = l3;
        this.address = l4;
        this.sizeInBytes = l5;
        this.stackFrameSize = l6;
        this.aliases = list != null ? list : Collections.emptyList();
        this.sourceLocation = sourceLocation;
        this.instructionRange = instructionRange;
    }

    @Override
    public <R, E extends Throwable> R accept(@NonNull IExtractable.IExtractableVisitor<R, E> iExtractableVisitor) throws E {
        return iExtractableVisitor.visit(this);
    }

    @Override
    public @Nullable ISourceLineReference asSourceLineReference() {
        ReferencedSymbol referencedSymbol = this.referencedSymbol;
        SourceLocation sourceLocation = this.sourceLocation;
        if (referencedSymbol != null && sourceLocation != null) {
            return new SimpleSourceReference(referencedSymbol, sourceLocation.sourceFile, sourceLocation.lineNo);
        }
        return null;
    }

    @Override
    public int compareTo(@NonNull Symbol symbol) {
        int n = Long.compareUnsigned(this.address, symbol.address);
        if (n == 0) {
            n = Long.compareUnsigned(this.fileOffset, symbol.fileOffset);
        }
        if (n == 0) {
            n = this.name.compareTo(symbol.name);
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Symbol) {
            Symbol symbol = (Symbol)object;
            return this.equals(symbol);
        }
        return false;
    }

    public boolean equals(@NonNull Symbol symbol) {
        return this.fileOffset == symbol.fileOffset && this.address == symbol.address && this.sizeInBytes == symbol.sizeInBytes && this.stackFrameSize == symbol.stackFrameSize && this.image.equals(symbol.image) && this.name.equals(symbol.name) && SymbolName.equals(this.inlinedSymbolName, symbol.inlinedSymbolName) && SourceLocation.equals(this.sourceLocation, symbol.sourceLocation) && ISamplesReportDataForDisasmAndSourceAnnotations.InstructionRange.equals(this.instructionRange, symbol.instructionRange) && this.aliases.equals(symbol.aliases);
    }

    public @NonNull String getName() {
        String string = this.name.unmangledName != null && !this.name.unmangledName.isBlank() ? this.name.unmangledName : this.name.mangledName;
        SymbolName symbolName = this.inlinedSymbolName;
        if (symbolName != null) {
            String string2 = symbolName.unmangledName != null && !symbolName.unmangledName.isBlank() ? symbolName.unmangledName : symbolName.mangledName;
            return String.format("%s (inlined into %s)", string2, string);
        }
        assert (string != null);
        return string;
    }

    public int hashCode() {
        return Long.hashCode(this.fileOffset) * 31 ^ Long.hashCode(this.address);
    }

    public boolean isUnknown() {
        return this.uid == 0L;
    }

    public String toString() {
        return "Symbol [address=" + this.address + ", name=" + String.valueOf(this.name) + ", inlinedSymbolName=" + String.valueOf(this.inlinedSymbolName) + ", sizeInBytes=" + this.sizeInBytes + ", stackFrameSize=" + this.stackFrameSize + "]";
    }
}

