/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.jni.apcdbgen.proto;

import com.arm.streamline.jni.apcdbgen.proto.IExtractable;
import com.arm.streamline.jni.apcdbgen.proto.IOptionalSourceLineReference;
import com.arm.streamline.jni.apcdbgen.proto.ISourceLineReference;
import com.arm.streamline.jni.apcdbgen.proto.IUniqueThreadID;
import com.arm.streamline.jni.apcdbgen.proto.ReferencedSymbol;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class CallPathNode
implements Comparable<CallPathNode>,
IExtractable,
IOptionalSourceLineReference {
    public final @NonNull CallPathNode @NonNull [] children;
    public final long itemUID;
    public final @NonNull String label;
    public final @Nullable CallPathNode parent;
    public final @Nullable ReferencedSymbol symbol;
    public final @Nullable IUniqueThreadID thread;
    public final @NonNull Type type;
    public final long uid;

    public CallPathNode(@NonNull Type type, long l, long l2, @Nullable IUniqueThreadID iUniqueThreadID, @Nullable ReferencedSymbol referencedSymbol, @NonNull String string, @NonNull CallPathNode @NonNull [] callPathNodeArray, @Nullable CallPathNode callPathNode) {
        this.type = type;
        this.uid = l;
        this.itemUID = l2;
        this.thread = iUniqueThreadID;
        this.symbol = referencedSymbol;
        this.label = string;
        this.children = callPathNodeArray;
        this.parent = callPathNode;
    }

    @Override
    public <R, E extends Throwable> R accept(@NonNull IExtractable.IExtractableVisitor<R, E> iExtractableVisitor) throws E {
        return iExtractableVisitor.visit(this);
    }

    @Override
    public @Nullable ISourceLineReference asSourceLineReference() {
        ReferencedSymbol referencedSymbol = this.symbol;
        if (referencedSymbol != null) {
            return referencedSymbol.asSourceLineReference();
        }
        return null;
    }

    @Override
    public int compareTo(@NonNull CallPathNode callPathNode) {
        int n = Type.compareWith(this.type, callPathNode.type);
        if (n == 0) {
            n = Long.compareUnsigned(this.uid, callPathNode.uid);
        }
        return n;
    }

    public boolean equals(@NonNull CallPathNode callPathNode) {
        return this.uid == callPathNode.uid && this.type == callPathNode.type && this.itemUID == callPathNode.itemUID;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof CallPathNode) {
            CallPathNode callPathNode = (CallPathNode)object;
            return this.equals(callPathNode);
        }
        return false;
    }

    public int hashCode() {
        return Long.hashCode(this.uid);
    }

    public String toString() {
        return "CallPathNode [type=" + String.valueOf((Object)this.type) + ", uid=" + this.uid + ", itemUID=" + this.itemUID + ", thread=" + String.valueOf(this.thread) + ", symbol=" + String.valueOf(this.symbol) + ", label=" + this.label + "]";
    }

    public static enum Type {
        PROCESS,
        SYMBOL,
        THREAD,
        VMUID;


        public static int compareWith(@NonNull Type type, @NonNull Type type2) {
            switch (type.ordinal()) {
                case 3: {
                    switch (type2.ordinal()) {
                        case 0: 
                        case 1: 
                        case 2: {
                            return -1;
                        }
                        case 3: {
                            return 0;
                        }
                    }
                    throw new AssertionError((Object)type2);
                }
                case 0: {
                    switch (type2.ordinal()) {
                        case 1: 
                        case 2: {
                            return -1;
                        }
                        case 0: {
                            return 0;
                        }
                        case 3: {
                            return 1;
                        }
                    }
                    throw new AssertionError((Object)type2);
                }
                case 2: {
                    switch (type2.ordinal()) {
                        case 1: {
                            return -1;
                        }
                        case 2: {
                            return 0;
                        }
                        case 0: 
                        case 3: {
                            return 1;
                        }
                    }
                    throw new AssertionError((Object)type2);
                }
                case 1: {
                    switch (type2.ordinal()) {
                        case 1: {
                            return 0;
                        }
                        case 0: 
                        case 2: 
                        case 3: {
                            return 1;
                        }
                    }
                    throw new AssertionError((Object)type2);
                }
            }
            throw new AssertionError((Object)type);
        }
    }
}

