/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.jni.apcdbgen.proto;

import com.arm.streamline.jni.apcdbgen.proto.CallPathNode;
import com.arm.streamline.jni.apcdbgen.proto.ICallPathFunctions;
import com.arm.streamline.jni.apcdbgen.proto.IColumnDescriptor;
import com.arm.streamline.jni.apcdbgen.proto.ISampleCounterColumnAccessorFactory;
import com.arm.streamline.jni.apcdbgen.proto.ISamplesReportData;
import com.arm.streamline.jni.apcdbgen.proto.ReferencedSymbol;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.LongFunction;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class CallPathFunctions
implements ICallPathFunctions {
    private final @NonNull IAccessorSupplier accessorSupplier;
    private final @NonNull ISamplesReportData parent;
    private final @NonNull Map<@NonNull ReferencedSymbol, @NonNull Set<@NonNull CallPathNode>> referencedSymbols = new HashMap<ReferencedSymbol, Set<CallPathNode>>();
    private final @NonNull CallPathNode rootNode;
    private final @Nullable ITopCallpathsMetricSupplier topCallpathsMetricSupplier;

    public CallPathFunctions(@NonNull ISamplesReportData iSamplesReportData, @NonNull CallPathNode callPathNode, @NonNull IAccessorSupplier iAccessorSupplier, @Nullable ITopCallpathsMetricSupplier iTopCallpathsMetricSupplier) {
        this.parent = iSamplesReportData;
        this.rootNode = callPathNode;
        this.accessorSupplier = iAccessorSupplier;
        this.topCallpathsMetricSupplier = iTopCallpathsMetricSupplier;
        this.addChild(callPathNode);
    }

    @Override
    public <D, R, E extends Throwable> R getCallPathFunctionsDataAccessorFor(@NonNull IColumnDescriptor iColumnDescriptor, @NonNull ISampleCounterColumnAccessorFactory<D, R, E> iSampleCounterColumnAccessorFactory, D d) throws E {
        return this.accessorSupplier.getCallPathFunctionsDataAccessorFor(iColumnDescriptor, this.rootNode, this.referencedSymbols, iSampleCounterColumnAccessorFactory, d);
    }

    @Override
    public @NonNull ISamplesReportData getParent() {
        return this.parent;
    }

    @Override
    public @NonNull Set<@NonNull ReferencedSymbol> getReferencedSymbols() {
        return this.referencedSymbols.keySet();
    }

    @Override
    public @NonNull CallPathNode getRootCallPathNode() {
        return this.rootNode;
    }

    @Override
    public @Nullable LongFunction<@Nullable ISampleCounterColumnAccessorFactory.PercentAndLong> getTopCallpathsMetricSupplier() {
        ITopCallpathsMetricSupplier iTopCallpathsMetricSupplier = this.topCallpathsMetricSupplier;
        if (iTopCallpathsMetricSupplier == null) {
            return null;
        }
        return iTopCallpathsMetricSupplier.getTopCallpathsMetricSupplier(this.rootNode, this.referencedSymbols);
    }

    private void addChild(@NonNull CallPathNode callPathNode) {
        ReferencedSymbol referencedSymbol2 = callPathNode.symbol;
        if (referencedSymbol2 != null) {
            Set set = this.referencedSymbols.computeIfAbsent(referencedSymbol2, referencedSymbol -> new HashSet());
            set.add(callPathNode);
        }
        for (CallPathNode callPathNode2 : callPathNode.children) {
            this.addChild(callPathNode2);
        }
    }

    @FunctionalInterface
    public static interface IAccessorSupplier {
        public <D, R, E extends Throwable> R getCallPathFunctionsDataAccessorFor(@NonNull IColumnDescriptor var1, @NonNull CallPathNode var2, @NonNull Map<@NonNull ReferencedSymbol, @NonNull Set<@NonNull CallPathNode>> var3, @NonNull ISampleCounterColumnAccessorFactory<D, R, E> var4, D var5) throws E;
    }

    @FunctionalInterface
    public static interface ITopCallpathsMetricSupplier {
        public @Nullable LongFunction<@Nullable ISampleCounterColumnAccessorFactory.PercentAndLong> getTopCallpathsMetricSupplier(@NonNull CallPathNode var1, @NonNull Map<@NonNull ReferencedSymbol, @NonNull Set<@NonNull CallPathNode>> var2);
    }
}

