/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.jni.apcdbgen.proto;

import com.arm.streamline.jni.apcdbgen.proto.BufferTransferType;
import com.arm.streamline.jni.apcdbgen.proto.ILabelVisitor;
import com.arm.streamline.jni.apcdbgen.proto.TimelineWorkload;
import org.eclipse.jdt.annotation.NonNull;

public final class BufferTransfer
extends TimelineWorkload {
    private static final @NonNull String WORKLOAD_NAME = "Buffer Transfer";
    private final int byteCount;
    private final @NonNull BufferTransferType type;

    public BufferTransfer(@NonNull String @NonNull [] stringArray, long l, long l2, long l3, int n, @NonNull BufferTransferType bufferTransferType) {
        super(WORKLOAD_NAME, stringArray, l, l2, l3);
        this.byteCount = n;
        this.type = bufferTransferType;
        this.addProperties();
    }

    @Override
    public void accept(@NonNull ILabelVisitor iLabelVisitor) {
        iLabelVisitor.visit(this);
    }

    private void addProperties() {
        if (this.byteCount < 0) {
            this.addProperty("Transfer size", "Unknown");
        } else {
            String string = this.byteCount != 1 ? "s" : "";
            this.addProperty("Transfer size", String.format("%d byte%s", this.byteCount, string));
        }
    }

    public long getByteCount() {
        return this.byteCount;
    }

    public @NonNull BufferTransferType getTransferType() {
        return this.type;
    }

    @Override
    public String toString() {
        return "BufferTransfer[byteCount=" + this.byteCount + ", type=" + String.valueOf((Object)this.type) + ", super=" + super.toString() + "]";
    }

    @Override
    public int getColor() {
        return TimelineWorkload.WorkloadColor.BUFFER_TRANSFER.getHex();
    }
}

