/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.jni.apcdbgen.impl;

import org.eclipse.jdt.annotation.NonNull;

public final class ProfilingReportGroup
implements Comparable<ProfilingReportGroup> {
    public static final long OFF_CPU = 0L;
    public static final long METRICS = 1L;
    public static final long PERIODIC_SAMPLING = 2L;
    public static final long SPE = 3L;
    public static final long SPE_MULTI_CORE = 4L;
    public static final long EBS_BASE = 5L;
    private final long group;

    public static @NonNull ProfilingReportGroup fromLong(long l) {
        return new ProfilingReportGroup(l);
    }

    private ProfilingReportGroup(long l) {
        this.group = l;
    }

    @Override
    public int compareTo(@NonNull ProfilingReportGroup profilingReportGroup) {
        return Integer.compare(this.sortRank(), profilingReportGroup.sortRank());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ProfilingReportGroup) {
            ProfilingReportGroup profilingReportGroup = (ProfilingReportGroup)object;
            return this.group == profilingReportGroup.group;
        }
        return false;
    }

    public int hashCode() {
        return Long.hashCode(this.group);
    }

    public @NonNull String toString() {
        if (this.group == 0L) {
            return "OFF_CPU";
        }
        if (this.group == 1L) {
            return "METRICS";
        }
        if (this.group == 2L) {
            return "PERIODIC_SAMPLING";
        }
        if (this.group == 3L) {
            return "SPE";
        }
        if (this.group == 4L) {
            return "SPE_MULTI_CORE";
        }
        long l = this.group - 5L;
        return "EBS (event key " + l + ")";
    }

    public long underlyingId() {
        return this.group;
    }

    private int sortRank() {
        if (this.group == 2L) {
            return 0;
        }
        if (this.group == 1L) {
            return 1;
        }
        if (this.group == 0L) {
            return 2;
        }
        if (this.group == 3L) {
            return 4;
        }
        if (this.group == 4L) {
            return 5;
        }
        return 3;
    }
}

