/*
 * Decompiled with CFR 0.152.
 */
package com.arm.coresight.itm;

import com.arm.coresight.itm.IITMPacketReceiver;
import com.arm.coresight.itm.InvalidITMPacketFormatException;
import java.nio.ByteBuffer;
import java.util.BitSet;
import org.eclipse.jdt.annotation.NonNull;

public class ITMParser {
    State state = State.WAITING_FOR_SYNC;
    private final @NonNull IITMPacketReceiver receiver;
    private byte b = 0;
    private boolean doAdvance = true;
    private int bitShift = 0;
    private long longValue = 0L;
    private int numPayloadDataBytes = 0;
    private int numZeroBytesInARow = 0;
    private byte @NonNull [] payloadDataBytes = new byte[0];
    private byte switChannelNumber = 0;
    private boolean isHWSourcePacket = false;
    private int comparatorIndex = 0;
    private IITMPacketReceiver.DataOperation operation = IITMPacketReceiver.DataOperation.READ;
    private boolean allowHardwareSourcePackets = true;

    public ITMParser(@NonNull IITMPacketReceiver receiver) {
        this.receiver = receiver;
    }

    public ITMParser(@NonNull IITMPacketReceiver receiver, boolean isSynchronized, boolean allowHardwareSourcePackets) {
        this.receiver = receiver;
        this.state = isSynchronized ? State.WAITING_FOR_PACKET_HEADER : State.WAITING_FOR_SYNC;
        this.allowHardwareSourcePackets = allowHardwareSourcePackets;
    }

    public void parse(ByteBuffer data) throws InvalidITMPacketFormatException {
        while (data.hasRemaining()) {
            if (this.doAdvance) {
                this.b = data.get();
                this.doAdvance = false;
            }
            switch (this.state) {
                case WAITING_FOR_SYNC: {
                    if (this.b == 0) {
                        ++this.numZeroBytesInARow;
                    } else if (this.b == -128 && this.numZeroBytesInARow >= 5) {
                        this.state = State.WAITING_FOR_PACKET_HEADER;
                    } else {
                        this.numZeroBytesInARow = 0;
                    }
                    this.doAdvance = true;
                    break;
                }
                case COLLECTING_INSTRUMENTATION_OR_HARDWARE_SOURCE_PAYLOAD: {
                    this.payloadDataBytes[this.payloadDataBytes.length - this.numPayloadDataBytes] = this.b;
                    --this.numPayloadDataBytes;
                    if (this.numPayloadDataBytes == 0) {
                        if (this.isHWSourcePacket) {
                            this.receiver.onHardwarePacket(this.switChannelNumber, this.payloadDataBytes);
                        } else {
                            this.receiver.onInstrumentationPacket(this.switChannelNumber, this.payloadDataBytes);
                        }
                        this.state = State.WAITING_FOR_PACKET_HEADER;
                    }
                    this.doAdvance = true;
                    break;
                }
                case COLLECTING_GLOBAL_TIMESTAMP_PAYLOAD_GTS2: {
                    ++this.numPayloadDataBytes;
                    int bitmask2 = 127;
                    if (this.numPayloadDataBytes == 4) {
                        bitmask2 = 1;
                    } else if (this.numPayloadDataBytes == 6) {
                        bitmask2 = 7;
                    }
                    long value7bits3 = this.b & bitmask2;
                    this.longValue |= value7bits3 << this.bitShift + 26;
                    this.bitShift += 7;
                    if ((this.b & 0x100) != 0) {
                        this.doAdvance = true;
                        break;
                    }
                    byte reversedBitmask = (byte)(255 - bitmask2);
                    if ((this.b & reversedBitmask) != 0) {
                        throw new InvalidITMPacketFormatException("Invalid bits set in global timestamp payload bytes.");
                    }
                    this.receiver.onGlobalTimestampPacket(this.longValue, IITMPacketReceiver.GlobalTimestampValueHint.ONLY_UPPER_BITS, -67108864L);
                    this.doAdvance = true;
                    this.state = State.WAITING_FOR_PACKET_HEADER;
                    break;
                }
                case COLLECTING_GLOBAL_TIMESTAMP_PAYLOAD_GTS1: {
                    ++this.numPayloadDataBytes;
                    int bitmask = 127;
                    if (this.numPayloadDataBytes == 4) {
                        bitmask = 31;
                    }
                    long value7bits = this.b & bitmask;
                    this.longValue |= value7bits << this.bitShift;
                    this.bitShift += 7;
                    if ((this.b & 0x100) != 0) {
                        this.doAdvance = true;
                        break;
                    }
                    IITMPacketReceiver.GlobalTimestampValueHint hint = IITMPacketReceiver.GlobalTimestampValueHint.ONLY_LOWER_BITS;
                    if (this.numPayloadDataBytes == 4 && (this.b & 0x40) != 0) {
                        hint = IITMPacketReceiver.GlobalTimestampValueHint.ONLY_LOWER_BITS_WAIT_FOR_UPPER;
                    }
                    long mask = 0L;
                    int maskBitShift = this.bitShift > 21 ? 26 : this.bitShift;
                    int i = 0;
                    while (i < maskBitShift) {
                        mask |= (long)(1 << i);
                        ++i;
                    }
                    this.receiver.onGlobalTimestampPacket(this.longValue, hint, mask);
                    this.doAdvance = true;
                    this.state = State.WAITING_FOR_PACKET_HEADER;
                    break;
                }
                case COLLECTING_LOCAL_TIMESTAMP_PAYLOAD_LTS1: {
                    long value7bits2 = this.b & 0x7F;
                    this.longValue |= value7bits2 << this.bitShift;
                    this.bitShift += 7;
                    if ((this.b & 0x80) == 0) {
                        this.receiver.onLocalTimestampPacket(this.longValue);
                        this.state = State.WAITING_FOR_PACKET_HEADER;
                    }
                    this.doAdvance = true;
                    break;
                }
                case COLLECTING_EXTENSION_PAYLOAD: {
                    long value7bits4 = this.b & 0x7F;
                    this.longValue |= value7bits4 << this.bitShift;
                    this.bitShift += 7;
                    if ((this.b & 0x80) == 0) {
                        this.receiver.onExtensionPacket(this.longValue);
                        this.state = State.WAITING_FOR_PACKET_HEADER;
                    }
                    this.doAdvance = true;
                    break;
                }
                case COLLECTING_EVENT_COUNTER_PAYLOAD: {
                    this.doAdvance = true;
                    if ((this.b & 0xFFFFFFC0) != 0) {
                        throw new InvalidITMPacketFormatException("Invalid bits set in event counter payload byte.");
                    }
                    this.receiver.onEventCounterPacket(BitSet.valueOf(new byte[]{this.b}));
                    this.state = State.WAITING_FOR_PACKET_HEADER;
                    break;
                }
                case COLLECTING_EXCEPTION_PAYLOAD_1: {
                    this.doAdvance = true;
                    this.longValue = this.b;
                    this.state = State.COLLECTING_EXCEPTION_PAYLOAD_2;
                    break;
                }
                case COLLECTING_EXCEPTION_PAYLOAD_2: {
                    this.doAdvance = true;
                    if ((this.b & 0xFFFFFFCE) != 0) {
                        throw new InvalidITMPacketFormatException("Invalid bits set in exception trace packet payload.");
                    }
                    this.receiver.onExceptionTracePacket((int)(this.longValue | (long)((this.b & 1) << 8)), switch ((this.b & 0x30) >> 4) {
                        case 1 -> IITMPacketReceiver.ExceptionFunction.ENTERED_EXCEPTION;
                        case 2 -> IITMPacketReceiver.ExceptionFunction.EXITED_EXCEPTION;
                        case 3 -> IITMPacketReceiver.ExceptionFunction.RETURNED_TO_EXCEPTION;
                        default -> throw new InvalidITMPacketFormatException("Invalid (reserved) exception function encoding.");
                    });
                    this.state = State.WAITING_FOR_PACKET_HEADER;
                    break;
                }
                case COLLECTING_DATA_TRACE_MATCH_PAYLOAD: {
                    if ((this.b & 1) != 0) {
                        this.receiver.onDataTraceMatchPacket(this.comparatorIndex);
                    } else {
                        this.receiver.onDataTracePCValuePacket(this.comparatorIndex, this.b);
                    }
                    this.state = State.WAITING_FOR_PACKET_HEADER;
                    break;
                }
                case COLLECTING_DATA_TRACE_PC_VALUE_PAYLOAD: {
                    --this.numPayloadDataBytes;
                    int v = this.b & 0xFF;
                    this.longValue |= (long)(v << this.bitShift);
                    this.bitShift += 8;
                    if (this.numPayloadDataBytes == 0) {
                        this.receiver.onDataTracePCValuePacket(this.comparatorIndex, this.longValue);
                        this.state = State.WAITING_FOR_PACKET_HEADER;
                    }
                    this.doAdvance = true;
                    break;
                }
                case COLLECTING_DATA_TRACE_DATA_ADDRESS_PAYLOAD: {
                    --this.numPayloadDataBytes;
                    int v2 = this.b & 0xFF;
                    this.longValue |= (long)(v2 << this.bitShift);
                    this.bitShift += 8;
                    if (this.numPayloadDataBytes == 0) {
                        this.receiver.onDataTraceDataAddressPacket(this.comparatorIndex, this.longValue);
                        this.state = State.WAITING_FOR_PACKET_HEADER;
                    }
                    this.doAdvance = true;
                    break;
                }
                case COLLECTING_DATA_TRACE_DATA_VALUE_PAYLOAD: {
                    --this.numPayloadDataBytes;
                    int v3 = this.b & 0xFF;
                    this.longValue |= (long)(v3 << this.bitShift);
                    this.bitShift += 8;
                    if (this.numPayloadDataBytes == 0) {
                        this.receiver.onDataTraceDataValuePacket(this.comparatorIndex, this.longValue, this.operation);
                        this.state = State.WAITING_FOR_PACKET_HEADER;
                    }
                    this.doAdvance = true;
                    break;
                }
                case COLLECTING_PERIODIC_PC_SAMPLE_PAYLOAD_4BYTES: {
                    --this.numPayloadDataBytes;
                    int v4 = this.b & 0xFF;
                    this.longValue |= (long)(v4 << this.bitShift);
                    this.bitShift += 8;
                    if (this.numPayloadDataBytes == 0) {
                        this.receiver.onPeriodicPCSamplePacket(this.longValue);
                        this.state = State.WAITING_FOR_PACKET_HEADER;
                    }
                    this.doAdvance = true;
                    break;
                }
                case COLLECTING_PERIODIC_PC_SAMPLE_PAYLOAD_1BYTE: {
                    switch (this.b) {
                        case -1: {
                            this.receiver.onPeriodicPCSamplePacketProhibited();
                            break;
                        }
                        case 0: {
                            this.receiver.onPeriodicPCSamplePacketSleeping();
                            break;
                        }
                        default: {
                            throw new InvalidITMPacketFormatException("Invalid encoding for periodic PC sample (sleeping or prohibited state).");
                        }
                    }
                    this.state = State.WAITING_FOR_PACKET_HEADER;
                    this.doAdvance = true;
                    break;
                }
                case WAITING_FOR_PACKET_HEADER: {
                    if (this.b == 112) {
                        this.receiver.onOverflowPacket();
                        this.doAdvance = true;
                        break;
                    }
                    if (this.b == -76) {
                        this.doAdvance = true;
                        this.bitShift = 0;
                        this.longValue = 0L;
                        this.numPayloadDataBytes = 0;
                        this.state = State.COLLECTING_GLOBAL_TIMESTAMP_PAYLOAD_GTS2;
                        break;
                    }
                    if (this.b == -108) {
                        this.doAdvance = true;
                        this.bitShift = 0;
                        this.longValue = 0L;
                        this.numPayloadDataBytes = 0;
                        this.state = State.COLLECTING_GLOBAL_TIMESTAMP_PAYLOAD_GTS1;
                        break;
                    }
                    if ((this.b & 3) != 0) {
                        boolean bl = this.isHWSourcePacket = (this.b & 4) != 0;
                        if (this.isHWSourcePacket && !this.allowHardwareSourcePackets) {
                            throw new InvalidITMPacketFormatException("Hardware source packet encountered but not allowed");
                        }
                        if (this.b == 5) {
                            this.state = State.COLLECTING_EVENT_COUNTER_PAYLOAD;
                        } else if (this.b == 14) {
                            this.state = State.COLLECTING_EXCEPTION_PAYLOAD_1;
                        } else if ((this.b & 0xCE) == 70) {
                            this.comparatorIndex = (this.b & 0x30) >> 4;
                            this.bitShift = 0;
                            switch (this.b & 3) {
                                case 2: {
                                    this.numPayloadDataBytes = 2;
                                    break;
                                }
                                case 3: {
                                    this.numPayloadDataBytes = 4;
                                    break;
                                }
                                default: {
                                    throw new InvalidITMPacketFormatException("Invalid encoding for payload size");
                                }
                            }
                            this.state = State.COLLECTING_DATA_TRACE_PC_VALUE_PAYLOAD;
                        } else if ((this.b & 0xFFFFFFCF) == 69) {
                            this.comparatorIndex = (this.b & 0x30) >> 4;
                            this.state = State.COLLECTING_DATA_TRACE_MATCH_PAYLOAD;
                        } else if ((this.b & 0xFFFFFFCC) == 76 && (this.b & 3) != 0) {
                            this.comparatorIndex = (this.b & 0x30) >> 4;
                            this.setPayloadSize();
                            this.state = State.COLLECTING_DATA_TRACE_DATA_ADDRESS_PAYLOAD;
                        } else if ((this.b & 0xFFFFFFC4) == -124 && (this.b & 3) != 0) {
                            this.comparatorIndex = (this.b & 0x30) >> 4;
                            this.setPayloadSize();
                            this.operation = (this.b & 8) != 0 ? IITMPacketReceiver.DataOperation.WRITE : IITMPacketReceiver.DataOperation.READ;
                            this.state = State.COLLECTING_DATA_TRACE_DATA_VALUE_PAYLOAD;
                        } else if ((this.b & 0xFFFFFFFD) == 21) {
                            if ((this.b & 2) != 0) {
                                this.state = State.COLLECTING_PERIODIC_PC_SAMPLE_PAYLOAD_4BYTES;
                                this.numPayloadDataBytes = 4;
                                this.bitShift = 0;
                            } else {
                                this.state = State.COLLECTING_PERIODIC_PC_SAMPLE_PAYLOAD_1BYTE;
                            }
                        } else {
                            this.setPayloadSize();
                            this.payloadDataBytes = new byte[this.numPayloadDataBytes];
                            this.switChannelNumber = (byte)((this.b & 0xF8) >> 3);
                            this.state = State.COLLECTING_INSTRUMENTATION_OR_HARDWARE_SOURCE_PAYLOAD;
                        }
                        this.doAdvance = true;
                        break;
                    }
                    if ((this.b & 0xB) == 8) {
                        this.longValue = (this.b & 0x70) >> 4;
                        if ((this.b & 0x80) != 0) {
                            this.bitShift = 3;
                            this.state = State.COLLECTING_EXTENSION_PAYLOAD;
                        } else {
                            this.receiver.onExtensionPacket(this.longValue);
                        }
                        this.doAdvance = true;
                        break;
                    }
                    if ((this.b & 0x70) != 0) {
                        this.doAdvance = true;
                        if ((this.b & 0x80) != 0) {
                            this.bitShift = 0;
                            this.longValue = 0L;
                            this.state = State.COLLECTING_LOCAL_TIMESTAMP_PAYLOAD_LTS1;
                            break;
                        }
                        long value = (this.b & 0x70) >> 4;
                        this.receiver.onLocalTimestampPacket(value);
                        break;
                    }
                    if (this.b == 0) {
                        this.state = State.WAITING_FOR_SYNC;
                        this.doAdvance = true;
                        this.numZeroBytesInARow = 1;
                        break;
                    }
                    throw new InvalidITMPacketFormatException("Unknown ITM packet header byte");
                }
                default: {
                    throw new InvalidITMPacketFormatException("ITM Parser in invalid state");
                }
            }
        }
    }

    private void setPayloadSize() throws AssertionError {
        switch (this.b & 3) {
            case 1: {
                this.numPayloadDataBytes = 1;
                break;
            }
            case 2: {
                this.numPayloadDataBytes = 2;
                break;
            }
            case 3: {
                this.numPayloadDataBytes = 4;
                break;
            }
            default: {
                throw new AssertionError((Object)"Invalid encoding for payload size.");
            }
        }
    }

    static enum State {
        WAITING_FOR_SYNC,
        WAITING_FOR_PACKET_HEADER,
        COLLECTING_LOCAL_TIMESTAMP_PAYLOAD_LTS1,
        COLLECTING_GLOBAL_TIMESTAMP_PAYLOAD_GTS1,
        COLLECTING_GLOBAL_TIMESTAMP_PAYLOAD_GTS2,
        COLLECTING_EXTENSION_PAYLOAD,
        COLLECTING_EXCEPTION_PAYLOAD_1,
        COLLECTING_EXCEPTION_PAYLOAD_2,
        COLLECTING_DATA_TRACE_MATCH_PAYLOAD,
        COLLECTING_DATA_TRACE_PC_VALUE_PAYLOAD,
        COLLECTING_DATA_TRACE_DATA_ADDRESS_PAYLOAD,
        COLLECTING_DATA_TRACE_DATA_VALUE_PAYLOAD,
        COLLECTING_INSTRUMENTATION_OR_HARDWARE_SOURCE_PAYLOAD,
        COLLECTING_EVENT_COUNTER_PAYLOAD,
        COLLECTING_PERIODIC_PC_SAMPLE_PAYLOAD_4BYTES,
        COLLECTING_PERIODIC_PC_SAMPLE_PAYLOAD_1BYTE;

    }
}

