/*
 * Decompiled with CFR 0.152.
 */
package com.arm.utils.text;

import com.arm.utils.text.BasicNumberUtils;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Comparator;

public class NumericStringComparator
implements Comparator<String> {
    public static final NumericStringComparator CASELESS_COMPARATOR = new NumericStringComparator(true);
    public static final NumericStringComparator COMPARATOR = new NumericStringComparator(false);
    private static final String EMPTY = "";
    private boolean mCaseless;

    public static int caselessCompareStrings(String s0, String s1) {
        int result = CASELESS_COMPARATOR.compare(s0, s1);
        if (result == 0) {
            result = COMPARATOR.compare(s0, s1);
        }
        return result;
    }

    public static int compareStrings(String s0, String s1) {
        return COMPARATOR.compare(s0, s1);
    }

    private static final NumberFormat getDecimalFormatter() {
        return BasicNumberUtils.getFormatter(16, 16);
    }

    private static final boolean isNumericPortion(char ch) {
        return ch == '.' || ch == ',' || ch >= '0' && ch <= '9';
    }

    private NumericStringComparator(boolean caseless) {
        this.mCaseless = caseless;
    }

    @Override
    public int compare(String string0, String string1) {
        if (string0 == null) {
            string0 = EMPTY;
        }
        if (string1 == null) {
            string1 = EMPTY;
        }
        NumberFormat formatter = NumericStringComparator.getDecimalFormatter();
        char[] chars0 = string0.toCharArray();
        char[] chars1 = string1.toCharArray();
        int pos0 = 0;
        int pos1 = 0;
        int len0 = chars0.length;
        int len1 = chars1.length;
        int result = 0;
        int secondaryResult = 0;
        while (result == 0 && pos0 < len0 && pos1 < len1) {
            boolean normalCompare = true;
            char c0 = chars0[pos0++];
            char c1 = chars1[pos1++];
            if (NumericStringComparator.isNumericPortion(c0) && NumericStringComparator.isNumericPortion(c1)) {
                int count0 = 1;
                int count1 = 1;
                boolean foundDigit0 = false;
                if (c0 >= '0' && c0 <= '9') {
                    foundDigit0 = true;
                }
                while (pos0 < len0) {
                    c0 = chars0[pos0];
                    if (!NumericStringComparator.isNumericPortion(c0)) break;
                    if (!foundDigit0 && c0 >= '0' && c0 <= '9') {
                        foundDigit0 = true;
                    }
                    ++count0;
                    ++pos0;
                }
                boolean foundDigit1 = false;
                if (c1 >= '0' && c1 <= '9') {
                    foundDigit1 = true;
                }
                while (pos1 < len1) {
                    c1 = chars1[pos1];
                    if (!NumericStringComparator.isNumericPortion(c1)) break;
                    if (!foundDigit1 && c1 >= '0' && c1 <= '9') {
                        foundDigit1 = true;
                    }
                    ++count1;
                    ++pos1;
                }
                boolean haveVal0 = false;
                boolean haveVal1 = false;
                double val0 = 0.0;
                double val1 = 0.0;
                if (foundDigit0) {
                    try {
                        val0 = formatter.parse(string0.substring(pos0 - count0, pos0)).doubleValue();
                        haveVal0 = true;
                    }
                    catch (NumberFormatException | ParseException exception) {
                        // empty catch block
                    }
                }
                if (foundDigit1) {
                    try {
                        val1 = formatter.parse(string1.substring(pos1 - count1, pos1)).doubleValue();
                        haveVal1 = true;
                    }
                    catch (NumberFormatException | ParseException exception) {
                        // empty catch block
                    }
                }
                if (haveVal0 || haveVal1) {
                    normalCompare = false;
                    result = !haveVal1 || val0 > val1 ? 1 : (!haveVal0 || val0 < val1 ? -1 : 0);
                    if (result == 0 && secondaryResult == 0) {
                        secondaryResult = count0 - count1;
                    }
                }
                if (normalCompare) {
                    pos0 -= count0;
                    pos1 -= count1;
                    c0 = chars0[pos0++];
                    c1 = chars1[pos1++];
                }
            }
            if (!normalCompare) continue;
            if (this.mCaseless) {
                char c0Val = Character.isLowerCase(c0) ? Character.toUpperCase(c0) : c0;
                char c1Val = Character.isLowerCase(c1) ? Character.toUpperCase(c1) : c1;
                result = c0Val - c1Val;
                continue;
            }
            result = c0 - c1;
        }
        if (result == 0) {
            result = len0 - pos0 - (len1 - pos1);
        }
        if (result == 0) {
            result = secondaryResult;
        }
        if (result < 0) {
            result = -1;
        } else if (result > 0) {
            result = 1;
        }
        return result;
    }

    public boolean isCaseless() {
        return this.mCaseless;
    }
}

