/*
 * Decompiled with CFR 0.152.
 */
package com.arm.utils.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ByteChannel;
import java.nio.channels.SeekableByteChannel;
import org.eclipse.jdt.annotation.NonNull;

public class ByteChannelUtils {
    public static @NonNull InputStream newInputStream(final @NonNull SeekableByteChannel channel, long position, long size) {
        if (size < 0L) {
            throw new IllegalArgumentException("size must be positive");
        }
        if (position < 0L) {
            throw new IllegalArgumentException("position must be positive");
        }
        if (Long.MAX_VALUE - size < position) {
            throw new IllegalArgumentException("end position has wrapped");
        }
        return new InputStream(position, size){
            final long end;
            long pos;
            {
                this.end = l + l2;
                this.pos = l;
            }

            @Override
            public int available() throws IOException {
                return (int)Math.min(Integer.MAX_VALUE, this.end - this.pos);
            }

            @Override
            public int read() throws IOException {
                int res;
                byte[] bite = new byte[1];
                while ((res = this.read(bite)) == 0) {
                }
                if (res == -1) {
                    return -1;
                }
                if (!$assertionsDisabled && res != 1) {
                    throw new AssertionError();
                }
                return Byte.toUnsignedInt(bite[0]);
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                int available = this.available();
                if (available <= 0) {
                    return -1;
                }
                int allowedLen = Math.min(len, available);
                ByteBuffer dst = ByteBuffer.wrap(b, off, allowedLen);
                channel.position(this.pos);
                int read = channel.read(dst);
                this.pos += (long)read;
                return read;
            }

            @Override
            public long skip(long n) throws IOException {
                long allowedSkip = Math.min(n, this.end - this.pos);
                this.pos += allowedSkip;
                return allowedSkip;
            }
        };
    }

    public static void readBytes(@NonNull ByteChannel channel, @NonNull ByteBuffer buffer) throws IOException {
        ByteChannelUtils.readBytes(channel, buffer, true);
    }

    public static void readBytes(@NonNull ByteChannel channel, @NonNull ByteBuffer buffer, boolean reset) throws IOException {
        if (reset) {
            buffer.position(0);
        }
        while (buffer.hasRemaining()) {
            if (!channel.isOpen()) {
                throw new EOFException();
            }
            if (channel.read(buffer) < 0) break;
        }
    }

    public static byte @NonNull [] readNbytes(@NonNull ByteChannel channel, int n) throws IOException {
        byte @NonNull [] buffer = new byte[n];
        @NonNull ByteBuffer wrapper = ByteBuffer.wrap(buffer);
        ByteChannelUtils.readBytes(channel, wrapper);
        return buffer;
    }

    public static @NonNull ByteBuffer readNbytes(@NonNull ByteChannel channel, int size, @NonNull ByteOrder byteOrder) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(size);
        buffer.order(byteOrder);
        ByteChannelUtils.readBytes(channel, buffer);
        buffer.flip();
        return buffer;
    }

    public static void writeBytes(@NonNull ByteChannel channel, @NonNull ByteBuffer buffer) throws IOException {
        ByteChannelUtils.writeBytes(channel, 0, buffer.capacity(), buffer);
    }

    public static void writeBytes(@NonNull ByteChannel channel, int position, int length, @NonNull ByteBuffer buffer) throws IOException {
        int limit = position + length;
        if (position < 0 || length < 0 || limit > buffer.capacity()) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        buffer.position(position);
        buffer.limit(limit);
        while (n < length) {
            if (!channel.isOpen()) {
                throw new EOFException();
            }
            int l = channel.write(buffer);
            n += l;
        }
    }
}

