/*
 * Decompiled with CFR 0.152.
 */
package com.arm.utils.collections;

import com.arm.utils.NullChecking;
import org.eclipse.jdt.annotation.NonNull;

public class Pair<T, U> {
    public final T first;
    public final U second;

    public static <T extends Comparable<T>, U extends Comparable<U>> int comparator(@NonNull Pair<@NonNull T, @NonNull U> a, @NonNull Pair<@NonNull T, @NonNull U> b) {
        int result = ((Comparable)a.first).compareTo((Comparable)b.first);
        if (result == 0) {
            result = ((Comparable)a.second).compareTo((Comparable)b.second);
        }
        return result;
    }

    public Pair(T first, U second) {
        this.first = first;
        this.second = second;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Pair) {
            Pair that = (Pair)obj;
            return NullChecking.equalsNullable(this.first, that.first) && NullChecking.equalsNullable(this.second, that.second);
        }
        return false;
    }

    public int hashCode() {
        return NullChecking.hashNullable(this.first) * 31 + NullChecking.hashNullable(this.second);
    }

    public String toString() {
        return String.format("{first = %s, second = %s}", this.first, this.second);
    }
}

